/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.fabric.crafting;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTransferable;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import rbasamoyai.createbigcannons.crafting.casting.AbstractCannonCastBlockEntity;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastShape;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastingRecipe;
import rbasamoyai.createbigcannons.index.CBCBlocks;

public class CannonCastBlockEntity
extends AbstractCannonCastBlockEntity
implements FluidTransferable {
    protected FluidTank fluid;
    protected FluidStack leakage = FluidStack.EMPTY;

    public CannonCastBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.fluid = new SmartFluidTank(1L, this::onFluidStackChanged);
    }

    @Nullable
    public Storage<FluidVariant> getFluidStorage(@Nullable class_2350 face) {
        Storage<FluidVariant> storage;
        if (face != class_2350.field_11036) {
            return null;
        }
        if (this.isController()) {
            return this.fluid;
        }
        AbstractCannonCastBlockEntity abstractCannonCastBlockEntity = this.getControllerBE();
        if (abstractCannonCastBlockEntity instanceof CannonCastBlockEntity) {
            CannonCastBlockEntity ccast = (CannonCastBlockEntity)abstractCannonCastBlockEntity;
            storage = ccast.getFluidStorage(face);
        } else {
            storage = null;
        }
        return storage;
    }

    protected void onFluidStackChanged(FluidStack stack) {
        if (!this.method_11002()) {
            return;
        }
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < 3; ++xOffset) {
                for (int zOffset = 0; zOffset < 3; ++zOffset) {
                    class_2338 pos = this.field_11867.method_10069(xOffset, yOffset, zOffset);
                    AbstractCannonCastBlockEntity castAt = (AbstractCannonCastBlockEntity)ConnectivityHandler.partAt((class_2591)this.method_11017(), (class_1922)this.field_11863, (class_2338)pos);
                    if (castAt == null) continue;
                    this.field_11863.method_8455(pos, castAt.method_11010().method_26204());
                }
            }
        }
        if (!this.field_11863.field_9236) {
            this.notifyUpdate();
        }
        if (this.isVirtual()) {
            if (this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
            }
            this.fluidLevel.chase((double)this.getFillState(), 0.5, LerpedFloat.Chaser.EXP);
        }
    }

    @Override
    protected void updateFluids(class_2487 tag) {
        this.fluid.setCapacity((long)this.calculateCapacityFromStructure());
        this.fluid.readFromNBT(tag.method_10562("FluidContent"));
        this.leakage = tag.method_10545("Leakage") ? FluidStack.loadFluidStackFromNBT((class_2487)tag.method_10562("Leakage")) : FluidStack.EMPTY;
    }

    @Override
    protected void updateFluidClient() {
        this.fluid.setCapacity((long)this.calculateCapacityFromStructure());
    }

    @Override
    protected void writeFluidToTag(class_2487 tag) {
        tag.method_10566("FluidContent", (class_2520)this.fluid.writeToNBT(new class_2487()));
        if (!this.leakage.isEmpty()) {
            tag.method_10566("Leakage", (class_2520)this.leakage.writeToNBT(new class_2487()));
        }
    }

    @Override
    protected void leakContents() {
        FluidStack fstack = TransferUtil.extractAnyFluid((Storage)this.fluid, (long)1620L);
        if (!fstack.isEmpty()) {
            if (this.leakage.isEmpty()) {
                this.leakage = fstack;
            } else {
                this.leakage.setAmount(this.leakage.getAmount() + fstack.getAmount());
            }
        }
        if (this.leakage.getAmount() >= 121500L) {
            class_3611 leakFluid = this.leakage.getFluid();
            this.field_11863.method_8652(this.field_11867.method_10074(), leakFluid.method_15785().method_15759(), 11);
            this.leakage.setAmount(this.leakage.getAmount() - 121500L);
        }
    }

    @Override
    protected boolean canStartCasting() {
        return this.fluid.getFluidAmount() >= this.fluid.getCapacity() && !this.fluid.isEmpty();
    }

    @Override
    protected class_3611 getFluid() {
        return this.fluid.getFluid().getFluid();
    }

    @Override
    protected void addStructureCapacityToController(AbstractCannonCastBlockEntity controller) {
        if (controller instanceof CannonCastBlockEntity) {
            CannonCastBlockEntity cController = (CannonCastBlockEntity)controller;
            cController.fluid.setCapacity(cController.fluid.getCapacity() + (long)this.castShape.fluidSize());
        }
    }

    @Override
    protected void reInitTank() {
        this.fluid = new SmartFluidTank((long)this.castShape.fluidSize(), this::onFluidStackChanged);
    }

    @Override
    protected void mergeControllerAndOtherFluids(AbstractCannonCastBlockEntity controller, AbstractCannonCastBlockEntity other) {
        if (controller instanceof CannonCastBlockEntity) {
            CannonCastBlockEntity cController = (CannonCastBlockEntity)controller;
            if (other instanceof CannonCastBlockEntity) {
                CannonCastBlockEntity cOther = (CannonCastBlockEntity)other;
                cController.fluid.setCapacity(cController.fluid.getCapacity() + (long)this.castShape.fluidSize());
                FluidStack extract = TransferUtil.extractAnyFluid((Storage)cOther.fluid, (long)cOther.fluid.getCapacity());
                if (!extract.isEmpty()) {
                    TransferUtil.insertFluid((Storage)cController.fluid, (FluidStack)extract);
                }
                cOther.fluid = new FluidTank(1L);
            }
        }
    }

    @Override
    protected void onDestroyCenterCast() {
        CannonCastBlockEntity controller = (CannonCastBlockEntity)this.getControllerBE();
        if (controller == null) {
            return;
        }
        int thisIndex = this.field_11867.method_10264() - controller.field_11867.method_10264();
        --controller.height;
        int capacityUpTo = controller.structure.subList(0, class_3532.method_15340((int)thisIndex, (int)0, (int)controller.structure.size())).stream().map(CannonCastShape::fluidSize).reduce(Integer::sum).orElse(0);
        long leakAmount = class_3532.method_24156((long)(controller.fluid.getFluidAmount() - (long)capacityUpTo), (long)0L, (long)this.castShape.fluidSize());
        FluidStack addLeak = leakAmount < 1L ? FluidStack.EMPTY : TransferUtil.extractAnyFluid((Storage)controller.fluid, (long)leakAmount);
        controller.fluid.setCapacity(Math.max(1L, controller.fluid.getCapacity() - (long)this.castShape.fluidSize()));
        FluidStack remaining = controller.fluid.getFluid();
        if (controller == this && this.height > 0) {
            class_2586 class_25862 = this.field_11863.method_8321(this.field_11867.method_10084());
            if (class_25862 instanceof CannonCastBlockEntity) {
                CannonCastBlockEntity otherCast = (CannonCastBlockEntity)class_25862;
                otherCast.controllerPos = null;
                otherCast.height = this.height;
                otherCast.structure = CannonCastBlockEntity.getStructureFromPoint(this.field_11863, this.field_11867.method_10084(), this.height);
                otherCast.fluid = new SmartFluidTank((long)otherCast.calculateCapacityFromStructure(), otherCast::onFluidStackChanged);
                if (!remaining.isEmpty()) {
                    TransferUtil.insertFluid((Storage)otherCast.fluid, (FluidStack)remaining);
                }
                otherCast.updatePotentialCastsAbove();
                otherCast.notifyUpdate();
            }
        } else {
            int oldHeight = controller.height;
            controller.height = thisIndex;
            controller.structure = controller.structure.subList(0, class_3532.method_15340((int)thisIndex, (int)0, (int)controller.structure.size()));
            controller.fluid = new SmartFluidTank((long)controller.calculateCapacityFromStructure(), controller::onFluidStackChanged);
            if (!remaining.isEmpty()) {
                long firstRemaining = remaining.getAmount() - TransferUtil.insertFluid((Storage)controller.fluid, (FluidStack)remaining);
                if (!remaining.isEmpty()) {
                    remaining.setAmount(firstRemaining);
                }
            }
            controller.updateRecipes = true;
            controller.notifyUpdate();
            class_2586 class_25863 = this.field_11863.method_8321(this.field_11867.method_10084());
            if (class_25863 instanceof CannonCastBlockEntity) {
                CannonCastBlockEntity otherCast = (CannonCastBlockEntity)class_25863;
                otherCast.controllerPos = null;
                otherCast.height = oldHeight - controller.height;
                otherCast.structure = CannonCastBlockEntity.getStructureFromPoint(this.field_11863, this.field_11867.method_10084(), otherCast.height);
                otherCast.fluid = new SmartFluidTank((long)otherCast.calculateCapacityFromStructure(), otherCast::onFluidStackChanged);
                if (!remaining.isEmpty()) {
                    TransferUtil.insertFluid((Storage)otherCast.fluid, (FluidStack)remaining);
                }
                otherCast.updatePotentialCastsAbove();
                otherCast.updateRecipes = true;
                otherCast.notifyUpdate();
            }
        }
        if (this.castShape.isLarge()) {
            for (class_2338 pos : class_2338.method_10097((class_2338)this.field_11867.method_10069(-1, 0, -1), (class_2338)this.field_11867.method_10069(1, 0, 1))) {
                if (!CBCBlocks.CANNON_CAST.has(this.field_11863.method_8320(pos))) continue;
                this.field_11863.method_8652(pos, class_2246.field_10124.method_9564(), 11);
            }
        }
        if (!addLeak.isEmpty()) {
            class_3611 fluid = addLeak.getFluid();
            long amount = addLeak.getAmount() - 20250L;
            if (fluid instanceof class_3609) {
                class_3609 flowing = (class_3609)fluid;
                int fluidLevel = Math.max((int)Math.floorDiv(amount * 8L, 81000), 0);
                if (fluidLevel > 0) {
                    this.field_11863.method_8652(this.field_11867, flowing.method_15728(fluidLevel, this.field_11863.method_8320(this.field_11867.method_10074()).method_26215()).method_15759(), 11);
                }
            } else if (amount >= 81000L) {
                this.field_11863.method_8652(this.field_11867, addLeak.getFluid().method_15785().method_15759(), 11);
            }
        }
    }

    @Override
    public float getFillState() {
        return this.fluid.getCapacity() == 0L ? 0.0f : (float)this.fluid.getFluidAmount() / (float)this.fluid.getCapacity();
    }

    @Override
    protected void refreshCap() {
    }

    @Override
    protected boolean testWithFluid(CannonCastingRecipe recipe) {
        CannonCastBlockEntity cController = (CannonCastBlockEntity)this.getControllerBE();
        if (cController == null || cController.fluid.getFluid().isEmpty()) {
            return false;
        }
        return recipe.ingredient().test(cController.fluid.getFluid());
    }

    @Override
    public boolean tryEmptyItemIntoBE(class_1937 worldIn, class_1657 player, class_1268 handIn, class_1799 heldItem, class_2350 side) {
        return FluidHelper.tryEmptyItemIntoBE((class_1937)worldIn, (class_1657)player, (class_1268)handIn, (class_1799)heldItem, (SmartBlockEntity)this, (class_2350)side);
    }

    @Override
    public boolean tryFillItemFromBE(class_1937 world, class_1657 player, class_1268 handIn, class_1799 heldItem, class_2350 side) {
        return FluidHelper.tryFillItemFromBE((class_1937)world, (class_1657)player, (class_1268)handIn, (class_1799)heldItem, (SmartBlockEntity)this, (class_2350)side);
    }
}

