/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.fabric.cannons;

import io.github.fabricators_of_create.porting_lib.transfer.StorageViewArrayIterator;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;
import rbasamoyai.createbigcannons.fabric.cannons.AutocannonBreechBlockEntity;
import rbasamoyai.createbigcannons.fabric.cannons.AutocannonBreechSlotView;
import rbasamoyai.createbigcannons.munitions.autocannon.AutocannonAmmoItem;

public class AutocannonBreechInterface
extends SnapshotParticipant<BreechSnapshot>
implements Storage<ItemVariant> {
    private final AutocannonBreechBlockEntity breech;
    private final AutocannonBreechSlotView[] views;

    public AutocannonBreechInterface(AutocannonBreechBlockEntity breech) {
        this.breech = breech;
        this.views = new AutocannonBreechSlotView[2];
        this.views[0] = new AutocannonBreechSlotView(this, true);
        this.views[1] = new AutocannonBreechSlotView(this, false);
    }

    public boolean isItemValid(@Nonnull class_1799 stack) {
        return stack.method_7909() instanceof AutocannonAmmoItem;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (maxAmount < 1L) {
            return 0L;
        }
        class_1799 stack = resource.toStack();
        if (!this.isItemValid(stack) || this.breech.isInputFull()) {
            return 0L;
        }
        Deque<class_1799> input = this.breech.getInputBuffer();
        long maxCount = Math.min(this.breech.getQueueLimit() - input.size(), stack.method_7947());
        maxCount = Math.min(maxCount, maxAmount);
        for (long i = 0L; i < maxCount; ++i) {
            this.updateSnapshots(transaction);
            input.add(ItemHandlerHelper.copyStackWithSize((class_1799)stack, (int)1));
        }
        return maxCount;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        class_1799 output = this.breech.getOutputBuffer();
        if (maxAmount < 1L || output.method_7960()) {
            return 0L;
        }
        if (this.breech.getOutputBuffer().method_7909() != resource.getItem()) {
            return 0L;
        }
        this.updateSnapshots(transaction);
        this.breech.getOutputBuffer().method_7971(1);
        return 1L;
    }

    public Iterator<StorageView<ItemVariant>> iterator(TransactionContext transaction) {
        return new StorageViewArrayIterator((StorageView[])this.views);
    }

    protected BreechSnapshot createSnapshot() {
        return new BreechSnapshot(this);
    }

    protected void readSnapshot(BreechSnapshot snapshot) {
        snapshot.apply(this);
    }

    @Nonnull
    public class_1799 getStack(boolean isInput) {
        if (isInput) {
            Deque<class_1799> inputBuffer = this.breech.getInputBuffer();
            return this.breech.isInputFull() && !inputBuffer.isEmpty() ? inputBuffer.peekLast() : class_1799.field_8037;
        }
        return this.breech.getOutputBuffer();
    }

    public void restoreViewSnapshot(boolean isInput, class_1799 stack) {
        if (isInput) {
            Deque<class_1799> buf = this.breech.getInputBuffer();
            if (!stack.method_7960() && !buf.isEmpty()) {
                buf.removeLast();
                buf.addLast(stack);
            }
        } else {
            this.breech.setOutputBuffer(stack);
        }
    }

    public static class BreechSnapshot {
        private final List<class_1799> inputBuffer;
        private final class_1799 outputBuffer;

        public BreechSnapshot(AutocannonBreechInterface inventory) {
            this.inputBuffer = inventory.breech.getInputBuffer().stream().map(class_1799::method_7972).toList();
            this.outputBuffer = inventory.breech.getOutputBuffer().method_7972();
        }

        public void apply(AutocannonBreechInterface inventory) {
            inventory.breech.getInputBuffer().clear();
            inventory.breech.getInputBuffer().addAll(this.inputBuffer);
            inventory.breech.setOutputBuffer(this.outputBuffer);
        }
    }
}

