/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.effects.particles.explosions;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3998;
import net.minecraft.class_4066;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import rbasamoyai.createbigcannons.CBCClientCommon;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.effects.particles.explosions.ShellExplosionCloudParticleData;
import rbasamoyai.createbigcannons.effects.particles.smoke.ShellExplosionSmokeParticleData;

public class ShellExplosionCloudParticle
extends class_3998 {
    private final float power;
    private final List<TrailSubparticle> trails = new LinkedList<TrailSubparticle>();
    private final boolean isPlume;

    ShellExplosionCloudParticle(class_638 level, double x, double y, double z, double dx, double dy, double dz, float power, boolean isPlume) {
        super(level, x, y, z);
        this.field_3852 = dx;
        this.field_3869 = dy;
        this.field_3850 = dz;
        this.power = power;
        this.isPlume = isPlume;
        if (((Boolean)CBCConfigs.CLIENT.showExtraShellExplosionTrails.get()).booleanValue()) {
            double secondaryVelScale = (double)this.power * 0.35;
            int secondaryCount = switch (CBCClientCommon.getParticleStatus()) {
                default -> throw new IncompatibleClassChangeError();
                case class_4066.field_18197 -> 12 + this.field_3840.nextInt(6);
                case class_4066.field_18198 -> 6 + this.field_3840.nextInt(3);
                case class_4066.field_18199 -> 4;
            };
            double gravity = this.isPlume ? -0.5 : -0.1;
            for (int i = 0; i < secondaryCount; ++i) {
                double rx = this.field_3840.nextDouble() - this.field_3840.nextDouble();
                double ry = this.field_3840.nextDouble() - this.field_3840.nextDouble();
                double rz = this.field_3840.nextDouble() - this.field_3840.nextDouble();
                double dx1 = this.field_3840.nextDouble() - this.field_3840.nextDouble();
                double dy1 = this.field_3840.nextDouble() - this.field_3840.nextDouble();
                if (this.isPlume) {
                    dy1 += 2.0;
                }
                double dz1 = this.field_3840.nextDouble() - this.field_3840.nextDouble();
                int lifetime = 5;
                this.trails.add(new TrailSubparticle(new class_243(rx, ry, rz).method_1021(2.5), new class_243(dx1, dy1, dz1).method_1021(secondaryVelScale), 0.85, gravity, lifetime));
            }
        }
    }

    public void method_3070() {
        int PLUME_AGE = 5;
        if (this.field_3866 < PLUME_AGE) {
            float primaryScale = this.power * 2.0f;
            int plumes = switch (CBCClientCommon.getParticleStatus()) {
                default -> throw new IncompatibleClassChangeError();
                case class_4066.field_18197 -> 20;
                case class_4066.field_18198 -> 10;
                case class_4066.field_18199 -> 5;
            };
            double velScale = (double)this.power * 0.25;
            velScale *= (double)(1.0f - (float)this.field_3866 / (float)PLUME_AGE);
            double displacementScale = (double)this.power * 0.35;
            for (int i = 0; i <= plumes; ++i) {
                double rx = this.field_3874 + (this.field_3840.nextDouble() - this.field_3840.nextDouble()) * displacementScale;
                double ry = this.field_3840.nextDouble() - this.field_3840.nextDouble();
                if (this.isPlume) {
                    ry = Math.abs(ry);
                }
                ry *= displacementScale;
                ry += this.field_3854 + 0.5;
                double rz = this.field_3871 + (this.field_3840.nextDouble() - this.field_3840.nextDouble()) * displacementScale;
                double dx = (this.field_3840.nextDouble() - this.field_3840.nextDouble()) * velScale;
                double dy = this.field_3840.nextDouble() - this.field_3840.nextDouble();
                if (this.isPlume) {
                    dy += 1.2;
                }
                double dz = (this.field_3840.nextDouble() - this.field_3840.nextDouble()) * velScale;
                int lifetime = 160 + this.field_3840.nextInt(80);
                this.field_3851.method_8466((class_2394)new ShellExplosionSmokeParticleData(lifetime, primaryScale), true, rx, ry, rz, dx, dy *= velScale, dz);
            }
        }
        int trailSteps = CBCClientCommon.getParticleStatus() == class_4066.field_18197 ? 2 : 1;
        float secondaryScale = this.power * 0.75f;
        Iterator<TrailSubparticle> iter = this.trails.iterator();
        while (iter.hasNext()) {
            TrailSubparticle trail = iter.next();
            if (this.field_3866 > trail.lifetime) {
                iter.remove();
                continue;
            }
            class_243 origin = trail.calculateDisplacement(this.field_3866);
            class_243 next = trail.calculateDisplacement(this.field_3866 + 1);
            double velScale = 0.125;
            double displacementScale = 0.1;
            for (int i = 0; i <= trailSteps; ++i) {
                class_243 pos = origin.method_35590(next, (double)i / (double)trailSteps).method_1031(this.field_3874, this.field_3854, this.field_3871);
                double rx = pos.field_1352 + (this.field_3840.nextDouble() - this.field_3840.nextDouble()) * displacementScale;
                double ry = pos.field_1351 + (this.field_3840.nextDouble() - this.field_3840.nextDouble()) * displacementScale;
                double rz = pos.field_1350 + (this.field_3840.nextDouble() - this.field_3840.nextDouble()) * displacementScale;
                double dx = (this.field_3840.nextDouble() - this.field_3840.nextDouble()) * velScale;
                double dy = (this.field_3840.nextDouble() - this.field_3840.nextDouble()) * velScale;
                double dz = (this.field_3840.nextDouble() - this.field_3840.nextDouble()) * velScale;
                int lifetime = 30 + this.field_3840.nextInt(15);
                this.field_3851.method_8466((class_2394)new ShellExplosionSmokeParticleData(lifetime, secondaryScale), true, rx, ry, rz, dx, dy, dz);
            }
        }
        super.method_3070();
    }

    private record TrailSubparticle(class_243 displacement, class_243 vel, double drag, double gravity, int lifetime) {
        public class_243 calculateDisplacement(int ticks) {
            if (ticks <= 0) {
                return this.displacement;
            }
            if (this.drag == 1.0) {
                return this.displacement.method_1019(this.vel.method_1021((double)ticks));
            }
            double geo = (1.0 - Math.pow(this.drag, ticks)) / (1.0 - this.drag);
            return this.displacement.method_1019(this.vel.method_1021(geo)).method_1031(0.0, this.gravity * (double)ticks, 0.0);
        }
    }

    public static class Provider
    implements class_707<ShellExplosionCloudParticleData> {
        @Nullable
        public class_703 createParticle(ShellExplosionCloudParticleData type, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            if (!((Boolean)CBCConfigs.CLIENT.showShellExplosionClouds.get()).booleanValue()) {
                return null;
            }
            ShellExplosionCloudParticle particle = new ShellExplosionCloudParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, type.scale(), type.isPlume());
            particle.method_3077(10);
            return particle;
        }
    }
}

