/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.effects.particles.explosions;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function7;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.particle.ICustomParticleData;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2540;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public abstract class AbstractBlastWaveEffectParticleData<DATA extends AbstractBlastWaveEffectParticleData<DATA>>
implements class_2394,
ICustomParticleData<DATA> {
    private final double blastRadius;
    private final class_3414 soundEvent;
    private final class_3419 soundSource;
    private final float volume;
    private final float pitch;
    private final float airAbsorption;
    private final float power;

    protected static <DATA extends AbstractBlastWaveEffectParticleData<DATA>> class_2394.class_2395<DATA> createDeserializer(final Constructor<DATA> cons) {
        return new class_2394.class_2395<DATA>(){

            public DATA fromCommand(class_2396<DATA> particleType, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                double blastRadius = reader.readDouble();
                reader.expect(' ');
                String eventStr = reader.readString();
                class_3414 soundEvent = CBCRegistryUtils.getSoundEvent(CBCUtils.location(eventStr));
                if (soundEvent == null) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().create();
                }
                reader.expect(' ');
                String sourceStr = reader.readString();
                class_3419 soundSource = CBCUtils.soundSourceFromName(sourceStr);
                if (soundSource == null) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().create();
                }
                reader.expect(' ');
                float volume = reader.readFloat();
                reader.expect(' ');
                float pitch = reader.readFloat();
                reader.expect(' ');
                float airAbsorption = reader.readFloat();
                reader.expect(' ');
                float power = reader.readFloat();
                return (AbstractBlastWaveEffectParticleData)cons.apply(blastRadius, soundEvent, soundSource, Float.valueOf(volume), Float.valueOf(pitch), Float.valueOf(airAbsorption), Float.valueOf(power));
            }

            public DATA fromNetwork(class_2396<DATA> particleType, class_2540 buffer) {
                double blastRadius = buffer.readDouble();
                class_3414 soundEvent = CBCRegistryUtils.getSoundEvent(buffer.method_10816());
                class_3419 soundSource = (class_3419)buffer.method_10818(class_3419.class);
                float volume = buffer.readFloat();
                float pitch = buffer.readFloat();
                float airAbsorption = buffer.readFloat();
                float power = buffer.readFloat();
                return (AbstractBlastWaveEffectParticleData)cons.apply(blastRadius, soundEvent, soundSource, Float.valueOf(volume), Float.valueOf(pitch), Float.valueOf(airAbsorption), Float.valueOf(power));
            }
        };
    }

    protected static <DATA extends AbstractBlastWaveEffectParticleData<DATA>> Codec<DATA> createCodec(Constructor<DATA> cons) {
        return RecordCodecBuilder.create(i -> i.group((App)Codec.DOUBLE.fieldOf("blastRadius").forGetter(AbstractBlastWaveEffectParticleData::blastRadius), (App)class_3414.field_24628.fieldOf("soundEvent").forGetter(AbstractBlastWaveEffectParticleData::soundEvent), (App)CBCUtils.SOUND_SOURCE_CODEC.fieldOf("soundSource").forGetter(AbstractBlastWaveEffectParticleData::soundSource), (App)Codec.FLOAT.fieldOf("volume").forGetter(AbstractBlastWaveEffectParticleData::volume), (App)Codec.FLOAT.fieldOf("pitch").forGetter(AbstractBlastWaveEffectParticleData::pitch), (App)Codec.FLOAT.fieldOf("airAbsorption").forGetter(AbstractBlastWaveEffectParticleData::airAbsorption), (App)Codec.FLOAT.fieldOf("power").forGetter(AbstractBlastWaveEffectParticleData::power)).apply((Applicative)i, (Function7)cons));
    }

    protected AbstractBlastWaveEffectParticleData(double blastRadius, class_3414 soundEvent, class_3419 soundSource, float volume, float pitch, float airAbsorption, float power) {
        this.blastRadius = blastRadius;
        this.soundEvent = soundEvent;
        this.soundSource = soundSource;
        this.volume = volume;
        this.pitch = pitch;
        this.airAbsorption = airAbsorption;
        this.power = power;
    }

    protected AbstractBlastWaveEffectParticleData() {
        this(0.0, class_3417.field_15152, class_3419.field_15245, 1.0f, 1.0f, 0.0f, 0.0f);
    }

    public double blastRadius() {
        return this.blastRadius;
    }

    public class_3414 soundEvent() {
        return this.soundEvent;
    }

    public class_3419 soundSource() {
        return this.soundSource;
    }

    public float volume() {
        return this.volume;
    }

    public float pitch() {
        return this.pitch;
    }

    public float airAbsorption() {
        return this.airAbsorption;
    }

    public float power() {
        return this.power;
    }

    public void method_10294(class_2540 buffer) {
        buffer.writeDouble(this.blastRadius);
        buffer.method_10804(CBCRegistryUtils.getSoundEventNumericId(this.soundEvent)).method_10817((Enum)this.soundSource).writeFloat(this.volume).writeFloat(this.pitch).writeFloat(this.airAbsorption).writeFloat(this.power);
    }

    public String method_10293() {
        return String.format("%f %s %s %f %f %f %f", this.blastRadius, CBCRegistryUtils.getSoundEventLocation(this.soundEvent).toString(), this.soundSource.method_14840(), Float.valueOf(this.volume), Float.valueOf(this.pitch), Float.valueOf(this.airAbsorption), Float.valueOf(this.power));
    }

    public static interface Constructor<DATA extends AbstractBlastWaveEffectParticleData<DATA>>
    extends Function7<Double, class_3414, class_3419, Float, Float, Float, Float, DATA> {
    }
}

