/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.datagen.recipes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import rbasamoyai.createbigcannons.datagen.recipes.BuiltUpHeatingRecipeProvider;
import rbasamoyai.createbigcannons.datagen.recipes.CannonCastRecipeProvider;
import rbasamoyai.createbigcannons.datagen.recipes.DrillBoringRecipeProvider;
import rbasamoyai.createbigcannons.datagen.recipes.FinishedBlockRecipe;

public abstract class BlockRecipeProvider
implements class_2405 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final class_2403 gen;
    protected final String modid;
    protected class_2960 info;
    protected static final List<BlockRecipeProvider> GENERATORS = new ArrayList<BlockRecipeProvider>();

    public BlockRecipeProvider(String modid, class_2403 gen) {
        this.modid = modid;
        this.gen = gen;
    }

    public static void registerAll(class_2403 gen) {
        GENERATORS.add(new CannonCastRecipeProvider(gen));
        GENERATORS.add(new BuiltUpHeatingRecipeProvider(gen));
        GENERATORS.add(new DrillBoringRecipeProvider(gen));
        gen.method_10314(new class_2405(){

            public void method_10319(class_2408 cache) throws IOException {
                GENERATORS.forEach(gen -> {
                    try {
                        gen.method_10319(cache);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }

            public String method_10321() {
                return "Create Big Cannons Block Recipes";
            }
        });
    }

    public void method_10319(class_2408 cache) throws IOException {
        Path path = this.gen.method_10313();
        HashSet set = new HashSet();
        this.registerRecipes(recipe -> {
            if (!set.add(recipe.id())) {
                throw new IllegalStateException("Duplicate block recipe " + recipe.id());
            }
            BlockRecipeProvider.saveRecipe(cache, recipe.serializeRecipe(), path.resolve("data/" + recipe.id().method_12836() + "/block_recipes/" + recipe.id().method_12832() + ".json"));
        });
    }

    private static void saveRecipe(class_2408 cache, JsonObject obj, Path path) {
        try {
            String s = GSON.toJson((JsonElement)obj);
            String s1 = field_11280.hashUnencodedChars((CharSequence)s).toString();
            if (!Objects.equals(cache.method_10323(path), s1) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    writer.write(s);
                }
            }
            cache.method_10325(path, s1);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't save block recipe {}", (Object)path, (Object)e);
        }
    }

    protected abstract void registerRecipes(Consumer<FinishedBlockRecipe> var1);

    public String method_10321() {
        return "Create Big Cannons Block Recipes: " + (Comparable)((Object)(this.info == null ? "unknown id" : this.info));
    }
}

