/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.casting;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_5250;
import rbasamoyai.createbigcannons.base.CBCRegistries;
import rbasamoyai.createbigcannons.cannons.CannonBehavior;
import rbasamoyai.createbigcannons.cannons.ICannonBlockEntity;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.crafting.BlockRecipe;
import rbasamoyai.createbigcannons.crafting.BlockRecipeFinder;
import rbasamoyai.createbigcannons.crafting.WandActionable;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastShape;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastingRecipe;
import rbasamoyai.createbigcannons.crafting.casting.FinishedCannonCastBlockEntity;
import rbasamoyai.createbigcannons.crafting.casting.FluidCastingTimeHandler;
import rbasamoyai.createbigcannons.crafting.casting.InvalidCastingError;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public abstract class AbstractCannonCastBlockEntity
extends SmartBlockEntity
implements WandActionable,
IMultiBlockEntityContainer,
IHaveHoveringInformation {
    private static final Object CASTING_RECIPES_KEY = new Object();
    protected List<CannonCastShape> structure = new ArrayList<CannonCastShape>();
    protected CannonCastShape castShape = null;
    protected class_2338 controllerPos;
    protected class_2338 lastKnownPos;
    protected int height = 1;
    protected boolean forceFluidLevelUpdate = true;
    protected boolean forceCastLevelUpdate = true;
    protected int castingTime;
    protected int startCastingTime = 1;
    protected Map<CannonCastShape, CannonCastingRecipe> recipes = new HashMap<CannonCastShape, CannonCastingRecipe>();
    protected List<class_2680> resultPreview = new ArrayList<class_2680>();
    protected InvalidCastingError invalidCastingError = null;
    protected int castDelay = 0;
    protected boolean updateRecipes = true;
    private boolean firstLoadUpdate = true;
    private static final int SYNC_RATE = 8;
    protected boolean queuedSync;
    protected int syncCooldown;
    protected LerpedFloat fluidLevel;
    protected LerpedFloat castLevel;

    public AbstractCannonCastBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.field_11863.field_9236) {
            this.invalidateRenderBoundingBox();
        }
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        if (this.canRenderCastModel() && this.castShape != null) {
            tag.method_10582("Size", CBCRegistries.CANNON_CAST_SHAPES.method_10221((Object)this.castShape).toString());
        }
        if (this.lastKnownPos != null) {
            tag.method_10566("LastKnownPos", (class_2520)class_2512.method_10692((class_2338)this.lastKnownPos));
        }
        if (this.isController()) {
            if (!this.structure.isEmpty()) {
                class_2499 structureTag = new class_2499();
                for (CannonCastShape sz : this.structure) {
                    structureTag.add((Object)class_2519.method_23256((String)CBCRegistries.CANNON_CAST_SHAPES.method_10221((Object)sz).toString()));
                }
                tag.method_10566("Structure", (class_2520)structureTag);
            }
            tag.method_10569("Height", this.height);
            tag.method_10569("CastingTime", this.castingTime);
            this.writeFluidToTag(tag);
            if (this.startCastingTime > 1) {
                tag.method_10569("StartCastingTime", this.startCastingTime);
            }
            if (this.updateRecipes) {
                tag.method_10556("UpdateRecipes", true);
            }
            if (!this.recipes.isEmpty() && !this.structure.isEmpty()) {
                class_2499 previewList = new class_2499();
                for (CannonCastShape shape : this.structure) {
                    if (this.recipes.containsKey(shape)) {
                        class_2680 state = this.recipes.get(shape).getResultBlock().method_9564();
                        if (state.method_28498((class_2769)class_2741.field_12525)) {
                            state = (class_2680)state.method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11033);
                        }
                        previewList.add((Object)class_2512.method_10686((class_2680)shape.applyTo(state)));
                        continue;
                    }
                    previewList.add((Object)new class_2487());
                }
                tag.method_10566("Preview", (class_2520)previewList);
            }
            InvalidCastingError.write(tag, this.invalidCastingError);
            tag.method_10569("CastingDelay", this.castDelay);
        } else {
            tag.method_10566("Controller", (class_2520)class_2512.method_10692((class_2338)this.controllerPos));
        }
        super.write(tag, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.forceFluidLevelUpdate) {
            tag.method_10556("ForceFluidLevel", true);
        }
        if (this.forceCastLevelUpdate) {
            tag.method_10556("ForceCastLevel", true);
        }
        if (this.queuedSync) {
            tag.method_10556("LazySync", true);
        }
        this.forceFluidLevelUpdate = false;
        this.forceCastLevelUpdate = false;
    }

    protected abstract void writeFluidToTag(class_2487 var1);

    protected void read(class_2487 tag, boolean clientPacket) {
        boolean changeOfController;
        super.read(tag, clientPacket);
        class_2338 controllerBefore = this.controllerPos;
        int prevHeight = this.getControllerBE() == null ? 0 : this.getControllerBE().height;
        CannonCastShape cannonCastShape = this.castShape = tag.method_10545("Size") ? (CannonCastShape)CBCRegistries.CANNON_CAST_SHAPES.method_10223(CBCUtils.location(tag.method_10558("Size"))) : null;
        if (tag.method_10545("LastKnownPos")) {
            this.lastKnownPos = class_2512.method_10691((class_2487)tag.method_10562("LastKnownPos"));
        }
        this.structure.clear();
        if (tag.method_10545("Structure")) {
            class_2499 list = tag.method_10554("Structure", 8);
            for (int i = 0; i < list.size(); ++i) {
                CannonCastShape shape = (CannonCastShape)CBCRegistries.CANNON_CAST_SHAPES.method_10223(CBCUtils.location(list.method_10608(i)));
                this.structure.add(shape == null ? CannonCastShape.VERY_SMALL : shape);
            }
            this.height = tag.method_10550("Height");
            this.updateFluids(tag);
            this.castingTime = Math.max(tag.method_10550("CastingTime"), 0);
            this.startCastingTime = Math.max(tag.method_10550("StartCastingTime"), 1);
            this.updateRecipes = this.firstLoadUpdate || tag.method_10545("UpdateRecipes");
            this.resultPreview.clear();
            class_2499 preview = tag.method_10554("Preview", 10);
            for (int i = 0; i < preview.size(); ++i) {
                this.resultPreview.add(class_2512.method_10681((class_2487)preview.method_10602(i)));
            }
            this.invalidCastingError = InvalidCastingError.read(tag);
            this.castDelay = tag.method_10550("CastingDelay");
            this.controllerPos = null;
        } else if (tag.method_10545("Controller")) {
            this.controllerPos = class_2512.method_10691((class_2487)tag.method_10562("Controller"));
        }
        if (tag.method_10545("ForceFluidLevel") || this.fluidLevel == null) {
            this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
        }
        if (tag.method_10545("ForceCastLevel") || this.castLevel == null) {
            this.castLevel = LerpedFloat.linear().startWithValue((double)this.getCastingState());
        }
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controllerPos);
        if (changeOfController || this.getControllerBE() != null && prevHeight != this.getControllerBE().height) {
            if (this.method_11002()) {
                this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 16);
            }
            if (this.isController()) {
                this.updateFluidClient();
            }
            this.invalidateRenderBoundingBox();
        }
        if (this.isController()) {
            float fillState = this.getFillState();
            if (tag.method_10545("ForceFluidLevel") || this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)fillState);
            }
            this.fluidLevel.chase((double)fillState, 0.5, LerpedFloat.Chaser.EXP);
            float castState = this.getCastingState();
            if (tag.method_10545("ForceCastLevel") || this.castLevel == null) {
                this.castLevel = LerpedFloat.linear().startWithValue((double)castState);
            }
            this.castLevel.chase((double)castState, 0.5, LerpedFloat.Chaser.EXP);
        }
        if (tag.method_10545("LazySync")) {
            this.fluidLevel.chase((double)this.fluidLevel.getChaseTarget(), 0.125, LerpedFloat.Chaser.EXP);
            this.castLevel.chase((double)this.castLevel.getChaseTarget(), 0.125, LerpedFloat.Chaser.EXP);
        }
        this.firstLoadUpdate = false;
    }

    protected abstract void updateFluids(class_2487 var1);

    protected abstract void updateFluidClient();

    public void tick() {
        super.tick();
        this.invalidateRenderBoundingBox();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.field_11867;
        } else if (!this.lastKnownPos.equals((Object)this.field_11867) && this.field_11867 != null) {
            this.onPositionChanged();
            return;
        }
        if (this.fluidLevel != null) {
            this.fluidLevel.tickChaser();
        }
        if (this.castLevel != null) {
            this.castLevel.tickChaser();
        }
        if (this.isController()) {
            this.tickCastingBehavior();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.field_11867;
    }

    protected void tickCastingBehavior() {
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.castDelay > 0) {
            --this.castDelay;
            this.notifyUpdate();
        }
        if (this.field_11863.method_8320(this.field_11867.method_10074()).method_26207().method_15800()) {
            this.leakContents();
        } else if (this.canStartCasting() && this.castDelay <= 0) {
            if (this.updateRecipes) {
                this.invalidCastingError = null;
                this.updateRecipes();
                if (this.invalidCastingError == null) {
                    int oldStartCastingTime = this.startCastingTime;
                    this.startCastingTime = FluidCastingTimeHandler.getCastingTime(this.getFluid());
                    if (this.startCastingTime != oldStartCastingTime) {
                        this.castingTime = this.startCastingTime;
                    }
                    this.updateRecipes = false;
                } else {
                    this.startCastingTime = 1;
                    this.castingTime = 0;
                    this.castDelay = 8;
                    this.recipes.clear();
                    this.notifyUpdate();
                    return;
                }
            }
            --this.castingTime;
            this.notifyUpdate();
            if (this.castingTime <= 0) {
                this.finishCasting();
                return;
            }
        } else {
            this.startCastingTime = 1;
            this.castingTime = 0;
            this.updateRecipes = true;
        }
    }

    protected abstract void leakContents();

    protected abstract boolean canStartCasting();

    protected void updateRecipes() {
        this.recipes.clear();
        List<BlockRecipe> list = BlockRecipeFinder.get(CASTING_RECIPES_KEY, this.field_11863, this::matchingRecipeCache);
        list.stream().map(CannonCastingRecipe.class::cast).filter(r -> r.matches(this.field_11863, this.field_11867)).forEach(r -> this.recipes.put(r.shape(), (CannonCastingRecipe)r));
        ListIterator<CannonCastShape> iter = this.structure.listIterator();
        while (iter.hasNext()) {
            int i = iter.nextIndex();
            CannonCastShape shape = iter.next();
            if (this.recipes.containsKey(shape)) continue;
            this.invalidCastingError = new InvalidCastingError(this.field_11867.method_10086(i), this.getFluid(), shape);
            return;
        }
    }

    protected boolean matchingRecipeCache(BlockRecipe recipe) {
        return recipe instanceof CannonCastingRecipe;
    }

    protected abstract class_3611 getFluid();

    protected void finishCasting() {
        if (!this.isController() || this.structure.isEmpty()) {
            return;
        }
        for (int y = 0; y < this.height; ++y) {
            ICannonBlockEntity cbe1;
            ICannonBlockEntity cbe;
            class_2586 class_25862;
            class_2338 pos;
            class_2586 class_25863;
            if (this.structure.size() <= y) continue;
            CannonCastingRecipe recipe = this.recipes.get(this.structure.get(y));
            if (recipe == null || !((class_25863 = this.field_11863.method_8321(pos = this.field_11867.method_10086(y))) instanceof AbstractCannonCastBlockEntity)) break;
            AbstractCannonCastBlockEntity cast = (AbstractCannonCastBlockEntity)class_25863;
            class_2338 corner = pos.method_10069(-1, 0, -1);
            if (cast.getRenderedSize().isLarge()) {
                class_2338.method_20437((class_2338)corner, (class_2338)pos.method_10069(1, 0, 1)).forEach(pos1 -> {
                    class_2586 patt12829$temp;
                    if (pos.equals(pos1) || !((patt12829$temp = this.field_11863.method_8321(pos1)) instanceof AbstractCannonCastBlockEntity)) {
                        return;
                    }
                    AbstractCannonCastBlockEntity cast1 = (AbstractCannonCastBlockEntity)patt12829$temp;
                    cast1.method_11012();
                    this.field_11863.method_8652(pos1, CBCBlocks.FINISHED_CANNON_CAST.getDefaultState(), 11);
                    class_2586 patt13046$temp = this.field_11863.method_8321(pos1);
                    if (!(patt13046$temp instanceof FinishedCannonCastBlockEntity)) {
                        return;
                    }
                    FinishedCannonCastBlockEntity fCast = (FinishedCannonCastBlockEntity)patt13046$temp;
                    if (pos1.equals((Object)corner)) {
                        fCast.setRenderedShape(cast.castShape);
                        fCast.setHeight(this.height);
                        fCast.setRootBlock(this.field_11867.method_10069(-1, 0, -1));
                    } else {
                        fCast.setCentralBlock(corner);
                    }
                });
            }
            recipe.assembleInWorld(this.field_11863, pos);
            if (y <= 0 || !((class_25862 = this.field_11863.method_8321(pos)) instanceof ICannonBlockEntity) || !((CannonBehavior)((Object)(cbe = (ICannonBlockEntity)class_25862).cannonBehavior())).canConnectToSide(class_2350.field_11033) || !((class_25862 = this.field_11863.method_8321(pos.method_10074())) instanceof ICannonBlockEntity) || !((CannonBehavior)((Object)(cbe1 = (ICannonBlockEntity)class_25862).cannonBehavior())).canConnectToSide(class_2350.field_11036)) continue;
            ((CannonBehavior)((Object)cbe.cannonBehavior())).setConnectedFace(class_2350.field_11033, true);
            ((CannonBehavior)((Object)cbe1.cannonBehavior())).setConnectedFace(class_2350.field_11036, true);
        }
        class_3414 sound = AllSoundEvents.STEAM.getMainEvent();
        this.field_11863.method_8396(null, this.method_11016(), sound, class_3419.field_15245, 1.0f, 1.0f);
    }

    @Override
    public class_1269 onWandUsed(class_1838 context) {
        AbstractCannonCastBlockEntity controller;
        if (!this.field_11863.field_9236 && (controller = this.getControllerBE()) != null) {
            controller.castingTime = 0;
        }
        return class_1269.method_29236((boolean)this.field_11863.field_9236);
    }

    public void initializeCastMultiblock(CannonCastShape size) {
        AbstractCannonCastBlockEntity controller;
        Object controller2;
        AbstractCannonCastBlockEntity otherCast;
        this.castShape = size;
        if (this.castShape == null) {
            return;
        }
        class_2586 class_25862 = this.field_11863.method_8321(this.field_11867.method_10074());
        if (class_25862 instanceof AbstractCannonCastBlockEntity && (otherCast = (AbstractCannonCastBlockEntity)class_25862).method_11017() == this.method_11017() && otherCast.getHeight() < AbstractCannonCastBlockEntity.getMaxHeight()) {
            this.controllerPos = otherCast.getController();
            controller2 = otherCast.getControllerBE();
            if (controller2 != null) {
                this.addStructureCapacityToController((AbstractCannonCastBlockEntity)controller2);
                ++((AbstractCannonCastBlockEntity)controller2).height;
                ((AbstractCannonCastBlockEntity)controller2).structure.add(this.castShape);
                controller2.notifyUpdate();
            }
        } else {
            this.reInitTank();
            this.structure.add(this.castShape);
        }
        controller2 = this.field_11863.method_8321(this.field_11867.method_10084());
        if (controller2 instanceof AbstractCannonCastBlockEntity && (otherCast = (AbstractCannonCastBlockEntity)controller2).isController() && (controller2 = this.getControllerBE()) != null && ((AbstractCannonCastBlockEntity)controller2).height + otherCast.height <= AbstractCannonCastBlockEntity.getMaxHeight()) {
            ((AbstractCannonCastBlockEntity)controller2).height += otherCast.height;
            ((AbstractCannonCastBlockEntity)controller2).structure.addAll(otherCast.structure);
            otherCast.height = 1;
            otherCast.structure = new ArrayList<CannonCastShape>();
            this.mergeControllerAndOtherFluids((AbstractCannonCastBlockEntity)controller2, otherCast);
            ((AbstractCannonCastBlockEntity)controller2).updatePotentialCastsAbove();
            controller2.notifyUpdate();
        }
        if (size.isLarge()) {
            for (class_2338 pos : class_2338.method_10097((class_2338)this.field_11867.method_10069(-1, 0, -1), (class_2338)this.field_11867.method_10069(1, 0, 1))) {
                AbstractCannonCastBlockEntity childCast;
                if (pos.equals((Object)this.field_11867)) continue;
                this.field_11863.method_8652(pos, CBCBlocks.CANNON_CAST.getDefaultState(), 11);
                class_2586 class_25863 = this.field_11863.method_8321(pos);
                if (!(class_25863 instanceof AbstractCannonCastBlockEntity) || (childCast = (AbstractCannonCastBlockEntity)class_25863).method_11017() != this.method_11017()) continue;
                childCast.controllerPos = this.getController();
                childCast.notifyUpdate();
            }
        }
        if ((controller = this.getControllerBE()) != null) {
            controller.updateRecipes = true;
            controller.forceFluidLevelUpdate = true;
            controller.forceCastLevelUpdate = true;
            controller.notifyUpdate();
        }
        this.notifyUpdate();
    }

    protected abstract void addStructureCapacityToController(AbstractCannonCastBlockEntity var1);

    protected abstract void reInitTank();

    protected abstract void mergeControllerAndOtherFluids(AbstractCannonCastBlockEntity var1, AbstractCannonCastBlockEntity var2);

    public void destroyCastMultiblockAtLayer() {
        if (this.canRenderCastModel() && this.castShape != null) {
            this.onDestroyCenterCast();
        } else {
            AbstractCannonCastBlockEntity otherCast;
            class_2586 class_25862 = this.field_11863.method_8321(this.getCenterBlock());
            if (class_25862 instanceof AbstractCannonCastBlockEntity && (otherCast = (AbstractCannonCastBlockEntity)class_25862).canRenderCastModel() && otherCast.castShape != null) {
                otherCast.destroyCastMultiblockAtLayer();
            }
        }
    }

    protected abstract void onDestroyCenterCast();

    public static List<CannonCastShape> getStructureFromPoint(class_1937 level, class_2338 pos, int height) {
        class_2586 class_25862;
        ArrayList<CannonCastShape> structure = new ArrayList<CannonCastShape>();
        class_2586 class_25863 = level.method_8321(pos);
        if (!(class_25863 instanceof AbstractCannonCastBlockEntity)) {
            return structure;
        }
        AbstractCannonCastBlockEntity start = (AbstractCannonCastBlockEntity)class_25863;
        pos = start.getCenterBlock();
        for (int i = 0; i < height && (class_25862 = level.method_8321(pos)) instanceof AbstractCannonCastBlockEntity; ++i) {
            AbstractCannonCastBlockEntity cast = (AbstractCannonCastBlockEntity)class_25862;
            structure.add(cast.castShape);
        }
        return structure;
    }

    protected void updatePotentialCastsAbove() {
        class_2586 class_25862;
        if (!this.isController()) {
            return;
        }
        for (int y = 0; y < this.height && (class_25862 = this.field_11863.method_8321(this.field_11867.method_10086(y))) instanceof AbstractCannonCastBlockEntity; ++y) {
            AbstractCannonCastBlockEntity cast = (AbstractCannonCastBlockEntity)class_25862;
            if (y != 0) {
                cast.setController(this.field_11867);
            }
            if (!cast.getRenderedSize().isLarge()) continue;
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    class_2586 class_25863;
                    if (x == 0 && z == 0 || !((class_25863 = this.field_11863.method_8321(this.field_11867.method_10069(x, y, z))) instanceof AbstractCannonCastBlockEntity)) continue;
                    AbstractCannonCastBlockEntity cast1 = (AbstractCannonCastBlockEntity)class_25863;
                    cast1.setController(this.field_11867);
                    cast1.method_5431();
                }
            }
        }
    }

    public int calculateCapacityFromStructure() {
        return this.structure.stream().map(CannonCastShape::fluidSize).reduce(Integer::sum).orElse(0);
    }

    public class_2338 getCenterBlock() {
        return this.isController() ? this.field_11867 : new class_2338(this.controllerPos.method_10263(), this.field_11867.method_10264(), this.controllerPos.method_10260());
    }

    public boolean canRenderCastModel() {
        return this.isController() || this.controllerPos.method_10263() == this.field_11867.method_10263() && this.controllerPos.method_10260() == this.field_11867.method_10260();
    }

    public abstract float getFillState();

    public LerpedFloat getFluidLevel() {
        return this.fluidLevel;
    }

    public void setFluidLevel(LerpedFloat level) {
        this.fluidLevel = level;
    }

    public float getCastingState() {
        return this.startCastingTime <= 1 ? 0.0f : 1.0f - (float)this.castingTime / (float)this.startCastingTime;
    }

    public LerpedFloat getCastingLevel() {
        return this.castLevel;
    }

    public class_2338 getController() {
        return this.isController() ? this.field_11867 : this.controllerPos;
    }

    @Nullable
    public AbstractCannonCastBlockEntity getControllerBE() {
        AbstractCannonCastBlockEntity cast;
        class_2586 class_25862;
        return this.isController() ? this : ((class_25862 = this.field_11863.method_8321(this.controllerPos)) instanceof AbstractCannonCastBlockEntity ? (cast = (AbstractCannonCastBlockEntity)class_25862) : null);
    }

    public boolean isController() {
        return this.controllerPos == null || this.field_11867.equals((Object)this.controllerPos);
    }

    protected abstract void refreshCap();

    public void setController(class_2338 pos) {
        if (this.field_11863.field_9236) {
            this.invalidateRenderBoundingBox();
        }
        if (this.field_11863.field_9236 && !this.isVirtual() || pos.equals((Object)this.controllerPos)) {
            return;
        }
        this.controllerPos = pos;
        this.refreshCap();
        this.notifyUpdate();
    }

    public static int getMaxHeight() {
        return (Integer)CBCConfigs.SERVER.crafting.maxCannonCastHeight.get();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return 3;
    }

    protected class_238 createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().method_989(-1.0, 0.0, -1.0).method_1012(2.0, (double)(this.height - 1), 2.0);
        }
        if (this.canRenderCastModel() && this.getControllerBE() != null) {
            return this.getControllerBE().createRenderBoundingBox();
        }
        return super.createRenderBoundingBox();
    }

    public CannonCastShape getRenderedSize() {
        return this.castShape;
    }

    public void removeController(boolean keepContents) {
        this.refreshCap();
        this.notifyUpdate();
    }

    public class_2338 getLastKnownPos() {
        return this.lastKnownPos;
    }

    public void preventConnectivityUpdate() {
    }

    public void notifyMultiUpdated() {
    }

    public class_2350.class_2351 getMainConnectionAxis() {
        return class_2350.class_2351.field_11052;
    }

    public int getMaxLength(class_2350.class_2351 longAxis, int width) {
        return longAxis == class_2350.class_2351.field_11052 ? (Integer)CBCConfigs.SERVER.crafting.maxCannonCastHeight.get() : 3;
    }

    public int getMaxWidth() {
        return 3;
    }

    public void setWidth(int width) {
    }

    public boolean matchesRecipe(CannonCastingRecipe recipe) {
        return this.getControllerBE() != null && this.getControllerBE().structure.contains(recipe.shape()) && this.testWithFluid(recipe);
    }

    protected abstract boolean testWithFluid(CannonCastingRecipe var1);

    public abstract boolean tryEmptyItemIntoBE(class_1937 var1, class_1657 var2, class_1268 var3, class_1799 var4, class_2350 var5);

    public abstract boolean tryFillItemFromBE(class_1937 var1, class_1657 var2, class_1268 var3, class_1799 var4, class_2350 var5);

    public boolean addToTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        AbstractCannonCastBlockEntity controller = this.getControllerBE();
        if (controller == null || controller.invalidCastingError == null) {
            return false;
        }
        class_5250 errorMsg = controller.invalidCastingError.getMessage();
        List cutErrorLines = TooltipHelper.cutTextComponent((class_2561)errorMsg, (TooltipHelper.Palette)TooltipHelper.Palette.GRAY_AND_WHITE);
        for (class_2561 cline : cutErrorLines) {
            Lang.builder().add(cline.method_27661()).forGoggles(tooltip);
        }
        return true;
    }
}

