/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.autocannon.breech;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannons.autocannon.AnimatedAutocannon;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.autocannon.breech.AutocannonBreechBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.munitions.autocannon.ammo_container.AutocannonAmmoContainerItem;

public abstract class AbstractAutocannonBreechBlockEntity
extends AutocannonBlockEntity
implements AnimatedAutocannon {
    protected static final int[] FIRE_RATES = new int[]{120, 80, 60, 48, 40, 30, 24, 20, 15, 12, 10, 8, 6, 5, 4};
    private int fireRate = 7;
    private int firingCooldown;
    private int animateTicks = 5;
    @Nullable
    class_1767 seat = null;
    private boolean updateInstance = true;
    private final Deque<class_1799> inputBuffer = new LinkedList<class_1799>();
    private class_1799 outputBuffer = class_1799.field_8037;
    private class_1799 magazine = class_1799.field_8037;

    protected AbstractAutocannonBreechBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public int getQueueLimit() {
        return 5;
    }

    public Deque<class_1799> getInputBuffer() {
        return this.inputBuffer;
    }

    public class_1799 getOutputBuffer() {
        return this.outputBuffer;
    }

    public void setOutputBuffer(class_1799 stack) {
        this.outputBuffer = stack;
    }

    public void setMagazine(class_1799 stack) {
        this.magazine = stack;
        this.updateInstance = true;
    }

    public class_1799 getMagazine() {
        return this.magazine;
    }

    public void tick() {
        super.tick();
        this.allTick(this.field_11863);
    }

    @Override
    public void tickFromContraption(class_1937 level, PitchOrientedContraptionEntity poce, class_2338 localPos) {
        super.tickFromContraption(level, poce, localPos);
        this.allTick(level);
        if (!level.field_9236 && this.updateInstance) {
            this.updateInstance = false;
            Contraption contraption = poce.getContraption();
            BigCannonBlock.writeAndSyncSingleBlockData((class_2586)this, (class_3499.class_3501)contraption.getBlocks().get(localPos), (AbstractContraptionEntity)poce, contraption);
        }
    }

    private void allTick(class_1937 level) {
        if (this.fireRate < 0 || this.fireRate > 15) {
            this.fireRate = 0;
        }
        if (this.firingCooldown < 0) {
            this.firingCooldown = 0;
        }
        if (this.firingCooldown > 0) {
            --this.firingCooldown;
        }
        if (this.animateTicks < 5) {
            ++this.animateTicks;
        }
        if (this.animateTicks < 0) {
            this.animateTicks = 0;
        }
    }

    public void setFireRate(int power) {
        this.fireRate = class_3532.method_15340((int)power, (int)0, (int)15);
    }

    public int getFireRate() {
        return this.fireRate;
    }

    public int getActualFireRate() {
        if (this.fireRate < 1 || this.fireRate > 15) {
            return 0;
        }
        int cooldown = FIRE_RATES[this.fireRate - 1];
        return 1200 / cooldown;
    }

    public boolean canFire() {
        return this.getFireRate() > 0 && this.firingCooldown <= 0;
    }

    public void handleFiring() {
        if (this.fireRate > 0 && this.fireRate <= FIRE_RATES.length) {
            this.firingCooldown = FIRE_RATES[this.fireRate - 1];
            this.animateTicks = 0;
        }
    }

    public float getAnimateOffset(float partialTicks) {
        float t = ((float)this.animateTicks + partialTicks) * 1.2f;
        if (t <= 0.0f || t >= 4.8f) {
            return 0.0f;
        }
        float f = t < 1.0f ? t : (4.8f - t) / 3.8f;
        return class_3532.method_15374((float)(f * 1.5707964f));
    }

    @Override
    public void incrementAnimationTicks() {
        ++this.animateTicks;
    }

    @Override
    public int getAnimationTicks() {
        return this.animateTicks;
    }

    public void setSeatColor(@Nullable class_1767 color) {
        this.seat = color;
        this.updateInstance = true;
        this.notifyUpdate();
    }

    @Nullable
    class_1767 getSeatColor() {
        return this.seat;
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.fireRate = tag.method_10550("FiringRate");
        this.firingCooldown = tag.method_10550("Cooldown");
        this.animateTicks = tag.method_10550("AnimateTicks");
        this.outputBuffer = tag.method_10545("Output") ? class_1799.method_7915((class_2487)tag.method_10562("Output")) : class_1799.field_8037;
        this.seat = class_1767.method_7793((String)tag.method_10558("Seat"), null);
        this.inputBuffer.clear();
        class_2499 inputTag = tag.method_10554("Input", 10);
        for (int i = 0; i < inputTag.size(); ++i) {
            this.inputBuffer.add(class_1799.method_7915((class_2487)inputTag.method_10602(i)));
        }
        class_1799 class_17992 = this.magazine = tag.method_10545("Magazine") ? class_1799.method_7915((class_2487)tag.method_10562("Magazine")) : class_1799.field_8037;
        if (!clientPacket) {
            return;
        }
        this.updateInstance = tag.method_10545("UpdateInstance");
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10569("FiringRate", this.fireRate);
        tag.method_10569("Cooldown", this.firingCooldown);
        tag.method_10569("AnimateTicks", this.animateTicks);
        if (this.outputBuffer != null && !this.outputBuffer.method_7960()) {
            tag.method_10566("Output", (class_2520)this.outputBuffer.method_7953(new class_2487()));
        }
        if (this.seat != null) {
            tag.method_10582("Seat", this.seat.method_15434());
        }
        if (!this.inputBuffer.isEmpty()) {
            tag.method_10566("Input", (class_2520)this.inputBuffer.stream().map(s -> s.method_7953(new class_2487())).collect(Collectors.toCollection(class_2499::new)));
        }
        if (this.magazine != null && !this.magazine.method_7960()) {
            tag.method_10566("Magazine", (class_2520)this.magazine.method_7953(new class_2487()));
        }
        if (!clientPacket) {
            return;
        }
        if (this.updateInstance) {
            tag.method_10556("UpdateInstance", true);
        }
    }

    public boolean isInputFull() {
        return this.inputBuffer.size() >= this.getQueueLimit() || !this.magazine.method_7960();
    }

    public boolean isOutputFull() {
        return !this.outputBuffer.method_7960();
    }

    public class_1799 insertOutput(class_1799 stack) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        if (this.isOutputFull()) {
            return stack;
        }
        this.outputBuffer = stack;
        return class_1799.field_8037;
    }

    public class_1799 extractNextInput() {
        if (!this.inputBuffer.isEmpty()) {
            return this.inputBuffer.poll();
        }
        if (this.magazine.method_7960()) {
            return class_1799.field_8037;
        }
        int totalCount = AutocannonAmmoContainerItem.getTotalAmmoCount(this.magazine);
        if (totalCount == 0) {
            return class_1799.field_8037;
        }
        if (totalCount == 1) {
            this.updateInstance = true;
        }
        return AutocannonAmmoContainerItem.pollItemFromContainer(this.magazine);
    }

    @Override
    public List<class_1799> getDrops() {
        List list = super.getDrops();
        for (class_1799 s : this.inputBuffer) {
            if (s.method_7960()) continue;
            list.add(s.method_7972());
        }
        if (!this.outputBuffer.method_7960()) {
            list.add(this.outputBuffer.method_7972());
        }
        if (!this.magazine.method_7960()) {
            list.add(this.magazine.method_7972());
        }
        return list;
    }

    protected class_238 createRenderBoundingBox() {
        class_2350 dir = (class_2350)this.method_11010().method_11654((class_2769)AutocannonBreechBlock.field_10927);
        class_2350 ammoContainerDir = dir.method_10166().method_10179() ? dir.method_35833(class_2350.class_2351.field_11052) : class_2350.field_11034;
        return super.createRenderBoundingBox().method_18804(new class_243(dir.method_10153().method_23955()).method_1019(new class_243(ammoContainerDir.method_23955())));
    }
}

