/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_loading;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.ContraptionType;
import com.simibubi.create.content.contraptions.piston.PistonExtensionPoleBlock;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3499;
import org.apache.commons.lang3.tuple.Pair;
import rbasamoyai.createbigcannons.base.PoleContraption;
import rbasamoyai.createbigcannons.cannon_loading.CanLoadBigCannon;
import rbasamoyai.createbigcannons.cannon_loading.CannonLoaderBlock;
import rbasamoyai.createbigcannons.cannon_loading.CannonLoaderBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.index.CBCContraptionTypes;
import rbasamoyai.createbigcannons.munitions.big_cannon.ProjectileBlock;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCannonPropellantBlock;
import rbasamoyai.createbigcannons.remix.ContraptionRemix;
import rbasamoyai.createbigcannons.remix.HasFragileContraption;

public class CannonLoadingContraption
extends PoleContraption
implements CanLoadBigCannon,
HasFragileContraption {
    protected LoadingHead loadingHead = LoadingHead.NOTHING;
    private static final class_2753 FACING = class_2741.field_12525;
    private static final class_2746 MOVING = CannonLoaderBlock.MOVING;
    private boolean brokenDisassembly = false;
    private final Set<class_2338> fragileBlocks = new HashSet<class_2338>();
    private final Set<class_2338> colliderBlocks = new HashSet<class_2338>();
    private final Map<class_2338, class_2680> encounteredBlocks = new HashMap<class_2338, class_2680>();

    public CannonLoadingContraption() {
    }

    public CannonLoadingContraption(class_2350 direction, boolean retract) {
        super(direction, retract);
    }

    @Override
    protected boolean collectExtensions(class_1937 level, class_2338 pos, class_2350 direction) throws AssemblyException {
        if (!CBCBlocks.CANNON_LOADER.has(level.method_8320(pos))) {
            return false;
        }
        ArrayList<class_3499.class_3501> poles = new ArrayList<class_3499.class_3501>();
        class_2338 start = pos;
        class_2680 nextBlock = level.method_8320(start.method_10093(direction));
        int extensionsInFront = 0;
        class_2350.class_2351 blockAxis = direction.method_10166();
        this.loadingHead = LoadingHead.NOTHING;
        PistonExtensionPoleBlock.PlacementHelper matcher = PistonExtensionPoleBlock.PlacementHelper.get();
        while (matcher.matchesAxis(nextBlock, blockAxis) || this.isValidLoaderHead(nextBlock) && ((class_2350)nextBlock.method_11654((class_2769)FACING)).method_10166() == blockAxis || this.isValidCannonBlock((class_1936)level, nextBlock, start.method_10093(direction)) && this.matchesCannonAxis(nextBlock, blockAxis)) {
            if (this.isValidCannonBlock((class_1936)level, nextBlock, start = start.method_10093(direction))) {
                class_3499.class_3501 containedBlock = ((BigCannonBehavior)((Object)((IBigCannonBlockEntity)level.method_8321(start)).cannonBehavior())).block();
                nextBlock = containedBlock.field_15596;
                if (matcher.matchesAxis(nextBlock, blockAxis)) {
                    poles.add(new class_3499.class_3501(start, (class_2680)nextBlock.method_11657((class_2769)FACING, (Comparable)direction), null));
                } else {
                    if (this.isValidLoaderHead(nextBlock)) {
                        poles.add(new class_3499.class_3501(start, (class_2680)nextBlock.method_11657((class_2769)FACING, (Comparable)direction), null));
                        if (CBCBlocks.RAM_HEAD.has(nextBlock)) {
                            this.loadingHead = LoadingHead.RAM_HEAD;
                            break;
                        }
                        this.loadingHead = LoadingHead.WORM_HEAD;
                        break;
                    }
                    if (nextBlock.method_26215()) {
                        break;
                    }
                }
            } else {
                poles.add(new class_3499.class_3501(start, (class_2680)nextBlock.method_11657((class_2769)FACING, (Comparable)direction), null));
                if (this.isValidLoaderHead(nextBlock)) {
                    if (CBCBlocks.RAM_HEAD.has(nextBlock)) {
                        this.loadingHead = LoadingHead.RAM_HEAD;
                        break;
                    }
                    this.loadingHead = LoadingHead.WORM_HEAD;
                    break;
                }
            }
            nextBlock = level.method_8320(start.method_10093(direction));
            if (++extensionsInFront <= CannonLoaderBlock.maxAllowedLoaderLength()) continue;
            throw AssemblyException.tooManyPistonPoles();
        }
        poles.add(new class_3499.class_3501(pos, (class_2680)AllBlocks.PISTON_EXTENSION_POLE.getDefaultState().method_11657((class_2769)FACING, (Comparable)direction), null));
        class_2338 end = pos;
        int extensionsInBack = 0;
        class_2350 opposite = direction.method_10153();
        nextBlock = level.method_8320(end.method_10093(opposite));
        while (matcher.matchesAxis(nextBlock, blockAxis)) {
            end = end.method_10093(opposite);
            poles.add(new class_3499.class_3501(end, (class_2680)nextBlock.method_11657((class_2769)FACING, (Comparable)direction), null));
            nextBlock = level.method_8320(end.method_10093(opposite));
            nextBlock = ContraptionRemix.getInnerCannonState((class_1936)level, nextBlock, end.method_10093(opposite), direction);
            if (extensionsInFront + ++extensionsInBack <= CannonLoaderBlock.maxAllowedLoaderLength()) continue;
            throw AssemblyException.tooManyPistonPoles();
        }
        this.extensionLength = extensionsInFront + extensionsInBack;
        if (this.extensionLength == 0) {
            throw AssemblyException.noPistonPoles();
        }
        this.anchor = pos.method_10079(direction, this.initialExtensionProgress + 2);
        if (this.loadingHead == LoadingHead.NOTHING) {
            this.anchor = this.anchor.method_10079(direction, -1);
        }
        this.initialExtensionProgress = extensionsInFront;
        this.pistonContraptionHitbox = new class_238(class_2338.field_10980.method_10079(direction, -1), class_2338.field_10980.method_10079(direction, -this.extensionLength - 2)).method_1012(1.0, 1.0, 1.0);
        this.bounds = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        for (class_3499.class_3501 pole : poles) {
            class_2338 relPos = pole.field_15597.method_10079(direction, -extensionsInFront);
            class_2338 localPos = relPos.method_10059((class_2382)this.anchor);
            this.getBlocks().put(localPos, new class_3499.class_3501(localPos, pole.field_15596, null));
        }
        return true;
    }

    protected boolean moveBlock(class_1937 level, class_2350 direction, Queue<class_2338> frontier, Set<class_2338> visited) throws AssemblyException {
        class_2338 pos = frontier.poll();
        if (pos == null) {
            return false;
        }
        visited.add(pos);
        if (level.method_31606(pos)) {
            return true;
        }
        if (!level.method_8477(pos)) {
            throw AssemblyException.unloadedChunk((class_2338)pos);
        }
        if (this.isAnchoringBlockAt(pos)) {
            return true;
        }
        class_2338 ahead = pos.method_10093(direction);
        class_2680 state = level.method_8320(ahead);
        if (this.isAnchoringBlockAt(ahead)) {
            return true;
        }
        if (!visited.contains(ahead)) {
            if (this.isValidLoadBlock(state, level, ahead)) {
                frontier.add(ahead);
            }
            if (this.isValidCannonBlock((class_1936)level, state, ahead) && this.matchesCannonAxis(state, direction.method_10166())) {
                class_2586 blockEntity = level.method_8321(ahead);
                if (!(blockEntity instanceof IBigCannonBlockEntity)) {
                    return true;
                }
                IBigCannonBlockEntity cannon = (IBigCannonBlockEntity)blockEntity;
                class_3499.class_3501 blockInfo = ((BigCannonBehavior)((Object)cannon.cannonBehavior())).block();
                if (this.isValidLoadBlock(blockInfo.field_15596, level, ahead)) {
                    frontier.add(ahead);
                }
            }
        }
        this.addBlock(pos, (Pair<class_3499.class_3501, class_2586>)this.capture(level, pos));
        if (this.blocks.size() <= (Integer)AllConfigs.server().kinetics.maxBlocksMoved.get()) {
            return true;
        }
        throw AssemblyException.structureTooLarge();
    }

    private boolean isValidLoaderHead(class_2680 state) {
        return CBCBlocks.RAM_HEAD.has(state) || CBCBlocks.WORM_HEAD.has(state);
    }

    private boolean isValidCannonBlock(class_1936 level, class_2680 state, class_2338 pos) {
        return state.method_26204() instanceof BigCannonBlock && level.method_8321(pos) instanceof IBigCannonBlockEntity;
    }

    private boolean matchesCannonAxis(class_2680 state, class_2350.class_2351 axis) {
        return ((BigCannonBlock)state.method_26204()).getFacing(state).method_10166() == axis;
    }

    protected void addBlock(class_2338 pos, Pair<class_3499.class_3501, class_2586> pair) {
        class_2586 blockEntity = (class_2586)pair.getRight();
        if (blockEntity instanceof IBigCannonBlockEntity) {
            IBigCannonBlockEntity cannon = (IBigCannonBlockEntity)blockEntity;
            class_3499.class_3501 containedInfo = ((BigCannonBehavior)((Object)cannon.cannonBehavior())).block();
            class_2586 containedBlockEntity = null;
            if (containedInfo.field_15595 != null) {
                containedInfo.field_15595.method_10569("x", pos.method_10263());
                containedInfo.field_15595.method_10569("y", pos.method_10264());
                containedInfo.field_15595.method_10569("z", pos.method_10260());
                containedBlockEntity = class_2586.method_11005((class_2338)pos, (class_2680)containedInfo.field_15596, (class_2487)containedInfo.field_15595);
            }
            pair = Pair.of((Object)containedInfo, containedBlockEntity);
        }
        super.addBlock(pos.method_10079(this.orientation, -this.initialExtensionProgress), pair);
    }

    protected boolean addToInitialFrontier(class_1937 level, class_2338 pos, class_2350 forcedDirection, Queue<class_2338> frontier) throws AssemblyException {
        frontier.clear();
        if (this.loadingHead == LoadingHead.NOTHING) {
            return true;
        }
        boolean retracting = forcedDirection != this.orientation;
        if (retracting != (this.loadingHead == LoadingHead.WORM_HEAD)) {
            return true;
        }
        for (int offset = 0; offset <= (Integer)AllConfigs.server().kinetics.maxChassisRange.get(); ++offset) {
            if (offset == 1 && retracting) {
                return true;
            }
            class_2338 currentPos = pos.method_10079(this.orientation, offset + this.initialExtensionProgress);
            if (retracting && level.method_31606(currentPos)) {
                return true;
            }
            if (!level.method_8477(currentPos)) {
                throw AssemblyException.unloadedChunk((class_2338)currentPos);
            }
            class_2680 state = level.method_8320(currentPos);
            if (this.isValidLoadBlock(state, level, currentPos)) {
                frontier.add(currentPos);
                continue;
            }
            if (this.isValidCannonBlock((class_1936)level, state, currentPos) && this.matchesCannonAxis(state, forcedDirection.method_10166())) {
                class_2586 blockEntity = level.method_8321(currentPos);
                if (!(blockEntity instanceof IBigCannonBlockEntity)) {
                    return true;
                }
                IBigCannonBlockEntity cannon = (IBigCannonBlockEntity)blockEntity;
                class_3499.class_3501 blockInfo = ((BigCannonBehavior)((Object)cannon.cannonBehavior())).block();
                if (this.isValidLoadBlock(blockInfo.field_15596, level, currentPos)) {
                    frontier.add(currentPos);
                    continue;
                }
                return true;
            }
            return true;
        }
        return true;
    }

    private boolean isValidLoadBlock(class_2680 state, class_1937 level, class_2338 pos) {
        class_2350.class_2351 axis = this.orientation.method_10166();
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof BigCannonPropellantBlock) {
            BigCannonPropellantBlock propellant = (BigCannonPropellantBlock)class_22482;
            return propellant.canBeLoaded(state, axis);
        }
        if (state.method_26204() instanceof ProjectileBlock) {
            return ((class_2350)state.method_11654((class_2769)FACING)).method_10166() == axis;
        }
        return false;
    }

    protected boolean customBlockPlacement(class_1936 level, class_2338 pos, class_2680 state) {
        class_2338 levelPos = this.anchor.method_10079(this.orientation, this.loadingHead == LoadingHead.NOTHING ? -1 : -2);
        class_2680 loaderState = level.method_8320(levelPos);
        class_2586 blockEntity = level.method_8321(levelPos);
        if (pos.equals((Object)levelPos)) {
            if (blockEntity instanceof CannonLoaderBlockEntity && !blockEntity.method_11015()) {
                level.method_8652(levelPos, (class_2680)loaderState.method_11657((class_2769)MOVING, (Comparable)Boolean.valueOf(false)), 19);
            }
            return true;
        }
        return false;
    }

    protected boolean customBlockRemoval(class_1936 level, class_2338 pos, class_2680 state) {
        class_2338 loaderPos = this.anchor.method_10079(this.orientation, this.loadingHead == LoadingHead.NOTHING ? -1 : -2);
        class_2680 loaderState = level.method_8320(loaderPos);
        if (pos.equals((Object)loaderPos) && CBCBlocks.CANNON_LOADER.has(loaderState)) {
            level.method_8652(loaderPos, (class_2680)loaderState.method_11657((class_2769)MOVING, (Comparable)Boolean.valueOf(true)), 82);
            return true;
        }
        return false;
    }

    @Override
    public void createbigcannons$setBrokenDisassembly(boolean flag) {
        this.brokenDisassembly = flag;
    }

    @Override
    public boolean createbigcannons$isBrokenDisassembly() {
        return this.brokenDisassembly;
    }

    @Override
    public class_2338 createbigcannons$toLocalPos(class_2338 globalPos) {
        return this.toLocalPos(globalPos);
    }

    @Override
    public Set<class_2338> createbigcannons$getFragileBlockPositions() {
        return this.fragileBlocks;
    }

    @Override
    public Set<class_2338> createbigcannons$getCannonLoadingColliders() {
        return this.colliderBlocks;
    }

    @Override
    @Nullable
    public class_2350 createbigcannons$getAssemblyMovementDirection(class_1937 level) {
        return this.orientation != null && this.retract ? this.orientation.method_10153() : this.orientation;
    }

    @Override
    public void readNBT(class_1937 level, class_2487 tag, boolean spawnData) {
        super.readNBT(level, tag, spawnData);
        this.loadingHead = LoadingHead.fromOrdinal(tag.method_10550("LoadingHead"));
    }

    @Override
    public class_2487 writeNBT(boolean spawnPacket) {
        class_2487 tag = super.writeNBT(spawnPacket);
        tag.method_10569("LoadingHead", this.loadingHead == null ? LoadingHead.NOTHING.ordinal() : this.loadingHead.ordinal());
        return tag;
    }

    public ContraptionType getType() {
        return CBCContraptionTypes.CANNON_LOADER;
    }

    @Override
    public Map<class_2338, class_2680> createbigcannons$getEncounteredBlocks() {
        return this.encounteredBlocks;
    }

    @Override
    public boolean createbigcannons$blockBreaksDisassembly(class_1937 level, class_2338 pos, class_2680 newState) {
        class_2338 loaderPos = this.anchor.method_10079(this.orientation, this.loadingHead == LoadingHead.NOTHING ? -1 : -2);
        class_2680 loaderState = level.method_8320(loaderPos);
        if (pos.equals((Object)loaderPos) && CBCBlocks.CANNON_LOADER.has(loaderState)) {
            return false;
        }
        return HasFragileContraption.defaultBlockBreaksAssembly(level, pos, newState, this);
    }

    @Override
    public boolean createbigcannons$shouldCheckFragility() {
        return HasFragileContraption.defaultShouldCheck();
    }

    @Override
    public void createbigcannons$fragileDisassemble() {
        class_2338 loaderPos = this.anchor.method_10079(this.orientation, -1);
        class_2586 class_25862 = this.world.method_8321(loaderPos);
        if (class_25862 instanceof CannonLoaderBlockEntity) {
            CannonLoaderBlockEntity loaderBE = (CannonLoaderBlockEntity)class_25862;
            loaderBE.disassemble();
        } else {
            this.entity.disassemble();
        }
    }

    public static enum LoadingHead {
        RAM_HEAD,
        WORM_HEAD,
        NOTHING;

        private static final LoadingHead[] VALUES;

        public static LoadingHead fromOrdinal(int ordinal) {
            return ordinal <= 0 && ordinal < VALUES.length ? VALUES[ordinal] : NOTHING;
        }

        static {
            VALUES = LoadingHead.values();
        }
    }
}

