/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.contraption;

import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.foundation.utility.Components;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3499;
import rbasamoyai.createbigcannons.cannon_control.ControlPitchContraption;
import rbasamoyai.createbigcannons.cannon_control.cannon_types.ICannonContraptionType;
import rbasamoyai.createbigcannons.cannon_control.config.CannonMountPropertiesHandler;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.config.CBCConfigs;

public abstract class AbstractMountedCannonContraption
extends Contraption {
    protected class_2350 initialOrientation = class_2350.field_11043;
    protected class_2338 startPos = class_2338.field_10980;
    protected int backExtensionLength = 0;
    protected int frontExtensionLength = 0;

    public float maximumDepression(@Nonnull ControlPitchContraption controller) {
        ICannonContraptionType type = this.getCannonType();
        if (controller instanceof class_2586) {
            class_2586 beMount = (class_2586)controller;
            return CannonMountPropertiesHandler.getProperties(beMount, type).maximumDepression(beMount);
        }
        if (controller instanceof class_1297) {
            class_1297 entityMount = (class_1297)controller;
            return CannonMountPropertiesHandler.getProperties(entityMount, type).maximumDepression(entityMount);
        }
        return 0.0f;
    }

    public float maximumElevation(@Nonnull ControlPitchContraption controller) {
        ICannonContraptionType type = this.getCannonType();
        if (controller instanceof class_2586) {
            class_2586 beMount = (class_2586)controller;
            return CannonMountPropertiesHandler.getProperties(beMount, type).maximumElevation(beMount);
        }
        if (controller instanceof class_1297) {
            class_1297 entityMount = (class_1297)controller;
            return CannonMountPropertiesHandler.getProperties(entityMount, type).maximumElevation(entityMount);
        }
        return 0.0f;
    }

    public class_2350 initialOrientation() {
        return this.initialOrientation;
    }

    public abstract void onRedstoneUpdate(class_3218 var1, PitchOrientedContraptionEntity var2, boolean var3, int var4, ControlPitchContraption var5);

    public abstract void fireShot(class_3218 var1, PitchOrientedContraptionEntity var2);

    public abstract float getWeightForStress();

    public void tick(class_1937 level, PitchOrientedContraptionEntity entity) {
        this.bounds = this.createBoundsFromExtensionLengths();
    }

    public void animate() {
    }

    public class_2487 writeNBT(boolean spawnPacket) {
        for (Map.Entry entry : this.presentBlockEntities.entrySet()) {
            class_3499.class_3501 info = (class_3499.class_3501)this.blocks.get(entry.getKey());
            if (info == null) continue;
            class_2487 nbt = ((class_2586)entry.getValue()).method_38242();
            nbt.method_10551("x");
            nbt.method_10551("y");
            nbt.method_10551("z");
            this.blocks.put((class_2338)entry.getKey(), new class_3499.class_3501(info.field_15597, info.field_15596, nbt));
        }
        class_2487 tag = super.writeNBT(spawnPacket);
        if (this.initialOrientation != null) {
            tag.method_10582("InitialOrientation", this.initialOrientation.method_15434());
        }
        tag.method_10544("LocalStartingPos", this.startPos == null ? 0L : this.startPos.method_10063());
        tag.method_10569("BackExtensionLength", this.backExtensionLength);
        tag.method_10569("FrontExtensionLength", this.frontExtensionLength);
        return tag;
    }

    public void readNBT(class_1937 world, class_2487 tag, boolean spawnData) {
        super.readNBT(world, tag, spawnData);
        this.initialOrientation = tag.method_10573("InitialOrientation", 8) ? class_2350.method_10168((String)tag.method_10558("InitialOrientation")) : class_2350.field_11043;
        this.startPos = class_2338.method_10092((long)tag.method_10537("LocalStartingPos"));
        this.backExtensionLength = tag.method_10550("BackExtensionLength");
        this.frontExtensionLength = tag.method_10550("FrontExtensionLength");
        if (world.field_9236) {
            return;
        }
        for (Map.Entry entry : this.blocks.entrySet()) {
            class_3499.class_3501 info = (class_3499.class_3501)this.blocks.get(entry.getKey());
            if (info == null || info.field_15595 == null) continue;
            info.field_15595.method_10569("x", info.field_15597.method_10263());
            info.field_15595.method_10569("y", info.field_15597.method_10264());
            info.field_15595.method_10569("z", info.field_15597.method_10260());
            class_2586 be = class_2586.method_11005((class_2338)info.field_15597, (class_2680)info.field_15596, (class_2487)info.field_15595);
            if (be == null) continue;
            be.method_31662(world);
            this.presentBlockEntities.put(info.field_15597, be);
        }
    }

    public boolean canBeStabilized(class_2350 direction, class_2338 pos) {
        return true;
    }

    public boolean canBeTurnedByPassenger(class_1297 entity) {
        return false;
    }

    public boolean canBeTurnedByController(ControlPitchContraption control) {
        return true;
    }

    public boolean canBeFiredOnController(ControlPitchContraption control) {
        return true;
    }

    public class_2338 getSeatPos(class_1297 entity) {
        return null;
    }

    public abstract class_243 getInteractionVec(PitchOrientedContraptionEntity var1);

    public class_2338 getStartPos() {
        return this.startPos;
    }

    public abstract ICannonContraptionType getCannonType();

    public static int getMaxCannonLength() {
        return (Integer)CBCConfigs.SERVER.cannons.maxCannonLength.get();
    }

    public class_238 createBoundsFromExtensionLengths() {
        class_2350 dir = this.initialOrientation();
        dir = class_2350.method_10169((class_2350.class_2351)dir.method_10166(), (class_2350.class_2352)class_2350.class_2352.field_11056);
        class_243 normal = new class_243((double)dir.method_10148(), (double)dir.method_10164(), (double)dir.method_10165());
        if (this.entity != null) {
            normal = this.entity.applyRotation(normal, 0.0f);
        }
        class_238 aabb = new class_238(class_2338.field_10980);
        return aabb.method_18804(normal.method_1021((double)this.frontExtensionLength + 0.5)).method_18804(normal.method_1021((double)(-this.backExtensionLength) - 0.5)).method_1014(1.0);
    }

    public class_238 createInitialLightingBounds() {
        class_2350.class_2351 inflateAxis = this.initialOrientation.method_10166() == class_2350.class_2351.field_11052 ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11052;
        return new class_238(class_2338.field_10980).method_1014(Math.ceil(Math.sqrt(AbstractMountedCannonContraption.getRadius(this.getBlocks().keySet(), (class_2350.class_2351)inflateAxis))) + 1.0);
    }

    public static AssemblyException cannonTooLarge() {
        return new AssemblyException((class_2561)Components.translatable((String)"exception.createbigcannons.cannon_mount.cannonTooLarge", (Object[])new Object[]{AbstractMountedCannonContraption.getMaxCannonLength()}));
    }

    public static AssemblyException invalidCannon() {
        return new AssemblyException((class_2561)Components.translatable((String)"exception.createbigcannons.cannon_mount.invalidCannon"));
    }

    public static AssemblyException cannonLoaderInsideDuringAssembly(class_2338 pos) {
        return new AssemblyException((class_2561)Components.translatable((String)"exception.createbigcannons.cannon_mount.cannonLoaderInsideDuringAssembly", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}));
    }

    public static AssemblyException hasIncompleteCannonBlocks(class_2338 pos) {
        return new AssemblyException((class_2561)Components.translatable((String)"exception.createbigcannons.cannon_mount.hasIncompleteCannonBlocks", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}));
    }

    public static AssemblyException incorrectBreechDirection(class_2338 pos) {
        return new AssemblyException((class_2561)Components.translatable((String)"exception.createbigcannons.cannon_mount.incorrectBreechDirection", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}));
    }
}

