/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.cannon_types;

import it.unimi.dsi.fastutil.objects.Object2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.cannon_control.cannon_types.ICannonContraptionType;

public class CannonContraptionTypeRegistry {
    private static final Map<class_2960, ICannonContraptionType> TYPES_BY_ID = new Object2ReferenceLinkedOpenHashMap();
    private static final Map<ICannonContraptionType, class_2960> IDS_BY_TYPE = new Reference2ObjectOpenHashMap();
    private static final class_2960 EMPTY = CreateBigCannons.resource("empty");

    public static <T extends ICannonContraptionType> T register(class_2960 loc, T type) {
        if (TYPES_BY_ID.containsKey(loc)) {
            throw new IllegalStateException("Cannon contraption type " + loc + " already registered");
        }
        TYPES_BY_ID.put(loc, type);
        IDS_BY_TYPE.put(type, loc);
        return type;
    }

    @Nullable
    public static ICannonContraptionType get(class_2960 loc) {
        return TYPES_BY_ID.get(loc);
    }

    public static Optional<ICannonContraptionType> getOptional(class_2960 loc) {
        return Optional.ofNullable(CannonContraptionTypeRegistry.get(loc));
    }

    public static class_2960 getKey(ICannonContraptionType type) {
        return IDS_BY_TYPE.getOrDefault(type, EMPTY);
    }
}

