/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.block_armor_properties;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesProvider;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesSerializer;
import rbasamoyai.createbigcannons.block_armor_properties.SimpleBlockArmorProperties;
import rbasamoyai.createbigcannons.block_armor_properties.VariantBlockArmorProperties;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.network.RootPacket;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class BlockArmorPropertiesHandler {
    private static final Map<class_2248, SimpleBlockArmorProperties> TAG_MAP = new Reference2ObjectOpenHashMap();
    private static final Map<class_2248, BlockArmorPropertiesProvider> BLOCK_MAP = new Reference2ObjectOpenHashMap();
    private static final Map<class_6862<class_2248>, SimpleBlockArmorProperties> TAGS_TO_EVALUATE = new Object2ObjectLinkedOpenHashMap();
    private static final Map<class_2248, BlockArmorPropertiesSerializer<?>> CUSTOM_SERIALIZERS = new Reference2ReferenceOpenHashMap();
    private static final VariantBlockArmorProperties FALLBACK_PROPERTIES = new VariantBlockArmorProperties(new SimpleBlockArmorProperties(0.0, 0.0), (Map<class_2680, SimpleBlockArmorProperties>)new Reference2ObjectOpenHashMap());
    private static final BlockArmorPropertiesProvider FALLBACK_PROVIDER = new BlockArmorPropertiesProvider(){

        @Override
        public double hardness(class_1937 level, class_2680 state, class_2338 pos, boolean recurse) {
            return 1.0;
        }

        @Override
        public double toughness(class_1937 level, class_2680 state, class_2338 pos, boolean recurse) {
            return state.method_26204().method_9520();
        }

        @Override
        public List<class_2680> containedBlockStates(class_1937 level, class_2680 state, class_2338 pos, boolean recurse) {
            return Lists.newArrayList((Object[])new class_2680[]{state});
        }
    };

    public static void loadTags() {
        TAG_MAP.clear();
        for (Map.Entry<class_6862<class_2248>, SimpleBlockArmorProperties> entry : TAGS_TO_EVALUATE.entrySet()) {
            SimpleBlockArmorProperties properties = entry.getValue();
            for (class_6880<class_2248> holder : CBCRegistryUtils.getBlockTagEntries(entry.getKey())) {
                TAG_MAP.put((class_2248)holder.comp_349(), properties);
            }
        }
        TAGS_TO_EVALUATE.clear();
    }

    public static void syncToAll(MinecraftServer server) {
        NetworkPlatform.sendToClientAll(new ClientboundSyncBlockArmorPropertiesPacket(), server);
    }

    public static void syncTo(class_3222 player) {
        NetworkPlatform.sendToClientPlayer(new ClientboundSyncBlockArmorPropertiesPacket(), player);
    }

    public static void cleanUp() {
        TAG_MAP.clear();
        BLOCK_MAP.clear();
        TAGS_TO_EVALUATE.clear();
    }

    public static BlockArmorPropertiesProvider getProperties(class_2680 state) {
        return BlockArmorPropertiesHandler.getProperties(state.method_26204());
    }

    public static BlockArmorPropertiesProvider getProperties(class_2248 block) {
        if (BLOCK_MAP.containsKey(block)) {
            return BLOCK_MAP.get(block);
        }
        if (TAG_MAP.containsKey(block)) {
            return TAG_MAP.get(block);
        }
        return FALLBACK_PROVIDER;
    }

    public static <T extends BlockArmorPropertiesSerializer<?>> T registerCustomSerializer(class_2248 block, T ser) {
        if (CUSTOM_SERIALIZERS.containsKey(block)) {
            throw new IllegalStateException("Serializer for block " + CBCRegistryUtils.getBlockLocation(block) + " already registered");
        }
        CUSTOM_SERIALIZERS.put(block, ser);
        return ser;
    }

    public static void writeBuf(class_2540 buf) {
        buf.method_10804(TAG_MAP.size());
        for (Map.Entry<class_2248, SimpleBlockArmorProperties> entry : TAG_MAP.entrySet()) {
            buf.method_10812(CBCRegistryUtils.getBlockLocation(entry.getKey()));
            entry.getValue().toNetwork(buf);
        }
        buf.method_10804(BLOCK_MAP.size());
        for (Map.Entry<class_2248, BlockArmorPropertiesProvider> entry : BLOCK_MAP.entrySet()) {
            buf.method_10812(CBCRegistryUtils.getBlockLocation(entry.getKey()));
            BlockArmorPropertiesHandler.toNetworkCasted(entry.getKey(), entry.getValue(), buf);
        }
    }

    private static <T extends BlockArmorPropertiesProvider> void toNetworkCasted(class_2248 block, T properties, class_2540 buf) {
        BlockArmorPropertiesSerializer<?> ser = CUSTOM_SERIALIZERS.get(block);
        if (ser != null) {
            ser.toNetwork(properties, buf);
        } else if (properties instanceof VariantBlockArmorProperties) {
            VariantBlockArmorProperties vbap = (VariantBlockArmorProperties)properties;
            vbap.toNetwork(buf);
        } else {
            CreateBigCannons.LOGGER.warn("Invalid regular block properties encountered for block {}", (Object)block);
            FALLBACK_PROPERTIES.toNetwork(buf);
        }
    }

    public static void readBuf(class_2540 buf) {
        TAG_MAP.clear();
        int tagSz = buf.method_10816();
        for (int i = 0; i < tagSz; ++i) {
            class_2248 block = CBCRegistryUtils.getBlock(buf.method_10810());
            SimpleBlockArmorProperties properties = SimpleBlockArmorProperties.fromNetwork(buf);
            TAG_MAP.put(block, properties);
        }
        BLOCK_MAP.clear();
        int blockSz = buf.method_10816();
        for (int i = 0; i < blockSz; ++i) {
            class_2248 block;
            BlockArmorPropertiesSerializer<?> ser = CUSTOM_SERIALIZERS.get(block = CBCRegistryUtils.getBlock(buf.method_10810()));
            BLOCK_MAP.put(block, ser == null ? VariantBlockArmorProperties.fromNetwork(buf) : ser.fromNetwork(buf));
        }
    }

    public record ClientboundSyncBlockArmorPropertiesPacket(@Nullable class_2540 buf) implements RootPacket
    {
        public ClientboundSyncBlockArmorPropertiesPacket() {
            this(null);
        }

        public static ClientboundSyncBlockArmorPropertiesPacket copyOf(class_2540 buf) {
            return new ClientboundSyncBlockArmorPropertiesPacket(new class_2540(buf.copy()));
        }

        @Override
        public void rootEncode(class_2540 buf) {
            BlockArmorPropertiesHandler.writeBuf(buf);
        }

        @Override
        public void handle(Executor exec, class_2547 listener, @Nullable class_3222 sender) {
            if (this.buf != null) {
                BlockArmorPropertiesHandler.readBuf(this.buf);
            }
        }
    }

    public static class BlockReloadListener
    extends class_4309 {
        private static final Gson GSON = new Gson();
        public static final BlockReloadListener INSTANCE = new BlockReloadListener();

        public BlockReloadListener() {
            super(GSON, "block_armor");
        }

        protected void apply(Map<class_2960, JsonElement> map, class_3300 manager, class_3695 profiler) {
            BlockArmorPropertiesHandler.cleanUp();
            ReferenceOpenHashSet missingSerializers = new ReferenceOpenHashSet(CUSTOM_SERIALIZERS.keySet());
            for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
                JsonElement el = entry.getValue();
                if (!el.isJsonObject()) continue;
                try {
                    class_2960 loc = entry.getKey();
                    if (loc.method_12832().startsWith("tags/")) {
                        class_2960 pruned = CBCUtils.location(loc.method_12836(), loc.method_12832().substring(5));
                        class_6862 tag = class_6862.method_40092(CBCRegistryUtils.getBlockRegistryKey(), (class_2960)pruned);
                        TAGS_TO_EVALUATE.put((class_6862<class_2248>)tag, SimpleBlockArmorProperties.fromJson(el.getAsJsonObject()));
                        continue;
                    }
                    class_2248 block = CBCRegistryUtils.getOptionalBlock(loc).orElseThrow(() -> new JsonSyntaxException("Unknown block '" + loc + "'"));
                    if (CUSTOM_SERIALIZERS.containsKey(block)) {
                        BLOCK_MAP.put(block, (BlockArmorPropertiesProvider)CUSTOM_SERIALIZERS.get(block).loadBlockArmorPropertiesFromJson(block, el.getAsJsonObject()));
                        missingSerializers.remove(block);
                        continue;
                    }
                    BLOCK_MAP.put(block, VariantBlockArmorProperties.fromJson(block, el.getAsJsonObject()));
                }
                catch (Exception exception) {}
            }
            for (class_2248 missing : missingSerializers) {
                CreateBigCannons.LOGGER.warn("Missing custom armor properties entry for block {}", (Object)CBCRegistryUtils.getBlockLocation(missing));
            }
        }
    }
}

