/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.block_armor_properties;

import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesHandler;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesProvider;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.index.CBCItems;

public class BlockArmorInspectionToolItem
extends class_1792 {
    private static final List<Predicate<class_1657>> IS_HOLDING_PREDICATES = new ArrayList<Predicate<class_1657>>();

    public BlockArmorInspectionToolItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public boolean method_7886(class_1799 stack) {
        return true;
    }

    public static boolean isHoldingTool(class_1657 player) {
        for (Predicate<class_1657> predicate : IS_HOLDING_PREDICATES) {
            if (!predicate.test(player)) continue;
            return true;
        }
        return false;
    }

    public static void addBlockArmorInfo(List<class_2561> tooltip, class_1937 level, class_2338 pos, class_2680 blockState) {
        if (blockState.method_26215()) {
            return;
        }
        String precision = ((Integer)CBCConfigs.CLIENT.blockArmorTooltipPrecision.get()).toString();
        String format = "%." + precision + "f";
        BlockArmorPropertiesProvider provider = BlockArmorPropertiesHandler.getProperties(blockState);
        double toughness = provider.toughness(level, blockState, pos, true);
        double hardness = provider.hardness(level, blockState, pos, true);
        Lang.builder().add(Components.translatable((String)"debug.createbigcannons.block_armor_info")).forGoggles(tooltip);
        Lang.builder().add(Components.translatable((String)"debug.createbigcannons.block_toughness").method_27692(class_124.field_1080)).add(Components.literal((String)String.format(format, toughness)).method_27692(class_124.field_1065)).forGoggles(tooltip, 1);
        Lang.builder().add(Components.translatable((String)"debug.createbigcannons.block_hardness").method_27692(class_124.field_1080)).add(Components.literal((String)String.format(format, hardness)).method_27692(class_124.field_1065)).forGoggles(tooltip, 1);
    }

    public static void addIsHoldingPredicate(Predicate<class_1657> predicate) {
        IS_HOLDING_PREDICATES.add(predicate);
    }

    public static void registerDefaultHandlers() {
        BlockArmorInspectionToolItem.addIsHoldingPredicate(BlockArmorInspectionToolItem::defaultHandler);
    }

    private static boolean defaultHandler(class_1657 player) {
        return CBCItems.BLOCK_ARMOR_INSPECTION_TOOL.isIn(player.method_6047()) || CBCItems.BLOCK_ARMOR_INSPECTION_TOOL.isIn(player.method_6079());
    }
}

