/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.template;

import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileDataSerializer;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.tainted.building.view.PositionalBuildView;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.registry.Registries;
import com.direwolf20.buildinggadgets.common.tainted.template.SerialisationSupport;
import com.direwolf20.buildinggadgets.common.tainted.template.TemplateHeader;
import com.direwolf20.buildinggadgets.common.util.CommonUtils;
import com.direwolf20.buildinggadgets.common.util.compression.DataCompressor;
import com.direwolf20.buildinggadgets.common.util.compression.DataDecompressor;
import com.direwolf20.buildinggadgets.common.util.tools.MathUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class Template {
    private final ImmutableMap<class_2338, BlockData> map;
    private TemplateHeader header;
    private final boolean isNormalized;

    public static Template deserialize(class_2487 nbt, @Nullable TemplateHeader externalHeader, boolean persisted) {
        class_2499 posList = nbt.method_10554("pos", 4);
        TemplateHeader.Builder header = TemplateHeader.builderFromNBT(nbt.method_10562("header"));
        if (externalHeader != null) {
            header = header.name(externalHeader.getName()).author(externalHeader.getAuthor());
        }
        DataDecompressor<ITileDataSerializer> serializerDecompressor = persisted ? new DataDecompressor<ITileDataSerializer>(nbt.method_10554("serializer", 8), inbt -> (ITileDataSerializer)Registries.getTileDataSerializers().method_10223(new class_2960(inbt.method_10714())), value -> SerialisationSupport.dummyDataSerializer()) : null;
        DataDecompressor<BlockData> dataDecompressor = new DataDecompressor<BlockData>(nbt.method_10554("data", 10), inbt -> persisted ? BlockData.tryDeserialize((class_2487)inbt, serializerDecompressor, true) : BlockData.tryDeserialize((class_2487)inbt, false), value -> BlockData.AIR);
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (class_2520 inbt2 : posList) {
            class_2503 longNBT = (class_2503)inbt2;
            class_2338 pos = MathUtils.posFromLong(longNBT.method_10699());
            BlockData data = dataDecompressor.apply(MathUtils.readStateId(longNBT.method_10699()));
            mapBuilder.put((Object)pos, (Object)data);
        }
        return new Template((ImmutableMap<class_2338, BlockData>)mapBuilder.build(), header.build());
    }

    public Template(ImmutableMap<class_2338, BlockData> map, TemplateHeader header) {
        this(map, header, false);
    }

    private Template(ImmutableMap<class_2338, BlockData> map, TemplateHeader header, boolean isNormalized) {
        this.map = map;
        this.header = header;
        this.isNormalized = isNormalized;
    }

    public Template() {
        this((ImmutableMap<class_2338, BlockData>)ImmutableMap.of(), TemplateHeader.builder(Region.singleZero()).build());
    }

    public TemplateHeader getHeaderAndForceMaterials(BuildContext context) {
        if (this.header.getRequiredItems() == null) {
            MaterialList materialList = CommonUtils.estimateRequiredItems(this.createViewInContext(context), context, context.getPlayer() != null ? context.getPlayer().method_19538().method_1031(0.0, (double)context.getPlayer().method_5751(), 0.0) : null);
            this.header = TemplateHeader.builderOf(this.header).requiredItems(materialList).build();
        }
        return this.getHeader();
    }

    public TemplateHeader getHeader() {
        return this.header;
    }

    public IBuildView createViewInContext(BuildContext context) {
        return PositionalBuildView.createUnsafe(context, this.map, this.header.getBoundingBox());
    }

    public class_2487 serialize(boolean persisted) {
        if (!this.isNormalized) {
            return this.normalize().serialize(persisted);
        }
        class_2487 res = new class_2487();
        class_2499 posList = new class_2499();
        DataCompressor<BlockData> blockDataCompressor = new DataCompressor<BlockData>();
        DataCompressor<ITileDataSerializer> dataSerializerCompressor = new DataCompressor<ITileDataSerializer>();
        for (Map.Entry entry : this.map.entrySet()) {
            long posEntry = MathUtils.includeStateId(MathUtils.posToLong((class_2338)entry.getKey()), blockDataCompressor.applyAsInt((BlockData)entry.getValue()));
            posList.add((Object)class_2503.method_23251((long)posEntry));
        }
        class_2499 dataList = blockDataCompressor.write(d -> persisted ? d.serialize(dataSerializerCompressor, true) : d.serialize(false));
        class_2499 serializerList = persisted ? dataSerializerCompressor.write(s -> class_2519.method_23256((String)Registries.getTileDataSerializers().method_10221(s).toString())) : null;
        res.method_10566("data", (class_2520)dataList);
        res.method_10566("pos", (class_2520)posList);
        res.method_10566("header", (class_2520)this.header.toNBT(persisted));
        if (persisted) {
            res.method_10566("serializer", (class_2520)serializerList);
        }
        return res;
    }

    public Template rotate(class_2470 rotation) {
        return this.rotate(class_2350.class_2351.field_11052, rotation);
    }

    public Template rotate(class_2350.class_2351 axis, class_2470 rotation) {
        if (this.map.isEmpty()) {
            return this;
        }
        int[][] matrix = MathUtils.rotationMatrixFor(axis, rotation);
        rotation = axis == class_2350.class_2351.field_11052 ? rotation : class_2470.field_11467;
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        Region.Builder regionBuilder = Region.enclosingBuilder();
        for (Map.Entry entry : this.map.entrySet()) {
            class_2338 newPos = MathUtils.matrixMul(matrix, (class_2338)entry.getKey());
            mapBuilder.put((Object)newPos, (Object)((BlockData)entry.getValue()).rotate(rotation));
            regionBuilder.enclose((class_2382)newPos);
        }
        return new Template((ImmutableMap<class_2338, BlockData>)mapBuilder.build(), TemplateHeader.builderOf(this.header, regionBuilder.build()).build()).normalize();
    }

    public Template mirror(class_2350.class_2351 axis) {
        class_2415 mirror;
        int xFac = 1;
        int zFac = 1;
        switch (axis) {
            case field_11048: {
                mirror = class_2415.field_11300;
                zFac = -1;
                break;
            }
            case field_11051: {
                mirror = class_2415.field_11301;
                xFac = -1;
                break;
            }
            default: {
                mirror = class_2415.field_11302;
            }
        }
        Region.Builder regionBuilder = Region.enclosingBuilder();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.map.entrySet()) {
            class_2338 newPos = new class_2338(((class_2338)entry.getKey()).method_10263() * xFac, ((class_2338)entry.getKey()).method_10264(), ((class_2338)entry.getKey()).method_10260() * zFac);
            mapBuilder.put((Object)newPos, (Object)((BlockData)entry.getValue()).mirror(mirror));
            regionBuilder.enclose((class_2382)newPos);
        }
        return new Template((ImmutableMap<class_2338, BlockData>)mapBuilder.build(), TemplateHeader.builderOf(this.header, regionBuilder.build()).build()).normalize();
    }

    public Template replace(Function<class_2338, Optional<BlockData>> replacements) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.map.entrySet()) {
            mapBuilder.put((Object)((class_2338)entry.getKey()), (Object)replacements.apply((class_2338)entry.getKey()).orElse((BlockData)entry.getValue()));
        }
        return new Template((ImmutableMap<class_2338, BlockData>)mapBuilder.build(), this.header, this.isNormalized);
    }

    public Template withName(@Nullable String name) {
        return new Template(this.map, TemplateHeader.builderOf(this.header).name(name).build());
    }

    public Template withNameAndAuthor(@Nullable String name, @Nullable String author) {
        return new Template(this.map, TemplateHeader.builderOf(this.header).name(name).author(author).build());
    }

    public Template clearMaterials() {
        return new Template(this.map, TemplateHeader.builderOf(this.header).requiredItems(null).build());
    }

    public Template normalize() {
        if (this.isNormalized) {
            return this;
        }
        Region region = this.header.getBoundingBox();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.map.entrySet()) {
            builder.put((Object)((class_2338)entry.getKey()).method_10059((class_2382)region.getMin()), (Object)((BlockData)entry.getValue()));
        }
        return new Template((ImmutableMap<class_2338, BlockData>)builder.build(), TemplateHeader.builderOf(this.header, region.inverseTranslate((class_2382)region.getMin())).build(), true);
    }
}

