/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.save;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.network.Target;
import com.direwolf20.buildinggadgets.common.network.bidirection.PacketRequestTemplate;
import com.direwolf20.buildinggadgets.common.network.bidirection.SplitPacketUpdateTemplate;
import com.direwolf20.buildinggadgets.common.tainted.save.TemplateSave;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateProvider;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.apache.logging.log4j.util.TriConsumer;

public final class SaveTemplateProvider
implements ITemplateProvider {
    private final TemplateSave save = new TemplateSave();
    private final Set<ITemplateProvider.IUpdateListener> updateListeners = Collections.newSetFromMap(new WeakHashMap());

    public TemplateSave getSave() {
        return this.save;
    }

    @Override
    public Template getTemplateForKey(ITemplateKey key) {
        UUID id = this.getId(key);
        return this.getSave().getTemplate(id);
    }

    @Override
    public void setTemplate(ITemplateKey key, Template template) {
        this.getSave().setTemplate(key.getOrComputeId(this::getFreeId), template);
        this.notifyListeners(key, template, l -> l::onTemplateUpdate);
    }

    @Override
    public boolean requestUpdate(ITemplateKey key) {
        return false;
    }

    @Override
    public boolean requestRemoteUpdate(ITemplateKey key, class_1937 level) {
        UUID id = this.getId(key);
        Template template = this.getSave().getTemplate(id);
        this.notifyListeners(key, template, l -> l::onTemplateUpdateSend);
        for (class_3222 player : level.method_8503().method_3760().method_14571()) {
            SplitPacketUpdateTemplate.Server.send(id, template, player);
        }
        return true;
    }

    @Override
    public void registerUpdateListener(ITemplateProvider.IUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    @Override
    public void removeUpdateListener(ITemplateProvider.IUpdateListener listener) {
        this.updateListeners.remove(listener);
    }

    @Override
    public UUID getId(ITemplateKey key) {
        return key.getOrComputeId(this::getFreeId);
    }

    @Override
    public boolean requestRemoteUpdate(ITemplateKey key, Target target) {
        UUID id = this.getId(key);
        Template template = this.getSave().getTemplate(id);
        SplitPacketUpdateTemplate.sendToTarget(target, id, template);
        return true;
    }

    @Override
    public boolean requestUpdate(ITemplateKey key, Target target) {
        UUID id = this.getId(key);
        PacketRequestTemplate.sendToTarget(target, id);
        return true;
    }

    private UUID getFreeId() {
        return this.getSave().getFreeUUID();
    }

    private void notifyListeners(ITemplateKey key, Template template, Function<ITemplateProvider.IUpdateListener, TriConsumer<ITemplateProvider, ITemplateKey, Template>> function) {
        for (ITemplateProvider.IUpdateListener listener : this.updateListeners) {
            try {
                function.apply(listener).accept((Object)this, (Object)key, (Object)template);
            }
            catch (Exception e) {
                BuildingGadgets.LOG.error("Update listener threw an exception!", (Throwable)e);
            }
        }
    }

    public void readFromNbt(class_2487 tag) {
        this.save.load(tag);
    }

    public void writeToNbt(class_2487 tag) {
        this.save.method_75(tag);
    }
}

