/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.concurrent;

import com.direwolf20.buildinggadgets.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.tainted.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.tainted.concurrent.ServerTickingScheduler;
import com.direwolf20.buildinggadgets.common.tainted.concurrent.SteppedScheduler;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public final class CopyScheduler
extends SteppedScheduler {
    private final BiConsumer<ImmutableMap<class_2338, BlockData>, Region> finisher;
    private final Iterator<PlacementTarget> targets;
    private final ImmutableMap.Builder<class_2338, BlockData> builder;
    private Region.Builder regionBuilder;

    public static void scheduleCopy(BiConsumer<ImmutableMap<class_2338, BlockData>, Region> finisher, IBuildView worldView, int steps) {
        Preconditions.checkArgument((steps > 0 ? 1 : 0) != 0);
        ServerTickingScheduler.runTicked(new CopyScheduler(Objects.requireNonNull(finisher), Objects.requireNonNull(worldView), steps));
    }

    private CopyScheduler(BiConsumer<ImmutableMap<class_2338, BlockData>, Region> finisher, IBuildView worldView, int steps) {
        super(steps);
        this.finisher = finisher;
        this.targets = worldView.iterator();
        this.builder = ImmutableMap.builder();
    }

    @Override
    protected boolean advance() {
        if (this.targets.hasNext()) {
            PlacementTarget t = this.targets.next();
            if (!t.getData().getState().method_26215() && ((GadgetCopyPaste)OurItems.COPY_PASTE_GADGET_ITEM).isAllowedBlock(t.getData().getState().method_26204())) {
                this.builder.put((Object)t.getPos(), (Object)t.getData());
                if (this.regionBuilder == null) {
                    this.regionBuilder = Region.enclosingBuilder();
                }
                this.regionBuilder.enclose((class_2382)t.getPos());
            }
            return true;
        }
        return false;
    }

    @Override
    protected void onFinish() {
        this.finisher.accept((ImmutableMap<class_2338, BlockData>)this.builder.build(), this.regionBuilder != null ? this.regionBuilder.build() : Region.singleZero());
    }
}

