/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.building;

import com.direwolf20.buildinggadgets.common.tainted.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.util.CommonUtils;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.util.function.BiPredicate;
import java.util.function.ToLongFunction;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import team.reborn.energy.api.EnergyStorage;

public record PlacementChecker(EnergyStorage energyStorage, ToLongFunction<PlacementTarget> energyFun, IItemIndex index, BiPredicate<BuildContext, PlacementTarget> placeCheck) {
    public CheckResult checkPositionWithResult(BuildContext context, PlacementTarget target, boolean giveBackItems, TransactionContext transaction) {
        MatchResult match;
        ImmutableMultiset insertedItems;
        block21: {
            if (target.getPos().method_10264() > context.getWorld().method_31600() || target.getPos().method_10264() < context.getWorld().method_31607() || !this.placeCheck.test(context, target)) {
                return new CheckResult(MatchResult.failure(), (Multiset<ItemVariant>)ImmutableMultiset.of(), false);
            }
            long energy = this.energyFun.applyAsLong(target);
            insertedItems = ImmutableMultiset.of();
            boolean isCreative = context.getPlayer() != null && context.getPlayer().method_7337();
            try (Transaction test = Transaction.openNested((TransactionContext)transaction);){
                if (!isCreative && this.energyStorage.extract(energy, (TransactionContext)test) != energy) {
                    CheckResult checkResult = new CheckResult(MatchResult.failure(), (Multiset<ItemVariant>)insertedItems, false);
                    return checkResult;
                }
            }
            class_3965 targetRayTrace = null;
            if (context.getPlayer() != null) {
                class_1657 player = context.getPlayer();
                targetRayTrace = CommonUtils.fakeRayTrace(player.method_19538(), target.getPos());
            }
            MaterialList materials = target.getRequiredMaterials(context, (class_239)targetRayTrace);
            match = this.index.match(materials, transaction);
            class_3218 world = context.getServerWorld();
            class_2680 state = world.method_8320(target.getPos());
            boolean isAir = state.method_26215();
            if (!isAir) {
                if (!world.method_8505(context.getPlayer(), target.getPos())) {
                    return new CheckResult(match, (Multiset<ItemVariant>)insertedItems, false);
                }
                if (giveBackItems) {
                    insertedItems = (Multiset)TileSupport.createTileData(context.getWorld().method_8321(target.getPos())).getRequiredItems(context, state, null, target.getPos()).iterator().next();
                    this.index.insert((Multiset<ItemVariant>)insertedItems, transaction);
                }
            }
            if (!isCreative) {
                try (Transaction extract = Transaction.openNested((TransactionContext)transaction);){
                    if (this.energyStorage.extract(energy, (TransactionContext)extract) == energy) {
                        extract.commit();
                        break block21;
                    }
                    CheckResult checkResult = new CheckResult(match, (Multiset<ItemVariant>)insertedItems, false);
                    return checkResult;
                }
            }
        }
        return new CheckResult(match, (Multiset<ItemVariant>)insertedItems, match.isSuccess());
    }

    public record CheckResult(MatchResult match, Multiset<ItemVariant> insertedItems, boolean success) {
        public Multiset<ItemVariant> getInsertedItems() {
            return this.insertedItems();
        }

        public MatchResult getMatch() {
            return this.match();
        }

        public boolean isSuccess() {
            return this.success();
        }
    }
}

