/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.config;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@me.shedaniel.autoconfig.annotation.Config(name="building_gadgets")
public class Config
implements ConfigData {
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="general")
    public CategoryGeneral general = new CategoryGeneral();
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="gadgets")
    public CategoryGadgets gadgets = new CategoryGadgets();

    public static class CategoryGeneral {
        @Comment(value="How far away players can build")
        @ConfigEntry.BoundedDiscrete(min=1L, max=48L)
        public double rayTraceRange = 32.0;
        @Comment(value="Defined whether or not a player can use Absolute Coords mode in the Copy Paste Gadget")
        public boolean allowAbsoluteCoords = true;
        @Comment(value="(Client option) Determines if the Copy/Paste GUI's coordinate mode starts in 'Absolute' mode by default., Set to true for Absolute, set to False for Relative.")
        public boolean absoluteCoordDefault = false;
        @Comment(value="Whether the Building / CopyPaste Gadget can overwrite blocks like water, lava, grass, etc (like a player can).\nFalse will only allow it to overwrite air blocks.")
        public boolean allowOverwriteBlocks = true;
    }

    public static class CategoryGadgets {
        @Comment(value="The max range of the Gadgets")
        @ConfigEntry.BoundedDiscrete(min=1L, max=32L)
        public int maxRange = 15;
        @Comment(value="Maximum amount of Blocks to be placed in one Tick.\nNotice that an EffectBlock takes 20 ticks to place, therefore a Server has to handle 20-times this value effect-block Tile's at once.  +\nReduce this if  you notice lag-spikes from Players placing Templates.\nOf course decreasing this value will result in more time required to place large TemplateItem's.")
        @ConfigEntry.BoundedDiscrete(min=1L, max=4096L)
        public int placeSteps = 1024;
        @ConfigEntry.Gui.CollapsibleObject
        @Comment(value="Energy Cost & Durability of the Building Gadget")
        public CategoryGadgetBuilding gadgetBuilding = new CategoryGadgetBuilding();
        @ConfigEntry.Gui.CollapsibleObject
        @Comment(value="Energy Cost & Durability of the Exchanging Gadget")
        public CategoryGadgetExchanger gadgetExchanger = new CategoryGadgetExchanger();
        @ConfigEntry.Gui.CollapsibleObject
        @Comment(value="Energy Cost, Durability & Maximum Energy of the Destruction Gadget")
        public CategoryGadgetDestruction gadgetDestruction = new CategoryGadgetDestruction();
        @Comment(value="Energy Cost & Durability of the Copy-Paste Gadget")
        @ConfigEntry.Gui.CollapsibleObject
        public CategoryGadgetCopyPaste gadgetCopyPaste = new CategoryGadgetCopyPaste();
        @Comment(value="Gadget Max Undo size (Note, the exchanger does not support undo)")
        @ConfigEntry.BoundedDiscrete(min=0L, max=128L)
        public int undoSize = 128;
        @Comment(value="Gadget undo list expiry time (in milliseconds)")
        @ConfigEntry.BoundedDiscrete(min=0L, max=3600000L)
        public int undoExpiry = 300000;

        public static class CategoryGadgetBuilding {
            @Comment(value="The max energy of the Gadget, set to 0 to disable energy usage")
            @ConfigEntry.BoundedDiscrete(min=0L, max=4000000L)
            public long maxEnergy = 500000L;
            @Comment(value="The Gadget's Energy cost per Operation")
            @ConfigEntry.BoundedDiscrete(min=0L, max=4000000L)
            public long energyCost = 50L;
        }

        public static class CategoryGadgetExchanger {
            @Comment(value="The max energy of the Gadget, set to 0 to disable energy usage")
            @ConfigEntry.BoundedDiscrete(min=0L, max=4000000L)
            public long maxEnergy = 500000L;
            @Comment(value="The Gadget's Energy cost per Operation")
            @ConfigEntry.BoundedDiscrete(min=0L, max=4000000L)
            public long energyCost = 50L;
        }

        public static class CategoryGadgetDestruction {
            @Comment(value="The max energy of the Gadget, set to 0 to disable energy usage")
            @ConfigEntry.BoundedDiscrete(min=0L, max=4000000L)
            public long maxEnergy = 1000000L;
            @Comment(value="The Gadget's Energy cost per Operation")
            @ConfigEntry.BoundedDiscrete(min=0L, max=4000000L)
            public long energyCost = 200L;
            @Comment(value="The maximum dimensions, the Destruction Gadget can destroy.")
            @ConfigEntry.BoundedDiscrete(min=0L, max=32L)
            public int destroySize = 16;
            @Comment(value="The cost in energy/durability will increase by this amount when not in fuzzy mode")
            @ConfigEntry.BoundedDiscrete(min=0L, max=4000000L)
            public long nonFuzzyMultiplier = 2L;
            @Comment(value="If enabled, the Destruction Gadget can be taken out of fuzzy mode, allowing only instances of the block clicked to be removed (at a higher cost)")
            public boolean nonFuzzyEnabled = false;
        }

        public static class CategoryGadgetCopyPaste {
            @Comment(value="The max energy of the Gadget, set to 0 to disable energy usage")
            @ConfigEntry.BoundedDiscrete(min=0L, max=4000000L)
            public long maxEnergy = 500000L;
            @Comment(value="The Gadget's Energy cost per Operation")
            @ConfigEntry.BoundedDiscrete(min=0L, max=4000000L)
            public long energyCost = 50L;
            @Comment(value="Maximum amount of Blocks to be copied in one Tick.\nLower values may improve Server-Performance when copying large Templates")
            @ConfigEntry.BoundedDiscrete(min=1L, max=65536L)
            public int copySteps = 32768;
            @Comment(value="Maximum dimensions (x, y and z) that can be copied by a Template without requiring special permission.\nPermission can be granted using the '/buildinggadgets OverrideCopySize [<Player>]' command.")
            @ConfigEntry.BoundedDiscrete(min=-1L, max=2048L)
            public int maxCopySize = 256;
            @Comment(value="Maximum dimensions (x, y and z) that can be build by a Template without requiring special permission.\nPermission can be granted using the '/buildinggadgets OverrideBuildSize [<Player>]' command.")
            @ConfigEntry.BoundedDiscrete(min=-1L, max=256L)
            public int maxBuildSize = 256;
        }
    }
}

