/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.commands;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.util.lang.ITranslationProvider;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

final class AllowPlayerOverrideManager {
    private final Cache<UUID, Boolean> allowPlayerOverrideCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).removalListener(notification -> BuildingGadgets.LOG.info("Player with id {} was removed from the list of players for which '{}' is {} enabled. He/She will need to run the command again for '{}' to become active again.", notification.getKey(), (Object)logMessage, (Object)((Boolean)notification.getValue() != false ? "" : "not"), (Object)logMessage)).build();
    private final ITranslationProvider noPlayerTranslation;
    private final ITranslationProvider toggledTranslation;
    private final ITranslationProvider listTranslation;
    private final String logMessage;

    public AllowPlayerOverrideManager(ITranslationProvider noPlayerTranslation, ITranslationProvider toggledTranslation, ITranslationProvider listTranslation, String logMessage) {
        this.noPlayerTranslation = noPlayerTranslation;
        this.toggledTranslation = toggledTranslation;
        this.listTranslation = listTranslation;
        this.logMessage = logMessage;
    }

    void toggleAllowOverride(class_1657 player) {
        this.toggleAllowOverride(player.method_5667());
    }

    void toggleAllowOverride(UUID uuid) {
        try {
            this.allowPlayerOverrideCache.put((Object)uuid, (Object)((Boolean)this.allowPlayerOverrideCache.get((Object)uuid, () -> false) == false ? 1 : 0));
        }
        catch (ExecutionException e) {
            BuildingGadgets.LOG.warn("Failed to toggle '{}' for player {}", (Object)this.logMessage, (Object)uuid, (Object)e);
        }
    }

    boolean mayOverride(UUID uuid) {
        Boolean res = (Boolean)this.allowPlayerOverrideCache.getIfPresent((Object)uuid);
        return res != null ? res : false;
    }

    boolean mayOverride(class_1657 player) {
        return this.mayOverride(player.method_5667());
    }

    int executeToggle(CommandContext<class_2168> context, class_1657 player) {
        if (player == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)this.noPlayerTranslation.componentTranslation(new Object[0]).method_10862(Styles.RED));
            return 0;
        }
        this.toggleAllowOverride(player);
        ((class_2168)context.getSource()).method_9226((class_2561)this.toggledTranslation.componentTranslation(player.method_5476(), this.mayOverride(player)).method_10862(Styles.AQUA), true);
        return 1;
    }

    int executeList(CommandContext<class_2168> context) {
        for (Map.Entry entry : this.allowPlayerOverrideCache.asMap().entrySet()) {
            class_2588 component = this.listTranslation.componentTranslation(entry.getKey(), entry.getValue());
            component = (class_2588)((Boolean)entry.getValue() != false ? component.method_10862(Styles.BLUE) : component.method_10862(Styles.DK_GREEN));
            ((class_2168)context.getSource()).method_9226((class_2561)component, true);
        }
        return 1;
    }
}

