/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.renders;

import com.direwolf20.buildinggadgets.client.cache.RemoteInventoryCache;
import com.direwolf20.buildinggadgets.client.renderer.OurRenderTypes;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryLinker;
import com.direwolf20.buildinggadgets.common.world.MockBuilderWorld;
import com.google.common.collect.Multiset;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1159;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import team.reborn.energy.api.base.SimpleBatteryItem;

public abstract class BaseRenderer {
    public static final class_2680 AIR = class_2246.field_10124.method_9564();
    private static final MockBuilderWorld builderWorld = new MockBuilderWorld();
    private static final RemoteInventoryCache cacheInventory = new RemoteInventoryCache(false);

    public void renderAfterSetup(WorldRenderContext context, class_1657 player, class_1799 heldItem) {
    }

    public void render(WorldRenderContext evt, class_1657 player, class_1799 heldItem) {
        this.bindBlocks();
        if (this.isLinkable()) {
            BaseRenderer.renderLinkedInventoryOutline(evt, heldItem, player);
        }
    }

    private void bindBlocks() {
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
    }

    private static void renderLinkedInventoryOutline(WorldRenderContext evt, class_1799 gadget, class_1657 player) {
        InventoryLinker.InventoryLink dataFromStack = InventoryLinker.getDataFromStack(gadget);
        if (dataFromStack == null) {
            return;
        }
        if (!player.field_6002.method_27983().equals(dataFromStack.level())) {
            return;
        }
        class_2338 pos = dataFromStack.blockPos();
        class_243 renderPos = evt.camera().method_19326().method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()).method_1031((double)0.005f, (double)0.005f, (double)0.005f);
        class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
        class_4587 stack = evt.matrixStack();
        stack.method_22903();
        stack.method_22904(-renderPos.method_10216(), -renderPos.method_10214(), -renderPos.method_10215());
        stack.method_22905(1.01f, 1.01f, 1.01f);
        BaseRenderer.renderBoxSolid(stack.method_23760().method_23761(), buffer.getBuffer(OurRenderTypes.MissingBlockOverlay), class_2338.field_10980, 0.0f, 1.0f, 0.0f, 0.35f);
        stack.method_22909();
        RenderSystem.disableDepthTest();
        buffer.method_22993();
    }

    long getEnergy(class_1657 player, class_1799 heldItem) {
        if (player.method_7337() || !(heldItem.method_7909() instanceof AbstractGadget)) {
            return Integer.MAX_VALUE;
        }
        return SimpleBatteryItem.getStoredEnergyUnchecked((class_1799)heldItem);
    }

    protected static void renderMissingBlock(class_1159 matrix, class_4588 builder, class_2338 pos) {
        BaseRenderer.renderBoxSolid(matrix, builder, pos, 1.0f, 0.0f, 0.0f, 0.35f);
    }

    protected static void renderBoxSolid(class_1159 matrix, class_4588 builder, class_2338 pos, float r, float g, float b, float alpha) {
        double x = (double)pos.method_10263() - 0.001;
        double y = (double)pos.method_10264() - 0.001;
        double z = (double)pos.method_10260() - 0.001;
        double xEnd = (double)pos.method_10263() + 1.0015;
        double yEnd = (double)pos.method_10264() + 1.0015;
        double zEnd = (double)pos.method_10260() + 1.0015;
        BaseRenderer.renderBoxSolid(matrix, builder, x, y, z, xEnd, yEnd, zEnd, r, g, b, alpha);
    }

    protected static void renderBoxSolid(class_1159 matrix, class_4588 builder, double x, double y, double z, double xEnd, double yEnd, double zEnd, float red, float green, float blue, float alpha) {
        float startX = (float)x;
        float startY = (float)y;
        float startZ = (float)z;
        float endX = (float)xEnd;
        float endY = (float)yEnd;
        float endZ = (float)zEnd;
        builder.method_22918(matrix, startX, startY, startZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, endX, startY, startZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, endX, startY, endZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, startX, startY, endZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, startX, endY, startZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, startX, endY, endZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, endX, endY, endZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, endX, endY, startZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, startX, startY, startZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, startX, endY, startZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, endX, endY, startZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, endX, startY, startZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, startX, startY, endZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, endX, startY, endZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, endX, endY, endZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, startX, endY, endZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, endX, startY, startZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, endX, endY, startZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, endX, endY, endZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, endX, startY, endZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, startX, startY, startZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, startX, startY, endZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, startX, endY, endZ).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix, startX, endY, startZ).method_22915(red, green, blue, alpha).method_1344();
    }

    public boolean isLinkable() {
        return false;
    }

    static class_310 getMc() {
        return class_310.method_1551();
    }

    static MockBuilderWorld getBuilderWorld() {
        return builderWorld;
    }

    static RemoteInventoryCache getCacheInventory() {
        return cacheInventory;
    }

    public static void setInventoryCache(Multiset<ItemVariant> cache) {
        cacheInventory.setCache(cache);
    }

    public static void updateInventoryCache() {
        cacheInventory.forceUpdate();
    }
}

