/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.network.message;

import net.blay09.mods.cookingforblockheads.menu.RecipeBookMenu;
import net.blay09.mods.cookingforblockheads.registry.FoodRecipeType;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class CraftRecipeMessage {
    private final class_1799 outputItem;
    private final FoodRecipeType recipeType;
    private final class_2371<class_1799> craftMatrix;
    private final boolean stack;

    public CraftRecipeMessage(class_1799 outputItem, FoodRecipeType recipeType, class_2371<class_1799> craftMatrix, boolean stack) {
        this.outputItem = outputItem;
        this.recipeType = recipeType;
        this.craftMatrix = craftMatrix;
        this.stack = stack;
    }

    public static void encode(CraftRecipeMessage message, class_2540 buf) {
        buf.method_10793(message.outputItem);
        buf.writeByte(message.recipeType.ordinal());
        buf.writeByte(message.craftMatrix.size());
        for (class_1799 itemstack : message.craftMatrix) {
            buf.method_10793(itemstack);
        }
        buf.writeBoolean(message.stack);
    }

    public static CraftRecipeMessage decode(class_2540 buf) {
        class_1799 outputItem = buf.method_10819();
        FoodRecipeType recipeType = FoodRecipeType.fromId(buf.readByte());
        int ingredientCount = buf.readByte();
        class_2371 craftMatrix = class_2371.method_10211();
        for (int i = 0; i < ingredientCount; ++i) {
            craftMatrix.add((Object)buf.method_10819());
        }
        boolean stack = buf.readBoolean();
        return new CraftRecipeMessage(outputItem, recipeType, (class_2371<class_1799>)craftMatrix, stack);
    }

    public static void handle(class_3222 player, CraftRecipeMessage message) {
        class_1703 container = player.field_7512;
        if (container instanceof RecipeBookMenu) {
            ((RecipeBookMenu)container).tryCraft(message.outputItem, message.recipeType, message.craftMatrix, message.stack);
        }
    }
}

