/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.api.CookingForBlockheadsAPI;
import net.blay09.mods.cookingforblockheads.api.event.FoodRegistryInitEvent;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.compat.json.JsonCompatData;
import net.blay09.mods.cookingforblockheads.compat.json.OvenFuelData;
import net.blay09.mods.cookingforblockheads.compat.json.OvenRecipeData;
import net.blay09.mods.cookingforblockheads.compat.json.ToasterRecipeData;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4013;

public class JsonCompatLoader
implements class_4013 {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).create();
    public static final class_2371<class_1799> nonFoodRecipes = class_2371.method_10211();
    public static final Set<class_2960> kitchenItemProviders = new HashSet<class_2960>();
    public static final Set<class_2960> kitchenConnectors = new HashSet<class_2960>();

    public void method_14491(class_3300 resourceManager) {
        try {
            for (class_2960 resourceLocation : resourceManager.method_14488("cookingforblockheads/compat", it -> it.endsWith(".json"))) {
                try {
                    class_3298 resource = resourceManager.method_14486(resourceLocation);
                    try {
                        InputStreamReader reader = new InputStreamReader(resource.method_14482());
                        JsonCompatLoader.load((JsonCompatData)gson.fromJson((Reader)reader, JsonCompatData.class));
                    }
                    finally {
                        if (resource == null) continue;
                        resource.close();
                    }
                }
                catch (Exception e) {
                    CookingForBlockheads.logger.error("Parsing error loading CookingForBlockheads data files at {}", (Object)resourceLocation, (Object)e);
                }
            }
            for (class_2248 kitchenFloor : ModBlocks.kitchenFloors) {
                KitchenMultiBlock.registerConnectorBlock(kitchenFloor);
            }
        }
        catch (Exception e) {
            CookingForBlockheads.logger.error("Error loading CookingForBlockheads data files", (Throwable)e);
        }
    }

    public static void onCookingRegistry(FoodRegistryInitEvent event) {
        for (class_1799 itemStack : nonFoodRecipes) {
            event.registerNonFoodRecipe(itemStack);
        }
    }

    private static void load(JsonCompatData data) {
        class_1799 output;
        class_1799 input;
        String modId = data.getModId();
        if (!modId.equals("minecraft") && !Balm.isModLoaded((String)modId)) {
            return;
        }
        if (data.getFoods() != null) {
            for (List<class_2960> list : data.getFoods().values()) {
                for (class_2960 registryName : list) {
                    JsonCompatLoader.findItemStack(registryName).ifPresent(arg_0 -> nonFoodRecipes.add(arg_0));
                }
            }
        }
        if (data.getTools() != null) {
            for (class_2960 registryName : data.getTools()) {
                JsonCompatLoader.findItemStack(registryName).ifPresent(CookingForBlockheadsAPI::addToolItem);
            }
        }
        if (data.getWater() != null) {
            for (class_2960 registryName : data.getWater()) {
                JsonCompatLoader.findItemStack(registryName).ifPresent(CookingForBlockheadsAPI::addWaterItem);
            }
        }
        if (data.getMilk() != null) {
            for (class_2960 registryName : data.getMilk()) {
                JsonCompatLoader.findItemStack(registryName).ifPresent(CookingForBlockheadsAPI::addMilkItem);
            }
        }
        if (data.getOvenFuels() != null) {
            for (OvenFuelData ovenFuel : data.getOvenFuels()) {
                JsonCompatLoader.findItemStack(ovenFuel.getItem()).ifPresent(itemStack -> CookingForBlockheadsAPI.addOvenFuel(itemStack, ovenFuel.getValue()));
            }
        }
        if (data.getOvenRecipes() != null) {
            for (OvenRecipeData ovenRecipe : data.getOvenRecipes()) {
                input = JsonCompatLoader.findItemStack(ovenRecipe.getInput()).orElse(class_1799.field_8037);
                output = JsonCompatLoader.findItemStack(ovenRecipe.getOutput()).orElse(class_1799.field_8037);
                if (input.method_7960() || output.method_7960()) continue;
                CookingForBlockheadsAPI.addOvenRecipe(input, output);
            }
        }
        if (data.getToasterRecipes() != null) {
            for (ToasterRecipeData toasterRecipe : data.getToasterRecipes()) {
                input = JsonCompatLoader.findItemStack(toasterRecipe.getInput()).orElse(class_1799.field_8037);
                output = JsonCompatLoader.findItemStack(toasterRecipe.getOutput()).orElse(class_1799.field_8037);
                if (input.method_7960() || output.method_7960()) continue;
                CookingForBlockheadsAPI.addToasterHandler(input, itemStack -> output);
            }
        }
        if (data.getKitchenItemProviders() != null) {
            kitchenItemProviders.addAll(data.getKitchenItemProviders());
        }
        if (data.getKitchenConnectors() != null) {
            for (class_2960 kitchenConnector : data.getKitchenConnectors()) {
                kitchenConnectors.add(kitchenConnector);
                class_2248 connectorBlock = Balm.getRegistries().getBlock(kitchenConnector);
                if (connectorBlock == null || connectorBlock == class_2246.field_10124) continue;
                KitchenMultiBlock.registerConnectorBlock(connectorBlock);
            }
        }
    }

    private static Optional<class_1799> findItemStack(class_2960 registryName) {
        class_1792 item = Balm.getRegistries().getItem(registryName);
        return item == null || item == class_1802.field_8162 ? Optional.empty() : Optional.of(new class_1799((class_1935)item));
    }

    static {
        Balm.getEvents().onEvent(FoodRegistryInitEvent.class, JsonCompatLoader::onCookingRegistry);
    }
}

