/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import java.util.Random;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.client.ModModels;
import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.blay09.mods.cookingforblockheads.tile.CounterBlockEntity;
import net.minecraft.class_1087;
import net.minecraft.class_1158;
import net.minecraft.class_1263;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_776;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class CounterRenderer<T extends CounterBlockEntity>
implements class_827<T> {
    private static final Random random = new Random();
    private static final float doorOriginX = 0.84375f;
    private static final float doorOriginZ = 0.09375f;

    public CounterRenderer(class_5614.class_5615 context) {
    }

    protected float getDoorOriginX() {
        return 0.84375f;
    }

    protected float getDoorOriginZ() {
        return 0.09375f;
    }

    protected float getBottomShelfOffsetY() {
        return -0.85f;
    }

    protected float getTopShelfOffsetY() {
        return 0.35f;
    }

    protected class_1087 getDoorModel(@Nullable class_1767 blockColor, boolean isFlipped) {
        int colorIndex = blockColor != null ? blockColor.method_7789() + 1 : 0;
        return isFlipped ? (class_1087)ModModels.counterDoorsFlipped.get(colorIndex).get() : (class_1087)ModModels.counterDoors.get(colorIndex).get();
    }

    public void render(T blockEntity, float partialTicks, class_4587 poseStack, class_4597 buffer, int combinedLight, int combinedOverlay) {
        class_1937 level = blockEntity.method_10997();
        if (level == null) {
            return;
        }
        class_2680 state = blockEntity.method_11010();
        boolean hasColor = (Boolean)state.method_11654((class_2769)BlockKitchen.HAS_COLOR);
        class_1767 blockColor = hasColor ? (class_1767)state.method_11654(BlockKitchen.COLOR) : null;
        float blockAngle = ((CounterBlockEntity)blockEntity).getFacing().method_10144();
        float doorAngle = ((CounterBlockEntity)blockEntity).getDoorAnimator().getRenderAngle(partialTicks);
        boolean isFlipped = ((CounterBlockEntity)blockEntity).isFlipped();
        poseStack.method_22903();
        float doorOriginX = this.getDoorOriginX();
        float doorOriginZ = this.getDoorOriginZ();
        float doorDirection = -1.0f;
        if (isFlipped) {
            doorOriginX = 1.0f - doorOriginX;
            doorDirection = 1.0f;
        }
        RenderUtils.applyBlockAngle(poseStack, blockEntity.method_11010());
        poseStack.method_22904(-0.5, 0.0, -0.5);
        poseStack.method_22904((double)doorOriginX, 0.0, (double)doorOriginZ);
        poseStack.method_22907(new class_1158(0.0f, doorDirection * (float)Math.toDegrees(doorAngle), 0.0f, true));
        poseStack.method_22904((double)(-doorOriginX), 0.0, (double)(-doorOriginZ));
        class_776 dispatcher = class_310.method_1551().method_1541();
        class_1087 model = this.getDoorModel(blockColor, isFlipped);
        dispatcher.method_3350().method_3374((class_1920)level, model, blockEntity.method_11010(), blockEntity.method_11016(), poseStack, buffer.getBuffer(class_1921.method_23577()), false, random, 0L, 0);
        poseStack.method_22909();
        if (doorAngle > 0.0f) {
            poseStack.method_22903();
            poseStack.method_22904(0.0, 0.5, 0.0);
            RenderUtils.applyBlockAngle(poseStack, blockEntity.method_11010());
            poseStack.method_22905(0.3f, 0.3f, 0.3f);
            class_1263 itemHandler = ((CounterBlockEntity)blockEntity).getContainer();
            int itemsPerShelf = itemHandler.method_5439() / 2;
            int itemsPerRow = itemsPerShelf / 2;
            for (int i = itemHandler.method_5439() - 1; i >= 0; --i) {
                class_1799 itemStack = itemHandler.method_5438(i);
                if (itemStack.method_7960()) continue;
                int shelfIndex = i % itemsPerShelf;
                int rowIndex = i % itemsPerRow;
                float spacing = 2.0f / (float)itemsPerRow;
                float offsetX = ((float)rowIndex - (float)itemsPerRow / 2.0f) * -spacing + (shelfIndex >= itemsPerRow ? -0.2f : 0.0f);
                float offsetY = i < itemsPerShelf ? this.getTopShelfOffsetY() : this.getBottomShelfOffsetY();
                float offsetZ = shelfIndex < itemsPerRow ? 0.5f : -0.5f;
                poseStack.method_22903();
                poseStack.method_22904((double)offsetX, (double)offsetY, (double)offsetZ);
                poseStack.method_22907(new class_1158(0.0f, 45.0f, 0.0f, true));
                RenderUtils.renderItem(itemStack, combinedLight, poseStack, buffer);
                poseStack.method_22909();
            }
            poseStack.method_22909();
        }
    }
}

