/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.FoodRecipeWithStatus;
import net.blay09.mods.cookingforblockheads.api.ISortButton;
import net.blay09.mods.cookingforblockheads.api.RecipeStatus;
import net.blay09.mods.cookingforblockheads.client.gui.SortButton;
import net.blay09.mods.cookingforblockheads.menu.RecipeBookMenu;
import net.blay09.mods.cookingforblockheads.menu.slot.CraftMatrixFakeSlot;
import net.blay09.mods.cookingforblockheads.menu.slot.RecipeFakeSlot;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.FoodRecipeType;
import net.blay09.mods.cookingforblockheads.registry.FoodRecipeWithIngredients;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;

public class RecipeBookScreen
extends class_465<RecipeBookMenu> {
    private static final int SCROLLBAR_COLOR = -5592406;
    private static final int SCROLLBAR_Y = 8;
    private static final int SCROLLBAR_WIDTH = 7;
    private static final int SCROLLBAR_HEIGHT = 77;
    private static final class_2960 guiTexture = new class_2960("cookingforblockheads", "textures/gui/gui.png");
    private static final int VISIBLE_ROWS = 4;
    private final RecipeBookMenu container;
    private int scrollBarScaledHeight;
    private int scrollBarXPos;
    private int scrollBarYPos;
    private int currentOffset;
    private double mouseClickY = -1.0;
    private int indexWhenClicked;
    private int lastNumberOfMoves;
    private class_4185 btnNextRecipe;
    private class_4185 btnPrevRecipe;
    private class_342 searchBar;
    private final List<SortButton> sortButtons = Lists.newArrayList();
    private final String[] noIngredients;
    private final String[] noSelection;

    public RecipeBookScreen(RecipeBookMenu container, class_1661 playerInventory, class_2561 displayName) {
        super((class_1703)container, playerInventory, displayName);
        this.container = container;
        this.noIngredients = class_1074.method_4662((String)"gui.cookingforblockheads:no_ingredients", (Object[])new Object[0]).split("\\\\n");
        this.noSelection = class_1074.method_4662((String)"gui.cookingforblockheads:no_selection", (Object[])new Object[0]).split("\\\\n");
    }

    protected void method_25426() {
        this.field_2779 = 174;
        super.method_25426();
        this.field_22787.field_1774.method_1462(true);
        this.btnPrevRecipe = new class_4185(this.field_22789 / 2 - 79, this.field_22790 / 2 - 51, 13, 20, (class_2561)new class_2585("<"), it -> this.container.nextSubRecipe(-1));
        this.btnPrevRecipe.field_22764 = false;
        this.method_37063((class_364)this.btnPrevRecipe);
        this.btnNextRecipe = new class_4185(this.field_22789 / 2 - 9, this.field_22790 / 2 - 51, 13, 20, (class_2561)new class_2585(">"), it -> this.container.nextSubRecipe(1));
        this.btnNextRecipe.field_22764 = false;
        this.method_37063((class_364)this.btnNextRecipe);
        this.searchBar = new class_342(this.field_22787.field_1772, this.field_2776 + this.field_2792 - 78, this.field_2800 - 5, 70, 10, this.searchBar, (class_2561)new class_2585(""));
        this.method_20085((class_364)this.searchBar);
        int yOffset = -80;
        for (ISortButton button : CookingRegistry.getSortButtons()) {
            SortButton sortButton = new SortButton(this.field_22789 / 2 + 87, this.field_22790 / 2 + yOffset, button, it -> this.container.setSortComparator(((SortButton)it).getComparator((class_1657)class_310.method_1551().field_1724)));
            this.method_37063((class_364)sortButton);
            this.sortButtons.add(sortButton);
            yOffset += 20;
        }
        this.recalculateScrollBar();
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (delta == 0.0) {
            return false;
        }
        if (this.container.getSelection() != null && mouseX >= (double)(this.field_2776 + 7) && mouseY >= (double)(this.field_2800 + 17) && mouseX < (double)(this.field_2776 + 92) && mouseY < (double)(this.field_2800 + 95)) {
            class_1735 slot = ((AbstractContainerScreenAccessor)this).getHoveredSlot();
            if (slot instanceof CraftMatrixFakeSlot && ((CraftMatrixFakeSlot)slot).getVisibleStacks().size() > 1) {
                ((CraftMatrixFakeSlot)slot).scrollDisplayList(delta > 0.0 ? -1 : 1);
            }
        } else {
            this.setCurrentOffset(delta > 0.0 ? this.currentOffset - 1 : this.currentOffset + 1);
        }
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int state) {
        boolean result = super.method_25406(mouseX, mouseY, state);
        if (state != -1 && this.mouseClickY != -1.0) {
            this.mouseClickY = -1.0;
            this.indexWhenClicked = 0;
            this.lastNumberOfMoves = 0;
        }
        return result;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        class_1735 mouseSlot;
        super.method_25402(mouseX, mouseY, button);
        if (button == 1 && mouseX >= (double)this.searchBar.field_22760 && mouseX < (double)(this.searchBar.field_22760 + this.searchBar.method_25368()) && mouseY >= (double)this.searchBar.field_22761 && mouseY < (double)(this.searchBar.field_22761 + this.searchBar.method_25364())) {
            this.searchBar.method_1852("");
            this.container.search(null);
            this.container.populateRecipeSlots();
            this.setCurrentOffset(this.currentOffset);
            return true;
        }
        if (this.searchBar.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (mouseX >= (double)this.scrollBarXPos && mouseX <= (double)(this.scrollBarXPos + 7) && mouseY >= (double)this.scrollBarYPos && mouseY <= (double)(this.scrollBarYPos + this.scrollBarScaledHeight)) {
            this.mouseClickY = mouseY;
            this.indexWhenClicked = this.currentOffset;
        }
        if ((mouseSlot = ((AbstractContainerScreenAccessor)this).getHoveredSlot()) instanceof CraftMatrixFakeSlot) {
            if (button == 0) {
                class_1799 itemStack = mouseSlot.method_7677();
                FoodRecipeWithStatus recipe = this.container.findAvailableRecipe(itemStack);
                if (recipe != null) {
                    this.container.setSelectedRecipe(recipe, false);
                    this.setCurrentOffset(this.container.getSelectedRecipeIndex());
                } else if (!CookingRegistry.getFoodRecipes(itemStack).isEmpty()) {
                    this.container.setSelectedRecipe(new FoodRecipeWithStatus(itemStack, RecipeStatus.MISSING_INGREDIENTS), true);
                }
            } else if (button == 1) {
                ((CraftMatrixFakeSlot)mouseSlot).setLocked(!((CraftMatrixFakeSlot)mouseSlot).isLocked());
            }
            return true;
        }
        return false;
    }

    public boolean method_25400(char c, int keyCode) {
        boolean result = super.method_25400(c, keyCode);
        this.container.search(this.searchBar.method_1882());
        this.container.populateRecipeSlots();
        this.setCurrentOffset(this.currentOffset);
        return result;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.field_22787.field_1724.method_7346();
            return true;
        }
        if (this.searchBar.method_25404(keyCode, scanCode, modifiers) || this.searchBar.method_25370()) {
            this.container.search(this.searchBar.method_1882());
            this.container.populateRecipeSlots();
            this.setCurrentOffset(this.currentOffset);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void method_2389(class_4587 poseStack, float partialTicks, int mouseX, int mouseY) {
        int curY;
        int numberOfFiltersMoved;
        float pixelsPerFilter;
        if (this.container.isDirty()) {
            this.setCurrentOffset(this.currentOffset);
            this.container.setDirty(false);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)guiTexture);
        this.method_25302(poseStack, this.field_2776, this.field_2800 - 10, 0, 0, this.field_2792, this.field_2779 + 10);
        if (this.mouseClickY != -1.0 && (pixelsPerFilter = (float)(77 - this.scrollBarScaledHeight) / (float)Math.max(1, (int)Math.ceil((float)this.container.getItemListCount() / 3.0f) - 4)) != 0.0f && (numberOfFiltersMoved = (int)(((double)mouseY - this.mouseClickY) / (double)pixelsPerFilter)) != this.lastNumberOfMoves) {
            this.setCurrentOffset(this.indexWhenClicked + numberOfFiltersMoved);
            this.lastNumberOfMoves = numberOfFiltersMoved;
        }
        this.btnPrevRecipe.field_22764 = this.container.hasVariants();
        this.btnPrevRecipe.field_22763 = this.container.getSelectionIndex() > 0;
        this.btnNextRecipe.field_22764 = this.container.hasVariants();
        this.btnNextRecipe.field_22763 = this.container.getSelectionIndex() < this.container.getRecipeCount() - 1;
        boolean hasRecipes = this.container.getItemListCount() > 0;
        for (class_4185 class_41852 : this.sortButtons) {
            class_41852.field_22763 = hasRecipes;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_327 fontRenderer = this.field_22787.field_1772;
        FoodRecipeWithIngredients foodRecipeWithIngredients = this.container.getSelection();
        if (foodRecipeWithIngredients == null) {
            int n = this.noSelection.length / 2;
            Objects.requireNonNull(fontRenderer);
            curY = this.field_2800 + 39 - n * 9;
            for (String s : this.noSelection) {
                fontRenderer.method_1720(poseStack, s, (float)(this.field_2776 + 23 + 27) - (float)fontRenderer.method_1727(s) / 2.0f, (float)curY, -1);
                Objects.requireNonNull(fontRenderer);
                curY += 9 + 5;
            }
        } else if (foodRecipeWithIngredients.getRecipeType() == FoodRecipeType.SMELTING) {
            this.method_25302(poseStack, this.field_2776 + 23, this.field_2800 + 19, 54, 184, 54, 54);
        } else {
            this.method_25302(poseStack, this.field_2776 + 23, this.field_2800 + 19, 0, 184, 54, 54);
        }
        if (foodRecipeWithIngredients != null) {
            for (CraftMatrixFakeSlot slot : this.container.getCraftingMatrixSlots()) {
                if (!slot.isLocked() || slot.getVisibleStacks().size() <= 1) continue;
                this.method_25302(poseStack, this.field_2776 + slot.field_7873, this.field_2800 + slot.field_7872, 176, 60, 16, 16);
            }
        }
        RecipeBookScreen.method_25294((class_4587)poseStack, (int)this.scrollBarXPos, (int)this.scrollBarYPos, (int)(this.scrollBarXPos + 7), (int)(this.scrollBarYPos + this.scrollBarScaledHeight), (int)-5592406);
        if (this.container.getItemListCount() == 0) {
            RecipeBookScreen.method_25294((class_4587)poseStack, (int)(this.field_2776 + 97), (int)(this.field_2800 + 7), (int)(this.field_2776 + 168), (int)(this.field_2800 + 85), (int)-1440603614);
            int n = this.noIngredients.length / 2;
            Objects.requireNonNull(fontRenderer);
            curY = this.field_2800 + 39 - n * 9;
            for (String s : this.noIngredients) {
                fontRenderer.method_1720(poseStack, s, (float)(this.field_2776 + 97 + 36) - (float)fontRenderer.method_1727(s) / 2.0f, (float)curY, -1);
                Objects.requireNonNull(fontRenderer);
                curY += 9 + 5;
            }
        }
        this.searchBar.method_25359(poseStack, mouseX, mouseY, partialTicks);
    }

    protected void method_2388(class_4587 poseStack, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)guiTexture);
        if (CookingForBlockheadsConfig.getActive().showIngredientIcon) {
            int prevZLevel = this.method_25305();
            this.method_25304(300);
            for (class_1735 slot : this.container.field_7761) {
                FoodRecipeWithStatus recipe;
                if (!(slot instanceof RecipeFakeSlot)) continue;
                if (CookingRegistry.isNonFoodRecipe(slot.method_7677())) {
                    this.method_25302(poseStack, slot.field_7873, slot.field_7872, 176, 76, 16, 16);
                }
                if ((recipe = ((RecipeFakeSlot)slot).getRecipe()) == null || recipe.getStatus() != RecipeStatus.MISSING_TOOLS) continue;
                this.method_25302(poseStack, slot.field_7873, slot.field_7872, 176, 92, 16, 16);
            }
            this.method_25304(prevZLevel);
        }
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(poseStack);
        super.method_25394(poseStack, mouseX, mouseY, partialTicks);
        int prevZLevel = this.method_25305();
        this.method_25304(300);
        for (class_1735 class_17352 : this.container.field_7761) {
            if (!(class_17352 instanceof CraftMatrixFakeSlot) || ((CraftMatrixFakeSlot)class_17352).isAvailable() || class_17352.method_7677().method_7960()) continue;
            this.method_25296(poseStack, this.field_2776 + class_17352.field_7873, this.field_2800 + class_17352.field_7872, this.field_2776 + class_17352.field_7873 + 16, this.field_2800 + class_17352.field_7872 + 16, 0x77FF4444, 0x77FF5555);
        }
        this.method_25304(prevZLevel);
        this.container.updateSlots(partialTicks);
        for (class_4185 class_41852 : this.sortButtons) {
            if (!(class_41852 instanceof SortButton) || !class_41852.method_25405((double)mouseX, (double)mouseY) || !class_41852.field_22763) continue;
            this.method_30901(poseStack, ((SortButton)class_41852).getTooltipLines(), mouseX, mouseY);
        }
        this.method_2380(poseStack, mouseX, mouseY);
    }

    public void method_25419() {
        super.method_25419();
        this.field_22787.field_1774.method_1462(false);
    }

    private void recalculateScrollBar() {
        int scrollBarTotalHeight = 76;
        this.scrollBarScaledHeight = (int)((double)scrollBarTotalHeight * Math.min(1.0, 4.0 / Math.ceil((float)this.container.getItemListCount() / 3.0f)));
        this.scrollBarXPos = this.field_2776 + this.field_2792 - 7 - 9;
        this.scrollBarYPos = this.field_2800 + 8 + (scrollBarTotalHeight - this.scrollBarScaledHeight) * this.currentOffset / Math.max(1, (int)Math.ceil((float)this.container.getItemListCount() / 3.0f) - 4);
    }

    private void setCurrentOffset(int currentOffset) {
        this.currentOffset = Math.max(0, Math.min(currentOffset, (int)Math.ceil((float)this.container.getItemListCount() / 3.0f) - 4));
        this.container.setScrollOffset(this.currentOffset);
        this.recalculateScrollBar();
    }

    public class_4185[] getSortingButtons() {
        return this.sortButtons.toArray(new SortButton[0]);
    }
}

