/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.mod.util;

import dev.latvian.mods.rhino.mod.util.RemapperException;
import dev.latvian.mods.rhino.mod.util.RemappingHelper;
import dev.latvian.mods.rhino.util.Remapper;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MinecraftRemapper
implements Remapper {
    private final Map<String, RemappedClass> classMap;
    private final Map<String, String> unmapClassMap;

    private static int readVarInt(InputStream stream) throws Exception {
        return RemappingHelper.readVarInt(stream);
    }

    private static String readUtf(InputStream stream) throws Exception {
        return RemappingHelper.readUtf(stream);
    }

    public static MinecraftRemapper load(InputStream stream, boolean debug) throws Exception {
        MinecraftRemapper m = new MinecraftRemapper(new HashMap<String, RemappedClass>(), new HashMap<String, String>());
        m.load0(stream, debug);
        return m;
    }

    private void load0(InputStream stream, boolean debug) throws Exception {
        int index;
        int i;
        if (stream.read() != 0) {
            throw new RemapperException("Invalid Minecraft Remapper file!");
        }
        int version = stream.read();
        if (version > 1) {
            throw new RemapperException("Invalid Minecraft Remapper file version!");
        }
        RemappingHelper.LOGGER.info("Loading mappings for " + MinecraftRemapper.readUtf(stream));
        int unmappedTypes = MinecraftRemapper.readVarInt(stream);
        RemappedType[] mappedTypes = new RemappedType[MinecraftRemapper.readVarInt(stream)];
        int arrayTypes = MinecraftRemapper.readVarInt(stream);
        RemappedType[] types = new RemappedType[unmappedTypes + mappedTypes.length + arrayTypes];
        if (debug) {
            RemappingHelper.LOGGER.info("Unmapped Types: " + unmappedTypes);
            RemappingHelper.LOGGER.info("Mapped Types: " + mappedTypes.length);
            RemappingHelper.LOGGER.info("Array Types: " + arrayTypes);
            RemappingHelper.LOGGER.info("Total Types: " + types.length);
        }
        for (i = 0; i < unmappedTypes; ++i) {
            index = MinecraftRemapper.readVarInt(stream);
            String name = MinecraftRemapper.readUtf(stream);
            types[index] = new RemappedType(new RemappedClass(name, name, false), 0);
        }
        for (i = 0; i < mappedTypes.length; ++i) {
            index = MinecraftRemapper.readVarInt(stream);
            String realName = MinecraftRemapper.readUtf(stream);
            String remappedName = MinecraftRemapper.readUtf(stream);
            types[index] = new RemappedType(new RemappedClass(realName.isEmpty() ? remappedName : realName, remappedName, true), 0);
            mappedTypes[i] = types[index];
            this.classMap.put(types[index].parent.realName, types[index].parent);
        }
        for (i = 0; i < arrayTypes; ++i) {
            index = MinecraftRemapper.readVarInt(stream);
            int type = MinecraftRemapper.readVarInt(stream);
            int array = MinecraftRemapper.readVarInt(stream);
            if (type < 0 || type >= types.length || types[type] == null) {
                throw new RemapperException("Invalid array index: " + type + "!");
            }
            types[index] = new RemappedType(types[type].parent, array);
        }
        String[] sig = new String[MinecraftRemapper.readVarInt(stream)];
        for (int i2 = 0; i2 < sig.length; ++i2) {
            int params = MinecraftRemapper.readVarInt(stream);
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            for (int j = 0; j < params; ++j) {
                sb.append(types[MinecraftRemapper.readVarInt(stream)].descriptorString());
            }
            sig[i2] = sb.toString();
        }
        for (RemappedType c : mappedTypes) {
            String remappedName;
            String realName;
            int i3;
            if (debug) {
                RemappingHelper.LOGGER.info(String.format("- %s -> %s", c.parent.realName, c.parent.remappedName));
            }
            int fields = MinecraftRemapper.readVarInt(stream);
            int arg0 = MinecraftRemapper.readVarInt(stream);
            int argN = MinecraftRemapper.readVarInt(stream);
            for (i3 = 0; i3 < fields; ++i3) {
                String unmappedName = MinecraftRemapper.readUtf(stream);
                String mmName = MinecraftRemapper.readUtf(stream);
                if (unmappedName.isEmpty() || mmName.isEmpty() || unmappedName.equals(mmName)) continue;
                if (c.parent.fields == null) {
                    c.parent.fields = new HashMap<String, String>(arg0 + argN);
                }
                c.parent.fields.put(unmappedName, mmName);
                if (!debug) continue;
                RemappingHelper.LOGGER.info(String.format("  %s -> %s", unmappedName, mmName));
            }
            for (i3 = 0; i3 < arg0; ++i3) {
                realName = MinecraftRemapper.readUtf(stream);
                remappedName = MinecraftRemapper.readUtf(stream);
                if (realName.isEmpty() || remappedName.isEmpty() || realName.equals(remappedName)) continue;
                if (c.parent.emptyMethods == null) {
                    c.parent.emptyMethods = new HashMap<String, String>(arg0);
                }
                c.parent.emptyMethods.put(realName, remappedName);
                if (!debug) continue;
                RemappingHelper.LOGGER.info(String.format("  %s() -> %s", realName, remappedName));
            }
            for (i3 = 0; i3 < argN; ++i3) {
                realName = MinecraftRemapper.readUtf(stream);
                remappedName = MinecraftRemapper.readUtf(stream);
                if (realName.isEmpty() || remappedName.isEmpty() || realName.equals(remappedName)) continue;
                if (c.parent.methods == null) {
                    c.parent.methods = new HashMap<String, String>(argN);
                }
                int index2 = MinecraftRemapper.readVarInt(stream);
                String key = realName + sig[index2];
                c.parent.methods.put(key, remappedName);
                if (!debug) continue;
                RemappingHelper.LOGGER.info(String.format("  %s -> %s", key, remappedName));
            }
        }
    }

    MinecraftRemapper(Map<String, RemappedClass> m1, Map<String, String> m2) {
        this.classMap = m1;
        this.unmapClassMap = m2;
    }

    @Override
    public String getMappedClass(Class<?> from) {
        RemappedClass c = this.classMap.get(from.getName());
        return c == null ? "" : c.remappedName;
    }

    @Override
    public String getUnmappedClass(String mmName) {
        if (this.classMap.isEmpty()) {
            return "";
        }
        String s = this.unmapClassMap.get(mmName);
        if (s == null) {
            s = "";
            for (RemappedClass c : this.classMap.values()) {
                if (!c.remappedName.equals(mmName)) continue;
                s = c.realName;
            }
            this.unmapClassMap.put(mmName, s);
        }
        return s;
    }

    @Override
    public String getMappedField(Class<?> from, Field field) {
        if (from == null || from == Object.class || from.getPackageName().startsWith("java.")) {
            return "";
        }
        RemappedClass c = this.classMap.get(from.getName());
        return c == null || c.fields == null ? "" : c.fields.getOrDefault(field.getName(), "");
    }

    @Override
    public String getMappedMethod(Class<?> from, Method method) {
        if (from == null || from == Object.class || from.getPackageName().startsWith("java.")) {
            return "";
        }
        RemappedClass c = this.classMap.get(from.getName());
        if (c == null) {
            return "";
        }
        if (method.getParameterCount() == 0) {
            return c.emptyMethods == null ? "" : c.emptyMethods.getOrDefault(method.getName(), "");
        }
        if (c.methods == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(method.getName());
        sb.append('(');
        for (Class<?> t : method.getParameterTypes()) {
            sb.append(t.descriptorString());
        }
        return c.methods.getOrDefault(sb.toString(), "");
    }

    private static final class RemappedType {
        private final RemappedClass parent;
        private final int array;
        private String descriptorString;

        private RemappedType(RemappedClass parent, int array) {
            this.parent = parent;
            this.array = array;
        }

        public String toString() {
            if (this.array == 0) {
                return this.parent.toString();
            }
            return this.parent.toString() + "[]".repeat(this.array);
        }

        public boolean isRemapped() {
            return this.array == 0 && this.parent.remapped;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof RemappedType)) return false;
            RemappedType type = (RemappedType)obj;
            if (type.parent != this.parent) return false;
            if (type.array != this.array) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.parent, this.array);
        }

        public String descriptorString() {
            if (this.descriptorString == null) {
                this.descriptorString = this.array > 0 ? "[".repeat(this.array) + this.parent.descriptorString() : this.parent.descriptorString();
            }
            return this.descriptorString;
        }
    }

    private static final class RemappedClass {
        private final String realName;
        private final String remappedName;
        private final boolean remapped;
        private Map<String, String> fields;
        private Map<String, String> emptyMethods;
        private Map<String, String> methods;
        private String descriptorString;

        private RemappedClass(String realName, String remappedName, boolean remapped) {
            this.realName = realName;
            this.remappedName = remappedName;
            this.remapped = remapped;
            this.fields = null;
            this.emptyMethods = null;
            this.methods = null;
        }

        public String toString() {
            if (this.remapped) {
                return this.remappedName + "[" + this.realName + "]";
            }
            return this.realName;
        }

        public String descriptorString() {
            if (this.descriptorString == null) {
                this.descriptorString = switch (this.realName) {
                    case "boolean" -> "Z";
                    case "byte" -> "B";
                    case "char" -> "C";
                    case "short" -> "S";
                    case "int" -> "I";
                    case "long" -> "J";
                    case "float" -> "F";
                    case "double" -> "D";
                    case "void" -> "V";
                    default -> "L" + this.realName.replace('.', '/') + ";";
                };
            }
            return this.descriptorString;
        }
    }
}

