/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.classdata;

import dev.latvian.mods.rhino.classdata.ClassDataCache;
import dev.latvian.mods.rhino.classdata.ClassMember;
import dev.latvian.mods.rhino.classdata.MethodInfo;
import dev.latvian.mods.rhino.classdata.MethodSignature;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ClassData {
    public final ClassDataCache cache;
    public final Class<?> type;
    private ClassData parent;
    private Map<String, ClassMember> ownMembers;
    private Map<String, ClassMember> actualMembers;
    private Map<MethodSignature, Constructor<?>> constructors;

    private static boolean isVoid(Class<?> c) {
        return c == Void.TYPE || c == Void.class;
    }

    private static boolean isBoolean(Class<?> c) {
        return c == Boolean.TYPE || c == Boolean.class;
    }

    ClassData(ClassDataCache c, Class<?> t) {
        this.cache = c;
        this.type = t;
    }

    @Nullable
    public ClassData getParent() {
        if (this.parent == null) {
            if (this == this.cache.objectClassData) {
                return null;
            }
            this.parent = this.cache.of(this.type.getSuperclass());
        }
        return this.parent;
    }

    private ClassMember make(String name) {
        ClassMember m = this.ownMembers.get(name);
        if (m == null) {
            m = new ClassMember(this, name);
            this.ownMembers.put(name, m);
        }
        return m;
    }

    private Map<String, ClassMember> getOwnMembers() {
        if (this.ownMembers == null) {
            ClassMember cm;
            String n;
            int m;
            if (this.type == Object.class) {
                this.ownMembers = Map.of();
                return this.ownMembers;
            }
            this.ownMembers = new HashMap<String, ClassMember>();
            for (Field field : this.type.getDeclaredFields()) {
                m = field.getModifiers();
                if (!Modifier.isPublic(m) || Modifier.isTransient(m) || field.isAnnotationPresent(HideFromJS.class)) continue;
                n = this.cache.data.getRemapper().getMappedField(this.type, field);
                cm = this.make(n);
                cm.field = field;
                cm.isFinal = Modifier.isFinal(m);
            }
            for (AccessibleObject accessibleObject : this.type.getDeclaredMethods()) {
                m = ((Method)accessibleObject).getModifiers();
                if (!Modifier.isPublic(m) || Modifier.isNative(m)) continue;
                n = this.cache.data.getRemapper().getMappedMethod(this.type, (Method)accessibleObject);
                cm = this.make(n);
                if (cm.methods == null) {
                    cm.methods = new HashMap<MethodSignature, MethodInfo>();
                }
                MethodInfo mi = new MethodInfo();
                mi.method = accessibleObject;
                mi.signature = MethodSignature.of(((Method)accessibleObject).getParameterTypes());
                cm.methods.put(mi.signature, mi);
                mi.isHidden = accessibleObject.isAnnotationPresent(HideFromJS.class);
                if (mi.isHidden) continue;
                if (mi.signature.types.length == 0 && n.length() >= 4 && !ClassData.isVoid(((Method)accessibleObject).getReturnType()) && Character.isUpperCase(n.charAt(3)) && n.startsWith("get")) {
                    mi.bean = n.substring(3, 4).toLowerCase() + n.substring(4);
                    this.make((String)mi.bean).beanGet = mi;
                    continue;
                }
                if (mi.signature.types.length == 1 && n.length() >= 4 && Character.isUpperCase(n.charAt(3)) && n.startsWith("set")) {
                    mi.bean = n.substring(3, 4).toLowerCase() + n.substring(4);
                    this.make((String)mi.bean).beanSet = mi;
                    continue;
                }
                if (mi.signature.types.length != 0 || n.length() < 3 || !ClassData.isBoolean(((Method)accessibleObject).getReturnType()) || !Character.isUpperCase(n.charAt(2)) || !n.startsWith("is")) continue;
                mi.bean = n.substring(2, 3).toLowerCase() + n.substring(3);
                this.make((String)mi.bean).beanGet = mi;
            }
            if (this.ownMembers.isEmpty()) {
                this.ownMembers = Map.of();
            }
        }
        return this.ownMembers;
    }

    private Map<String, ClassMember> getActualMembers() {
        if (this.actualMembers == null) {
            HashMap<String, ClassMember> members = new HashMap<String, ClassMember>();
            ArrayDeque<ClassData> stack = new ArrayDeque<ClassData>();
            stack.add(this);
            while (!stack.isEmpty()) {
                ClassData current = (ClassData)stack.pop();
                for (ClassMember member : current.getOwnMembers().values()) {
                    ClassMember existing = (ClassMember)members.get(member.name);
                    if (existing == null) {
                        existing = new ClassMember(this, member.name);
                        members.put(member.name, existing);
                    }
                    existing.merge(member);
                }
                for (Class<?> iface : current.type.getInterfaces()) {
                    stack.add(this.cache.of(iface));
                }
                ClassData parent = current.getParent();
                if (parent == null) continue;
                stack.add(parent);
            }
            this.actualMembers = new HashMap<String, ClassMember>(members.size());
            for (ClassMember member : members.values()) {
                this.actualMembers.put(member.name, member);
            }
            if (this.actualMembers.isEmpty()) {
                this.actualMembers = Map.of();
            }
        }
        return this.actualMembers;
    }

    @Nullable
    public ClassMember getMember(String name) {
        return this.getActualMembers().get(name);
    }

    @Nullable
    public Constructor<?> getConstructor(MethodSignature sig) {
        if (this.constructors == null) {
            this.constructors = new HashMap();
            for (Constructor<?> c : this.type.getDeclaredConstructors()) {
                int m = c.getModifiers();
                if (!Modifier.isPublic(m) || c.isAnnotationPresent(HideFromJS.class)) continue;
                this.constructors.put(MethodSignature.of(c.getParameterTypes()), c);
            }
        }
        return this.constructors.get(sig);
    }
}

