/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.SharedContextData;
import dev.latvian.mods.rhino.Symbol;
import dev.latvian.mods.rhino.SymbolKey;
import dev.latvian.mods.rhino.SymbolScriptable;
import dev.latvian.mods.rhino.Undefined;
import dev.latvian.mods.rhino.Wrapper;
import java.lang.reflect.Array;

public class NativeJavaArray
extends NativeJavaObject
implements SymbolScriptable {
    SharedContextData contextData;
    Object array;
    int length;
    Class<?> cls;

    public static NativeJavaArray wrap(SharedContextData data, Scriptable scope, Object array) {
        return new NativeJavaArray(data, scope, array);
    }

    public NativeJavaArray(SharedContextData contextData, Scriptable scope, Object array) {
        super(scope, null, ScriptRuntime.ObjectClass);
        this.contextData = contextData;
        Class<?> cl = array.getClass();
        if (!cl.isArray()) {
            throw new RuntimeException("Array expected");
        }
        this.array = array;
        this.length = Array.getLength(array);
        this.cls = cl.getComponentType();
    }

    @Override
    public String getClassName() {
        return "JavaArray";
    }

    @Override
    public Object unwrap() {
        return this.array;
    }

    @Override
    public boolean has(String id, Scriptable start) {
        return id.equals("length") || super.has(id, start);
    }

    @Override
    public boolean has(int index, Scriptable start) {
        return 0 <= index && index < this.length;
    }

    @Override
    public boolean has(Symbol key, Scriptable start) {
        return SymbolKey.IS_CONCAT_SPREADABLE.equals(key) || super.has(key, start);
    }

    @Override
    public Object get(String id, Scriptable start) {
        if (id.equals("length")) {
            return this.length;
        }
        Object result = super.get(id, start);
        if (result == NOT_FOUND && !ScriptableObject.hasProperty(this.getPrototype(), id)) {
            throw Context.reportRuntimeError2("msg.java.member.not.found", this.array.getClass().getName(), id);
        }
        return result;
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (0 <= index && index < this.length) {
            Object obj = Array.get(this.array, index);
            return this.contextData.getWrapFactory().wrap(this.contextData, this, obj, this.cls);
        }
        return Undefined.instance;
    }

    @Override
    public Object get(Symbol key, Scriptable start) {
        if (SymbolKey.IS_CONCAT_SPREADABLE.equals(key)) {
            return Boolean.TRUE;
        }
        return super.get(key, start);
    }

    @Override
    public void put(String id, Scriptable start, Object value) {
        if (!id.equals("length")) {
            throw Context.reportRuntimeError1("msg.java.array.member.not.found", id);
        }
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
        if (0 > index || index >= this.length) {
            throw Context.reportRuntimeError2("msg.java.array.index.out.of.bounds", String.valueOf(index), String.valueOf(this.length - 1));
        }
        Array.set(this.array, index, Context.jsToJava(this.contextData, value, this.cls));
    }

    @Override
    public void delete(Symbol key) {
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (hint == null || hint == ScriptRuntime.StringClass) {
            return this.array.toString();
        }
        if (hint == ScriptRuntime.BooleanClass) {
            return Boolean.TRUE;
        }
        if (hint == ScriptRuntime.NumberClass) {
            return ScriptRuntime.NaNobj;
        }
        return this;
    }

    @Override
    public Object[] getIds() {
        Object[] result = new Object[this.length];
        int i = this.length;
        while (--i >= 0) {
            result[i] = i;
        }
        return result;
    }

    @Override
    public boolean hasInstance(Scriptable value) {
        if (!(value instanceof Wrapper)) {
            return false;
        }
        Object instance = ((Wrapper)((Object)value)).unwrap();
        return this.cls.isInstance(instance);
    }

    @Override
    public Scriptable getPrototype() {
        if (this.prototype == null) {
            this.prototype = ScriptableObject.getArrayPrototype(this.getParentScope());
        }
        return this.prototype;
    }
}

