/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.utils;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2361;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2680;
import net.minecraft.class_3499;
import net.minecraft.class_3551;
import net.minecraft.class_4284;
import org.jetbrains.annotations.Nullable;

public class StructureLoader {
    private static final Map<String, List<class_3499.class_3501>> structureRepository = Maps.newHashMap();

    public static List<class_3499.class_3501> get(String name) {
        return structureRepository.computeIfAbsent(name, key -> {
            try {
                return StructureLoader.loadStructure(key);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        });
    }

    private static List<class_3499.class_3501> loadStructure(String name) throws IOException {
        if (name.contains("..")) {
            throw new IOException();
        }
        class_2487 NbtCompound = class_2507.method_30613((File)new File("quests_structures/" + name + ".nbt"));
        if (!NbtCompound.method_10573("DataVersion", 99)) {
            NbtCompound.method_10569("DataVersion", 500);
        }
        class_2487 nbt = class_2512.method_10688((DataFixer)class_3551.method_15450(), (class_4284)class_4284.field_19217, (class_2487)NbtCompound, (int)NbtCompound.method_10550("DataVersion"));
        return StructureLoader.loadPalette(nbt.method_10554("palette", 10), nbt.method_10554("blocks", 10), -nbt.method_10554("size", 3).method_10600(0) / 2);
    }

    public static class_2470 getRotation(class_2350 dir) {
        if (dir == class_2350.field_11043) {
            return class_2470.field_11464;
        }
        if (dir == class_2350.field_11039) {
            return class_2470.field_11463;
        }
        if (dir == class_2350.field_11034) {
            return class_2470.field_11465;
        }
        return class_2470.field_11467;
    }

    public static boolean isValidStructure(class_1937 world, class_2338 base, class_2470 rot, List<class_3499.class_3501> template, boolean ignoreState) {
        for (class_3499.class_3501 info : template) {
            class_2338 pos = base.method_10081((class_2382)info.field_15597.method_10069(0, 0, 1).method_10070(rot));
            class_2680 state = world.method_8320(pos);
            class_2680 state2 = info.field_15596.method_26186(rot);
            if (!(ignoreState ? state.method_26204() != state2.method_26204() : !state.equals(state2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidState(class_2680 state, class_2680 state2, boolean ignoreState) {
        if (ignoreState) {
            return state.method_26204() == state2.method_26204();
        }
        return state.equals(state2);
    }

    private static List<class_3499.class_3501> loadPalette(class_2499 palette, class_2499 states, int offsetX) {
        BasicPalette template$basicpalette = new BasicPalette();
        for (int i = 0; i < palette.size(); ++i) {
            template$basicpalette.addMapping(class_2512.method_10681((class_2487)palette.method_10602(i)), i);
        }
        ArrayList<class_3499.class_3501> blocks = new ArrayList<class_3499.class_3501>();
        for (int j = 0; j < states.size(); ++j) {
            class_2487 NbtCompound = states.method_10602(j);
            class_2499 listnbt = NbtCompound.method_10554("pos", 3);
            class_2338 blockpos = new class_2338(listnbt.method_10600(0) + offsetX, listnbt.method_10600(1), listnbt.method_10600(2));
            class_2680 blockstate = template$basicpalette.stateFor(NbtCompound.method_10550("state"));
            class_2487 NbtCompound1 = null;
            if (NbtCompound.method_10545("nbt")) {
                NbtCompound1 = NbtCompound.method_10562("nbt");
                NbtCompound1.method_10569("x", blockpos.method_10263());
                NbtCompound1.method_10569("y", blockpos.method_10264());
                NbtCompound1.method_10569("z", blockpos.method_10260());
            }
            class_3499.class_3501 info2 = new class_3499.class_3501(blockpos, blockstate, NbtCompound1);
            blocks.add(info2);
        }
        Comparator<class_3499.class_3501> comparator = Comparator.comparingInt(info -> info.field_15597.method_10264()).thenComparingInt(info -> info.field_15597.method_10263()).thenComparingInt(info -> info.field_15597.method_10260());
        blocks.sort(comparator);
        return blocks;
    }

    static class BasicPalette
    implements Iterable<class_2680> {
        public static final class_2680 DEFAULT_BLOCK_STATE = class_2246.field_10124.method_9564();
        private final class_2361<class_2680> ids = new class_2361(16);

        private BasicPalette() {
        }

        @Nullable
        public class_2680 stateFor(int id) {
            class_2680 blockstate = (class_2680)this.ids.method_10200(id);
            return blockstate == null ? DEFAULT_BLOCK_STATE : blockstate;
        }

        @Override
        public Iterator<class_2680> iterator() {
            return this.ids.iterator();
        }

        public void addMapping(class_2680 state, int id) {
            this.ids.method_10203((Object)state, id);
        }
    }
}

