/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.tasks;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2554;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3544;
import questsadditions.tasks.TasksRegistry;
import questsadditions.tasks.TimeMatch;

public class TimeTask
extends Task {
    long elapsedTime = 60L;
    TimeMatch gameTime = TimeMatch.AUTO;

    public TimeTask(Quest quest) {
        super(quest);
    }

    public TaskType getType() {
        return TasksRegistry.TIME;
    }

    public long getMaxProgress() {
        return Long.MAX_VALUE;
    }

    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10544("elapsedTime", this.elapsedTime);
        if (this.gameTime != TimeMatch.AUTO) {
            nbt.method_10582("gameTime", this.gameTime.name);
        }
    }

    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.elapsedTime = nbt.method_10537("elapsedTime");
        this.gameTime = (TimeMatch)((Object)TimeMatch.NAME_MAP.get(nbt.method_10558("gameTime")));
    }

    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10791(this.elapsedTime);
        TimeMatch.NAME_MAP.write(buffer, (Object)this.gameTime);
    }

    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.elapsedTime = buffer.method_10792();
        this.gameTime = (TimeMatch)((Object)TimeMatch.NAME_MAP.read(buffer));
    }

    @Environment(value=EnvType.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("elapsedTime", this.elapsedTime, v -> {
            this.elapsedTime = v;
        }, 60L, 1L, Long.MAX_VALUE);
        config.addEnum("gameTime", (Object)this.gameTime, v -> {
            this.gameTime = v;
        }, TimeMatch.NAME_MAP, (Object)TimeMatch.AUTO);
    }

    @Environment(value=EnvType.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
    }

    @Environment(value=EnvType.CLIENT)
    public class_2554 getButtonText() {
        return (class_2554)class_2585.field_24366;
    }

    @Environment(value=EnvType.CLIENT)
    public void addMouseOverText(TooltipList list, TeamData teamData) {
        list.reset();
        list.add(this.getTitle());
        if (!teamData.isCompleted((QuestObject)this) && teamData.getProgress((Task)this) != 0L) {
            list.blankLine();
            list.add((class_2561)this.timeRemaining(teamData).method_27692(class_124.field_1054));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class_2588 timeRemaining(TeamData teamData) {
        int current_time = (int)(teamData.getProgress((Task)this) + 20L - (this.useGameTime(!class_310.method_1551().method_1496()) ? class_310.method_1551().field_1687.method_8510() : System.currentTimeMillis() / 50L));
        return new class_2588("ftbquests.task.time_remaining", new Object[]{class_3544.method_15439((int)current_time)});
    }

    private boolean useGameTime(boolean isServer) {
        return this.gameTime == TimeMatch.AUTO ? isServer : this.gameTime == TimeMatch.GAME;
    }

    public int autoSubmitOnPlayerTick() {
        return 10;
    }

    public void submitTask(TeamData teamData, class_3222 player, class_1799 craftedItem) {
        if (!teamData.isCompleted((QuestObject)this)) {
            long current_time;
            long l = current_time = this.useGameTime(player.method_5682().method_3816()) ? player.method_14220().method_8510() : System.currentTimeMillis() / 50L;
            if (teamData.getProgress((Task)this) == 0L) {
                teamData.setProgress((Task)this, current_time + this.elapsedTime * 20L);
                teamData.setStarted(this.id, null);
            } else if (current_time > teamData.getProgress((Task)this)) {
                teamData.setProgress((Task)this, this.getMaxProgress());
            }
        }
    }
}

