/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.rewards;

import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3222;
import questsadditions.rewards.RepeatableReward;
import questsadditions.rewards.RewardsRegistry;

public class RandomRepeatableReward
extends RepeatableReward {
    public RandomRepeatableReward(Quest quest) {
        super(quest);
    }

    @Override
    protected void claim(RewardTable table, class_3222 player) {
        for (WeightedReward reward : table.rewards) {
            if (reward.weight != 0) continue;
            reward.reward.claim(player, false);
        }
        int totalWeight = table.getTotalWeight(false);
        if (totalWeight <= 0) {
            return;
        }
        int number = player.field_6002.field_9229.nextInt(totalWeight) + 1;
        int currentWeight = 0;
        for (WeightedReward reward : table.rewards) {
            if ((currentWeight += reward.weight) < number) continue;
            reward.reward.claim(player, false);
            return;
        }
    }

    @Override
    public RewardType getType() {
        return RewardsRegistry.REPEAT_RANDOM;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addMouseOverText(TooltipList list) {
        if (this.getTable() != null) {
            this.getTable().addMouseOverText(list, true, false);
        }
    }
}

