/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.mixin;

import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import questsadditions.mixinutils.IMixinQuest;
import questsadditions.rewards.Repeatable;

@Mixin(value={TeamData.class})
public abstract class MixinTeamData {
    @Inject(method={"claimReward(Lnet/minecraft/server/network/ServerPlayerEntity;Ldev/ftb/mods/ftbquests/quest/reward/Reward;Z)V"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Ldev/ftb/mods/ftbquests/quest/reward/Reward;claim(Lnet/minecraft/server/network/ServerPlayerEntity;Z)V")}, cancellable=true, remap=true)
    private void claimReward(class_3222 player, Reward reward, boolean notify, CallbackInfo cir) {
        if (reward instanceof Repeatable) {
            cir.cancel();
        } else if (((IMixinQuest)reward.quest).isRepeatable() && !((TeamData)this).hasUnclaimedRewards(player.method_5667(), (QuestObject)reward.quest)) {
            ProgressChange progressChange = new ProgressChange((QuestFile)ServerQuestFile.INSTANCE);
            progressChange.origin = reward.quest;
            progressChange.player = player.method_5667();
            TeamData teamData = ServerQuestFile.INSTANCE.getData((class_1297)player);
            teamData.setStarted(reward.quest.id, null);
            teamData.setCompleted(reward.quest.id, null);
            for (QuestObject child : reward.quest.getChildren()) {
                child.forceProgress(teamData, progressChange);
            }
            for (QuestObject child : reward.quest.rewards) {
                child.forceProgress(teamData, progressChange);
            }
            cir.cancel();
        }
    }

    @Inject(method={"canStartTasks(Ldev/ftb/mods/ftbquests/quest/Quest;)Z"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void canStartTasks(Quest quest, CallbackInfoReturnable<Boolean> cir) {
        List<QuestObject> incompatible = ((IMixinQuest)quest).getIncompatibleQuests();
        if (!incompatible.isEmpty()) {
            for (QuestObject object : incompatible) {
                if (object.invalid || !((TeamData)this).isCompleted(object)) continue;
                cir.setReturnValue((Object)false);
                return;
            }
        }
    }
}

