/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerycreate.requirements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.simibubi.create.AllBlocks;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import fr.frinn.custommachinerycreate.Registration;
import fr.frinn.custommachinerycreate.components.ContraptionMachineComponent;
import java.util.Locale;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public class ContraptionRequirement
extends AbstractRequirement<ContraptionMachineComponent>
implements ITickableRequirement<ContraptionMachineComponent>,
IDisplayInfoRequirement {
    public static final NamedCodec<ContraptionRequirement> CODEC = NamedCodec.record(contraptionRequirementInstance -> contraptionRequirementInstance.group((App)RequirementIOMode.CODEC.fieldOf("mode").forGetter(IRequirement::getMode), (App)NamedCodec.floatRange((float)0.0f, (float)Float.MAX_VALUE).fieldOf("speed").forGetter(requirement -> Float.valueOf(requirement.speed)), (App)NamedCodec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("stress", (Object)Float.valueOf(0.0f)).forGetter(requirement -> Float.valueOf(requirement.stress))).apply((Applicative)contraptionRequirementInstance, ContraptionRequirement::new), (String)"Contraption requirement");
    private final float speed;
    private final float stress;

    public ContraptionRequirement(RequirementIOMode mode, float speed, float stress) {
        super(mode);
        this.speed = speed;
        this.stress = stress;
    }

    public RequirementType<ContraptionRequirement> getType() {
        return (RequirementType)Registration.CONTRAPTION_REQUIREMENT.get();
    }

    public MachineComponentType<ContraptionMachineComponent> getComponentType() {
        return (MachineComponentType)Registration.CONTRAPTION_MACHINE_COMPONENT.get();
    }

    public boolean test(ContraptionMachineComponent component, ICraftingContext context) {
        int speed = (int)context.getModifiedValue((double)this.speed, (IRequirement)this, null);
        if (this.getMode() == RequirementIOMode.INPUT) {
            return (component.getFakeTile().getTheoreticalSpeed() >= (float)speed || component.getFakeTile().getTheoreticalSpeed() <= (float)(-speed)) && !component.getFakeTile().isOverStressed();
        }
        return true;
    }

    public CraftingResult processStart(ContraptionMachineComponent component, ICraftingContext context) {
        float speed = (float)context.getModifiedValue((double)this.speed, (IRequirement)this, null);
        float stress = (float)context.getModifiedValue((double)this.stress, (IRequirement)this, "stress");
        if (this.getMode() == RequirementIOMode.INPUT) {
            component.set(0.0f, 0.0f, stress);
        } else {
            component.set(speed, stress, 0.0f);
        }
        return CraftingResult.pass();
    }

    public CraftingResult processEnd(ContraptionMachineComponent component, ICraftingContext context) {
        component.markForReset();
        return CraftingResult.pass();
    }

    public CraftingResult processTick(ContraptionMachineComponent component, ICraftingContext context) {
        if (this.getMode() != RequirementIOMode.INPUT) {
            return CraftingResult.pass();
        }
        float speed = (float)context.getModifiedValue((double)this.speed, (IRequirement)this, null);
        if (Math.abs(component.getFakeTile().getTheoreticalSpeed()) < speed) {
            return CraftingResult.error((class_2561)new class_2588("custommachinerycreate.requirement.contraption.error.speed.input", new Object[]{Float.valueOf(speed), Float.valueOf(Math.abs(component.getFakeTile().getTheoreticalSpeed()))}));
        }
        if (component.getFakeTile().isOverStressed()) {
            return CraftingResult.error((class_2561)new class_2588("custommachinerycreate.requirement.contraption.error.stress.input"));
        }
        return CraftingResult.success();
    }

    public void getDisplayInfo(IDisplayInfo info) {
        info.setItemIcon(AllBlocks.COGWHEEL.asStack());
        String mode = this.getMode().name().toLowerCase(Locale.ROOT);
        info.addTooltip((class_2561)new class_2588("custommachinerycreate.requirement.contraption.info.speed." + mode, new Object[]{Float.valueOf(this.speed)}));
        if (this.stress != 0.0f) {
            info.addTooltip((class_2561)new class_2588("custommachinerycreate.requirement.contraption.info.stress." + mode, new Object[]{Float.valueOf(this.stress)}));
        }
    }
}

