/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerycreate.integration.crafttweaker.craft;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.common.integration.crafttweaker.CustomCraftRecipeCTBuilder;
import fr.frinn.custommachinerycreate.requirements.ContraptionRequirement;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Expansion(value="mods.custommachinery.CraftRecipeBuilder")
public class ContraptionRequirementCT {
    @ZenCodeType.Method
    public static CustomCraftRecipeCTBuilder requireSU(CustomCraftRecipeCTBuilder builder, float speed) {
        return ContraptionRequirementCT.requireSU(builder, speed, 0.0f);
    }

    @ZenCodeType.Method
    public static CustomCraftRecipeCTBuilder requireSU(CustomCraftRecipeCTBuilder builder, float speed, float stressImpact) {
        return ContraptionRequirementCT.addContraptionRequirement(builder, RequirementIOMode.INPUT, speed, stressImpact);
    }

    @ZenCodeType.Method
    public static CustomCraftRecipeCTBuilder produceSU(CustomCraftRecipeCTBuilder builder, float speed) {
        return ContraptionRequirementCT.produceSU(builder, speed, 0.0f);
    }

    @ZenCodeType.Method
    public static CustomCraftRecipeCTBuilder produceSU(CustomCraftRecipeCTBuilder builder, float speed, float stressCapacity) {
        return ContraptionRequirementCT.addContraptionRequirement(builder, RequirementIOMode.OUTPUT, speed, stressCapacity);
    }

    private static CustomCraftRecipeCTBuilder addContraptionRequirement(CustomCraftRecipeCTBuilder builder, RequirementIOMode mode, float speed, float stress) {
        if (speed < 0.0f) {
            return builder.error("Speed value cannot be negative: {}", new Object[]{Float.valueOf(speed)});
        }
        if (stress < 0.0f) {
            return builder.error("Stress value cannot be negative: {}", new Object[]{Float.valueOf(stress)});
        }
        return builder.addRequirement((IRequirement)new ContraptionRequirement(mode, speed, stress));
    }
}

