/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.function;

import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.Resumable;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.debug.DebugHandler;
import org.squiddev.cobalt.debug.DebugState;
import org.squiddev.cobalt.function.LibFunction;

public abstract class ResumableVarArgFunction<T>
extends LibFunction
implements Resumable<Object> {
    private static final Object CALL_MARKER = new Object();
    private static final Object RETURN_MARKER = new Object();

    @Override
    public final LuaValue call(LuaState state) throws LuaError, UnwindThrowable {
        return this.invoke(state, Constants.NONE).first();
    }

    @Override
    public final LuaValue call(LuaState state, LuaValue arg) throws LuaError, UnwindThrowable {
        return this.invoke(state, arg).first();
    }

    @Override
    public final LuaValue call(LuaState state, LuaValue arg1, LuaValue arg2) throws LuaError, UnwindThrowable {
        return this.invoke(state, ValueFactory.varargsOf(arg1, (Varargs)arg2)).first();
    }

    @Override
    public final LuaValue call(LuaState state, LuaValue arg1, LuaValue arg2, LuaValue arg3) throws LuaError, UnwindThrowable {
        return this.invoke(state, ValueFactory.varargsOf(arg1, arg2, (Varargs)arg3)).first();
    }

    @Override
    public final Varargs invoke(LuaState state, Varargs args) throws LuaError, UnwindThrowable {
        DebugState ds = DebugHandler.getDebugState(state);
        DebugFrame di = ds.pushJavaInfo();
        di.setFunction(this, null);
        di.flags |= 0x1000;
        if (!ds.inhook && ds.hookcall) {
            try {
                ds.hookCall(di);
            }
            catch (UnwindThrowable e) {
                di.state = CALL_MARKER;
                di.extras = args;
                throw e;
            }
        }
        Varargs result = this.invoke(state, di, args);
        ResumableVarArgFunction.onReturn(state.debug, ds, di, result);
        return result;
    }

    @Override
    public final Varargs resume(LuaState state, Object object, Varargs value) throws LuaError, UnwindThrowable {
        DebugState ds = DebugHandler.getDebugState(state);
        if (object == CALL_MARKER) {
            DebugFrame di = ds.getStackUnsafe();
            if (ds.inhook && (di.flags & 4) != 0) {
                ds.inhook = false;
                di.flags ^= 4;
            }
            di.state = null;
            Varargs result = this.invoke(state, di, di.extras);
            ResumableVarArgFunction.onReturn(state.debug, ds, di, result);
            return result;
        }
        if (object == RETURN_MARKER) {
            DebugFrame di = ds.getStackUnsafe();
            if (ds.inhook && (di.flags & 4) != 0) {
                ds.inhook = false;
            }
            Varargs args = di.extras;
            state.debug.onReturnError(ds);
            return args;
        }
        Varargs result = this.resumeThis(state, object, value);
        ResumableVarArgFunction.onReturn(state.debug, ds, ds.getStackUnsafe(), result);
        return result;
    }

    @Override
    public final Varargs resumeError(LuaState state, Object object, LuaError error) throws LuaError, UnwindThrowable {
        if (object == RETURN_MARKER || object == CALL_MARKER) {
            throw error;
        }
        Varargs result = this.resumeErrorThis(state, object, error);
        DebugState ds = DebugHandler.getDebugState(state);
        ResumableVarArgFunction.onReturn(state.debug, ds, ds.getStack(), result);
        return result;
    }

    protected abstract Varargs invoke(LuaState var1, DebugFrame var2, Varargs var3) throws LuaError, UnwindThrowable;

    protected abstract Varargs resumeThis(LuaState var1, T var2, Varargs var3) throws LuaError, UnwindThrowable;

    protected Varargs resumeErrorThis(LuaState state, T object, LuaError error) throws LuaError, UnwindThrowable {
        throw error;
    }

    private static void onReturn(DebugHandler debug, DebugState ds, DebugFrame di, Varargs result) throws LuaError, UnwindThrowable {
        try {
            debug.onReturn(ds, di);
        }
        catch (UnwindThrowable e) {
            di.state = RETURN_MARKER;
            di.extras = result;
            throw e;
        }
    }
}

