/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.common.base.Predicate;
import com.google.common.collect.MapMaker;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.apache.commons.lang3.tuple.Pair;

public final class WorldUtil {
    private static final Predicate<class_1297> CAN_COLLIDE = x -> x != null && x.method_5805() && x.method_5863();
    private static final Map<class_1937, class_1297> entityCache = new MapMaker().weakKeys().weakValues().makeMap();

    private static synchronized class_1297 getEntity(class_1937 world) {
        Object entity = entityCache.get(world);
        if (entity != null) {
            return entity;
        }
        entity = new class_1542(class_1299.field_6052, world){

            @Nonnull
            public class_4048 method_18377(@Nonnull class_4050 pose) {
                return class_4048.method_18385((float)0.0f, (float)0.0f);
            }
        };
        entity.field_5960 = true;
        entity.method_18382();
        entityCache.put(world, (class_1297)entity);
        return entity;
    }

    public static boolean isLiquidBlock(class_1937 world, class_2338 pos) {
        if (!world.method_24794(pos)) {
            return false;
        }
        return world.method_8320(pos).method_26207().method_15797();
    }

    public static boolean isVecInside(class_265 shape, class_243 vec) {
        if (shape.method_1110()) {
            return false;
        }
        class_238 bb = shape.method_1107();
        return vec.field_1352 >= bb.field_1323 && vec.field_1352 <= bb.field_1320 && vec.field_1351 >= bb.field_1322 && vec.field_1351 <= bb.field_1325 && vec.field_1350 >= bb.field_1321 && vec.field_1350 <= bb.field_1324;
    }

    public static Pair<class_1297, class_243> rayTraceEntities(class_1937 world, class_243 vecStart, class_243 vecDir, double distance) {
        class_243 vecEnd = vecStart.method_1031(vecDir.field_1352 * distance, vecDir.field_1351 * distance, vecDir.field_1350 * distance);
        class_1297 collisionEntity = WorldUtil.getEntity(world);
        collisionEntity.method_5814(vecStart.field_1352, vecStart.field_1351, vecStart.field_1350);
        class_3959 context = new class_3959(vecStart, vecEnd, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, collisionEntity);
        class_3965 result = world.method_17742(context);
        if (result != null && result.method_17783() == class_239.class_240.field_1332) {
            distance = vecStart.method_1022(result.method_17784());
            vecEnd = vecStart.method_1031(vecDir.field_1352 * distance, vecDir.field_1351 * distance, vecDir.field_1350 * distance);
        }
        float xStretch = Math.abs(vecDir.field_1352) > 0.25 ? 0.0f : 1.0f;
        float yStretch = Math.abs(vecDir.field_1351) > 0.25 ? 0.0f : 1.0f;
        float zStretch = Math.abs(vecDir.field_1350) > 0.25 ? 0.0f : 1.0f;
        class_238 bigBox = new class_238(Math.min(vecStart.field_1352, vecEnd.field_1352) - (double)(0.375f * xStretch), Math.min(vecStart.field_1351, vecEnd.field_1351) - (double)(0.375f * yStretch), Math.min(vecStart.field_1350, vecEnd.field_1350) - (double)(0.375f * zStretch), Math.max(vecStart.field_1352, vecEnd.field_1352) + (double)(0.375f * xStretch), Math.max(vecStart.field_1351, vecEnd.field_1351) + (double)(0.375f * yStretch), Math.max(vecStart.field_1350, vecEnd.field_1350) + (double)(0.375f * zStretch));
        class_1297 closest = null;
        double closestDist = 99.0;
        List list = world.method_8390(class_1297.class, bigBox, CAN_COLLIDE);
        for (class_1297 entity : list) {
            class_238 littleBox = entity.method_5829();
            if (littleBox.method_1006(vecStart)) {
                closest = entity;
                closestDist = 0.0;
                continue;
            }
            class_243 littleBoxResult = littleBox.method_992(vecStart, vecEnd).orElse(null);
            if (littleBoxResult != null) {
                double dist = vecStart.method_1022(littleBoxResult);
                if (closest != null && !(dist <= closestDist)) continue;
                closest = entity;
                closestDist = dist;
                continue;
            }
            if (!littleBox.method_994(bigBox) || closest != null) continue;
            closest = entity;
            closestDist = distance;
        }
        if (closest != null && closestDist <= distance) {
            class_243 closestPos = vecStart.method_1031(vecDir.field_1352 * closestDist, vecDir.field_1351 * closestDist, vecDir.field_1350 * closestDist);
            return Pair.of((Object)closest, (Object)closestPos);
        }
        return null;
    }

    public static class_243 getRayStart(class_1309 entity) {
        return entity.method_5836(1.0f);
    }

    public static class_243 getRayEnd(class_1657 player) {
        double reach = 5.0;
        class_243 look = player.method_5720();
        return WorldUtil.getRayStart((class_1309)player).method_1031(look.field_1352 * reach, look.field_1351 * reach, look.field_1350 * reach);
    }

    public static void dropItemStack(@Nonnull class_1799 stack, class_1937 world, class_2338 pos) {
        WorldUtil.dropItemStack(stack, world, pos, null);
    }

    public static void dropItemStack(@Nonnull class_1799 stack, class_1937 world, class_2338 pos, class_2350 direction) {
        double zDir;
        double yDir;
        double xDir;
        if (direction != null) {
            xDir = direction.method_10148();
            yDir = direction.method_10164();
            zDir = direction.method_10165();
        } else {
            xDir = 0.0;
            yDir = 0.0;
            zDir = 0.0;
        }
        double xPos = (double)pos.method_10263() + 0.5 + xDir * 0.4;
        double yPos = (double)pos.method_10264() + 0.5 + yDir * 0.4;
        double zPos = (double)pos.method_10260() + 0.5 + zDir * 0.4;
        WorldUtil.dropItemStack(stack, world, new class_243(xPos, yPos, zPos), xDir, yDir, zDir);
    }

    public static void dropItemStack(@Nonnull class_1799 stack, class_1937 world, class_243 pos) {
        WorldUtil.dropItemStack(stack, world, pos, 0.0, 0.0, 0.0);
    }

    public static void dropItemStack(@Nonnull class_1799 stack, class_1937 world, class_243 pos, double xDir, double yDir, double zDir) {
        class_1542 item = new class_1542(world, pos.field_1352, pos.field_1351, pos.field_1350, stack.method_7972());
        item.method_18800(xDir * 0.7 + (double)world.method_8409().nextFloat() * 0.2 - 0.1, yDir * 0.7 + (double)world.method_8409().nextFloat() * 0.2 - 0.1, zDir * 0.7 + (double)world.method_8409().nextFloat() * 0.2 - 0.1);
        item.method_6988();
        world.method_8649((class_1297)item);
    }
}

