/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import dan200.computercraft.fabric.mixininterface.IMatrix4f;
import dan200.computercraft.shared.TurtlePermissions;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.core.TurtlePlaceCommand;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1159;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_4590;
import net.minecraft.class_5134;
import net.minecraft.class_6862;
import org.apache.commons.lang3.tuple.Pair;

public class TurtleTool
extends AbstractTurtleUpgrade {
    protected static final TurtleCommandResult UNBREAKABLE = TurtleCommandResult.failure("Cannot break unbreakable block");
    protected static final TurtleCommandResult INEFFECTIVE = TurtleCommandResult.failure("Cannot break block with this tool");
    final class_1799 item;
    final float damageMulitiplier;
    @Nullable
    final class_6862<class_2248> breakable;

    public TurtleTool(class_2960 id, class_1792 item, float damageMulitiplier, @Nullable class_6862<class_2248> breakable) {
        super(id, TurtleUpgradeType.TOOL, new class_1799((class_1935)item));
        this.item = new class_1799((class_1935)item);
        this.damageMulitiplier = damageMulitiplier;
        this.breakable = breakable;
    }

    @Override
    public boolean isItemSuitable(@Nonnull class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag == null || tag.method_33133()) {
            return true;
        }
        if (stack.method_7986() || stack.method_7942() || stack.method_7938()) {
            return false;
        }
        return !tag.method_10573("AttributeModifiers", 9) || tag.method_10554("AttributeModifiers", 10).isEmpty();
    }

    @Override
    @Nonnull
    @Environment(value=EnvType.CLIENT)
    public TransformedModel getModel(ITurtleAccess turtle, @Nonnull TurtleSide side) {
        return TransformedModel.of(this.getCraftingItem(), side == TurtleSide.LEFT ? Transforms.leftTransform : Transforms.rightTransform);
    }

    @Override
    @Nonnull
    public TurtleCommandResult useTool(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side, @Nonnull TurtleVerb verb, @Nonnull class_2350 direction) {
        switch (verb) {
            case ATTACK: {
                return this.attack(turtle, direction);
            }
            case DIG: {
                return this.dig(turtle, direction);
            }
        }
        return TurtleCommandResult.failure("Unsupported action");
    }

    protected TurtleCommandResult checkBlockBreakable(class_2680 state, class_1937 world, class_2338 pos, TurtlePlayer player) {
        class_2248 block = state.method_26204();
        if (state.method_26215() || block == class_2246.field_9987 || state.method_26165((class_1657)player, (class_1922)world, pos) <= 0.0f) {
            return UNBREAKABLE;
        }
        return this.breakable == null || state.method_26164(this.breakable) || this.isTriviallyBreakable((class_1922)world, pos, state) ? TurtleCommandResult.success() : INEFFECTIVE;
    }

    private TurtleCommandResult attack(ITurtleAccess turtle, class_2350 direction) {
        class_243 rayDir;
        TileTurtle turtleTile;
        class_1937 world = turtle.getLevel();
        class_2338 position = turtle.getPosition();
        TileTurtle tileTurtle = turtleTile = turtle instanceof TurtleBrain ? ((TurtleBrain)turtle).getOwner() : world.method_8321(position);
        if (turtleTile == null) {
            return TurtleCommandResult.failure("Turtle has vanished from existence.");
        }
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, position, direction);
        class_243 turtlePos = turtlePlayer.method_19538();
        Pair<class_1297, class_243> hit = WorldUtil.rayTraceEntities(world, turtlePos, rayDir = turtlePlayer.method_5828(1.0f), 1.5);
        if (hit != null) {
            float damage;
            class_1799 stackCopy = this.item.method_7972();
            turtlePlayer.loadInventory(stackCopy);
            class_1297 hitEntity = (class_1297)hit.getKey();
            if (((AttackEntityCallback)AttackEntityCallback.EVENT.invoker()).interact((class_1657)turtlePlayer, world, class_1268.field_5808, hitEntity, null) == class_1269.field_5814 || !hitEntity.method_5732()) {
                return TurtleCommandResult.failure("Nothing to attack here");
            }
            DropConsumer.set(hitEntity, TurtleTool.turtleDropConsumer(turtleTile, turtle));
            boolean attacked = false;
            if (!hitEntity.method_5698((class_1297)turtlePlayer) && (damage = (float)turtlePlayer.method_26825(class_5134.field_23721) * this.damageMulitiplier) > 0.0f) {
                class_1282 source = class_1282.method_5532((class_1657)turtlePlayer);
                if (hitEntity instanceof class_1531) {
                    hitEntity.method_5643(source, damage);
                    if (hitEntity.method_5805()) {
                        hitEntity.method_5643(source, damage);
                    }
                    attacked = true;
                } else if (hitEntity.method_5643(source, damage)) {
                    attacked = true;
                }
            }
            TurtleTool.stopConsuming(turtleTile, turtle);
            if (attacked) {
                turtlePlayer.method_31548().method_5448();
                return TurtleCommandResult.success();
            }
        }
        return TurtleCommandResult.failure("Nothing to attack here");
    }

    private TurtleCommandResult dig(ITurtleAccess turtle, class_2350 direction) {
        TurtleCommandResult breakable;
        TileTurtle turtleTile;
        if ((this.item.method_7909() == class_1802.field_8250 || this.item.method_7909() == class_1802.field_8527) && TurtlePlaceCommand.deployCopiedItem(this.item.method_7972(), turtle, direction, null, null)) {
            return TurtleCommandResult.success();
        }
        class_1937 world = turtle.getLevel();
        class_2338 turtlePosition = turtle.getPosition();
        TileTurtle tileTurtle = turtleTile = turtle instanceof TurtleBrain ? ((TurtleBrain)turtle).getOwner() : world.method_8321(turtlePosition);
        if (turtleTile == null) {
            return TurtleCommandResult.failure("Turtle has vanished from existence.");
        }
        class_2338 blockPosition = turtlePosition.method_10093(direction);
        if (world.method_22347(blockPosition) || WorldUtil.isLiquidBlock(world, blockPosition)) {
            return TurtleCommandResult.failure("Nothing to dig here");
        }
        class_2680 state = world.method_8320(blockPosition);
        class_3610 fluidState = world.method_8316(blockPosition);
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, turtlePosition, direction);
        turtlePlayer.loadInventory(this.item.method_7972());
        if (ComputerCraft.turtlesObeyBlockProtection) {
            if (!((PlayerBlockBreakEvents.Before)PlayerBlockBreakEvents.BEFORE.invoker()).beforeBlockBreak(world, (class_1657)turtlePlayer, blockPosition, state, null)) {
                return TurtleCommandResult.failure("Cannot break protected block");
            }
            if (!TurtlePermissions.isBlockEditable(world, blockPosition, (class_1657)turtlePlayer)) {
                return TurtleCommandResult.failure("Cannot break protected block");
            }
        }
        if (!(breakable = this.checkBlockBreakable(state, world, blockPosition, turtlePlayer)).isSuccess()) {
            return breakable;
        }
        DropConsumer.set(world, blockPosition, TurtleTool.turtleDropConsumer(turtleTile, turtle));
        class_2586 tile = world.method_8321(blockPosition);
        world.method_20290(2001, blockPosition, class_2248.method_9507((class_2680)state));
        boolean canHarvest = turtlePlayer.method_7305(state);
        state.method_26204().method_9576(world, blockPosition, state, (class_1657)turtlePlayer);
        boolean canBreak = world.method_8652(blockPosition, fluidState.method_15759(), 11);
        if (canBreak) {
            state.method_26204().method_9585((class_1936)world, blockPosition, state);
        }
        if (canHarvest && canBreak) {
            state.method_26204().method_9556(world, (class_1657)turtlePlayer, blockPosition, state, tile, turtlePlayer.method_6047());
        }
        TurtleTool.stopConsuming(turtleTile, turtle);
        return TurtleCommandResult.success();
    }

    private static Function<class_1799, class_1799> turtleDropConsumer(class_2586 tile, ITurtleAccess turtle) {
        return drop -> tile.method_11015() ? drop : InventoryUtil.storeItems(drop, turtle.getItemHandler(), turtle.getSelectedSlot());
    }

    private static void stopConsuming(class_2586 tile, ITurtleAccess turtle) {
        class_2350 direction = tile.method_11015() ? null : turtle.getDirection().method_10153();
        DropConsumer.clearAndDrop(turtle.getLevel(), turtle.getPosition(), direction);
    }

    protected boolean isTriviallyBreakable(class_1922 reader, class_2338 pos, class_2680 state) {
        return state.method_26164(ComputerCraftTags.Blocks.TURTLE_ALWAYS_BREAKABLE) || state.method_26214(reader, pos) == 0.0f;
    }

    private static class Transforms {
        static final class_4590 leftTransform = Transforms.getMatrixFor(-0.40625f);
        static final class_4590 rightTransform = Transforms.getMatrixFor(0.40625f);

        private Transforms() {
        }

        private static class_4590 getMatrixFor(float offset) {
            class_1159 matrix = new class_1159();
            ((IMatrix4f)matrix).setFloatArray(new float[]{0.0f, 0.0f, -1.0f, 1.0f + offset, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f});
            return new class_4590(matrix);
        }
    }
}

