/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.turtle.upgrades.TurtleInventoryCrafting;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;

public class TurtleCraftCommand
implements ITurtleCommand {
    private final int limit;

    public TurtleCraftCommand(int limit) {
        this.limit = limit;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        TurtleInventoryCrafting crafting = new TurtleInventoryCrafting(turtle);
        List<class_1799> results = crafting.doCrafting(turtle.getLevel(), this.limit);
        if (results == null) {
            return TurtleCommandResult.failure("No matching recipes");
        }
        for (class_1799 stack : results) {
            class_1799 remainder = InventoryUtil.storeItems(stack, turtle.getItemHandler(), turtle.getSelectedSlot());
            if (remainder.method_7960()) continue;
            WorldUtil.dropItemStack(remainder, turtle.getLevel(), turtle.getPosition(), turtle.getDirection());
        }
        if (!results.isEmpty()) {
            turtle.playAnimation(TurtleAnimation.WAIT);
        }
        return TurtleCommandResult.success();
    }
}

