/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.proxy;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.peripheral.IPeripheralTile;
import dan200.computercraft.api.turtle.event.TurtleEvent;
import dan200.computercraft.core.apis.http.NetworkUtils;
import dan200.computercraft.core.computer.MainThread;
import dan200.computercraft.core.filesystem.ResourceMount;
import dan200.computercraft.core.tracking.ComputerMBean;
import dan200.computercraft.core.tracking.Tracking;
import dan200.computercraft.shared.TurtlePermissions;
import dan200.computercraft.shared.command.CommandComputerCraft;
import dan200.computercraft.shared.command.arguments.ArgumentSerializers;
import dan200.computercraft.shared.common.DefaultBundledRedstoneProvider;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.data.BlockNamedEntityLootCondition;
import dan200.computercraft.shared.data.HasComputerIdLootCondition;
import dan200.computercraft.shared.data.PlayerCreativeLootCondition;
import dan200.computercraft.shared.media.items.RecordMedia;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.client.TerminalDimensionsClientMessage;
import dan200.computercraft.shared.peripheral.commandblock.CommandBlockPeripheral;
import dan200.computercraft.shared.peripheral.generic.methods.InventoryMethods;
import dan200.computercraft.shared.peripheral.modem.wired.BlockCable;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessNetwork;
import dan200.computercraft.shared.peripheral.monitor.MonitorWatcher;
import dan200.computercraft.shared.turtle.FurnaceRefuelHandler;
import dan200.computercraft.shared.util.Config;
import dan200.computercraft.shared.util.TickScheduler;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerBlockEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1813;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2593;
import net.minecraft.class_2960;
import net.minecraft.class_3176;
import net.minecraft.class_3264;
import net.minecraft.class_5342;

public final class ComputerCraftProxyCommon {
    public static void init() {
        NetworkHandler.setup();
        MonitorWatcher.init();
        ComputerCraftProxyCommon.registerProviders();
        ComputerCraftProxyCommon.registerHandlers();
        ArgumentSerializers.register();
        ComputerCraftAPI.registerGenericSource(new InventoryMethods());
    }

    private static void registerProviders() {
        ComputerCraftAPI.registerPeripheralProvider((world, pos, side) -> {
            class_2586 tile = world.method_8321(pos);
            return tile instanceof IPeripheralTile ? ((IPeripheralTile)tile).getPeripheral(side) : null;
        });
        ComputerCraftAPI.registerPeripheralProvider((world, pos, side) -> {
            class_2586 tile = world.method_8321(pos);
            return ComputerCraft.enableCommandBlock && tile instanceof class_2593 ? new CommandBlockPeripheral((class_2593)tile) : null;
        });
        ComputerCraftAPI.registerBundledRedstoneProvider(new DefaultBundledRedstoneProvider());
        ComputerCraftAPI.registerMediaProvider(stack -> {
            class_1792 item = stack.method_7909();
            if (item instanceof IMedia) {
                return (IMedia)item;
            }
            if (item instanceof class_1813) {
                return RecordMedia.INSTANCE;
            }
            return null;
        });
    }

    private static void registerHandlers() {
        CommandRegistrationCallback.EVENT.register(CommandComputerCraft::register);
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            MainThread.executePendingTasks();
            ComputerCraft.serverComputerRegistry.update();
            TickScheduler.tick();
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            if (server instanceof class_3176) {
                class_3176 dediServer = (class_3176)server;
                if (dediServer.method_16705().field_24056) {
                    ComputerMBean.register();
                }
            }
            ComputerCraftProxyCommon.resetState();
            ComputerMBean.registerTracker();
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            ComputerCraft.serverComputerRegistry.reset();
            ComputerCraftProxyCommon.resetState();
        });
        ServerBlockEntityEvents.BLOCK_ENTITY_UNLOAD.register((blockEntity, world) -> {
            if (blockEntity instanceof TileGeneric) {
                ((TileGeneric)blockEntity).onChunkUnloaded();
            }
        });
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            class_2248 patt5765$temp = state.method_26204();
            if (patt5765$temp instanceof BlockCable) {
                BlockCable blockCable = (BlockCable)patt5765$temp;
                return blockCable.removedByPlayer(state, world, pos, player, false, null);
            }
            return true;
        });
        ServerLifecycleEvents.SERVER_STARTING.register(Config::serverStarting);
        ServerLifecycleEvents.SERVER_STOPPING.register(Config::serverStopping);
        ServerPlayConnectionEvents.JOIN.register((listener, sender, server) -> NetworkHandler.sendToPlayer((class_1657)listener.field_14140, new TerminalDimensionsClientMessage()));
        TurtleEvent.EVENT_BUS.register((Object)FurnaceRefuelHandler.INSTANCE);
        TurtleEvent.EVENT_BUS.register((Object)new TurtlePermissions());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(ResourceMount.RELOAD_LISTENER);
    }

    private static void resetState() {
        ComputerCraft.serverComputerRegistry.reset();
        MainThread.reset();
        WirelessNetwork.resetNetworks();
        Tracking.reset();
        NetworkUtils.reset();
    }

    public static void registerLoot() {
        ComputerCraftProxyCommon.registerCondition("block_named", BlockNamedEntityLootCondition.TYPE);
        ComputerCraftProxyCommon.registerCondition("player_creative", PlayerCreativeLootCondition.TYPE);
        ComputerCraftProxyCommon.registerCondition("has_id", HasComputerIdLootCondition.TYPE);
    }

    private static void registerCondition(String name, class_5342 serializer) {
        class_2378.method_10230((class_2378)class_2378.field_25299, (class_2960)new class_2960("computercraft", name), (Object)serializer);
    }
}

