/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic.methods;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.GenericPeripheral;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.PeripheralType;
import dan200.computercraft.shared.peripheral.generic.data.ItemData;
import dan200.computercraft.shared.peripheral.generic.methods.ArgumentHelpers;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.ItemStorage;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

public class InventoryMethods
implements GenericPeripheral {
    @Override
    @Nonnull
    public PeripheralType getType() {
        return PeripheralType.ofAdditional("inventory");
    }

    @Override
    @Nonnull
    public class_2960 id() {
        return new class_2960("computercraft", "inventory");
    }

    @LuaFunction(mainThread=true)
    public static int size(class_1263 inventory) {
        return InventoryMethods.extractHandler(inventory).size();
    }

    @LuaFunction(mainThread=true)
    public static Map<Integer, Map<String, ?>> list(class_1263 inventory) {
        ItemStorage itemStorage = InventoryMethods.extractHandler(inventory);
        HashMap result = new HashMap();
        int size = itemStorage.size();
        for (int i = 0; i < size; ++i) {
            class_1799 stack = itemStorage.getStack(i);
            if (stack.method_7960()) continue;
            result.put(i + 1, ItemData.fillBasic(new HashMap(4), stack));
        }
        return result;
    }

    @Nullable
    @LuaFunction(mainThread=true)
    public static Map<String, ?> getItemDetail(class_1263 inventory, int slot) throws LuaException {
        ItemStorage itemStorage = InventoryMethods.extractHandler(inventory);
        ArgumentHelpers.assertBetween(slot, 1, itemStorage.size(), "Slot out of range (%s)");
        class_1799 stack = itemStorage.getStack(slot - 1);
        return stack.method_7960() ? null : ItemData.fill(new HashMap(), stack);
    }

    @LuaFunction(mainThread=true)
    public static int getItemLimit(class_1263 inventory, int slot) throws LuaException {
        ItemStorage itemStorage = InventoryMethods.extractHandler(inventory);
        ArgumentHelpers.assertBetween(slot, 1, itemStorage.size(), "Slot out of range (%s)");
        return inventory.method_5444();
    }

    @LuaFunction(mainThread=true)
    public static int pushItems(class_1263 from, IComputerAccess computer, String toName, int fromSlot, Optional<Integer> limit, Optional<Integer> toSlot) throws LuaException {
        ItemStorage fromStorage = InventoryMethods.extractHandler(from);
        IPeripheral location = computer.getAvailablePeripheral(toName);
        if (location == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        ItemStorage toStorage = InventoryMethods.extractHandler(location.getTarget());
        if (toStorage == null) {
            throw new LuaException("Target '" + toName + "' is not an inventory");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        ArgumentHelpers.assertBetween(fromSlot, 1, fromStorage.size(), "From slot out of range (%s)");
        if (toSlot.isPresent()) {
            ArgumentHelpers.assertBetween(toSlot.get(), 1, toStorage.size(), "To slot out of range (%s)");
        }
        if (actualLimit <= 0) {
            return 0;
        }
        return InventoryMethods.moveItem(fromStorage, fromSlot - 1, toStorage, toSlot.orElse(0) - 1, actualLimit);
    }

    @LuaFunction(mainThread=true)
    public static int pullItems(class_1263 to, IComputerAccess computer, String fromName, int fromSlot, Optional<Integer> limit, Optional<Integer> toSlot) throws LuaException {
        ItemStorage toStorage = InventoryMethods.extractHandler(to);
        IPeripheral location = computer.getAvailablePeripheral(fromName);
        if (location == null) {
            throw new LuaException("Source '" + fromName + "' does not exist");
        }
        ItemStorage fromStorage = InventoryMethods.extractHandler(location.getTarget());
        if (fromStorage == null) {
            throw new LuaException("Source '" + fromName + "' is not an inventory");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        ArgumentHelpers.assertBetween(fromSlot, 1, fromStorage.size(), "From slot out of range (%s)");
        if (toSlot.isPresent()) {
            ArgumentHelpers.assertBetween(toSlot.get(), 1, toStorage.size(), "To slot out of range (%s)");
        }
        if (actualLimit <= 0) {
            return 0;
        }
        return InventoryMethods.moveItem(fromStorage, fromSlot - 1, toStorage, toSlot.orElse(0) - 1, actualLimit);
    }

    @Nullable
    private static ItemStorage extractHandler(@Nullable Object object) {
        class_2586 blockEntity;
        if (object instanceof class_2586 && (blockEntity = (class_2586)object).method_11015()) {
            return null;
        }
        if (object instanceof class_2586) {
            blockEntity = (class_2586)object;
            class_1263 inventory = InventoryUtil.getInventory(blockEntity);
            if (inventory != null) {
                return ItemStorage.wrap(inventory);
            }
        } else if (object instanceof class_1263) {
            class_1263 container = (class_1263)object;
            return ItemStorage.wrap(container);
        }
        return null;
    }

    private static int moveItem(ItemStorage from, int fromSlot, ItemStorage to, int toSlot, int limit) {
        if (limit == 0) {
            return 0;
        }
        class_1799 stack = InventoryUtil.takeItems(limit, from, fromSlot, 1, fromSlot);
        if (stack.method_7960()) {
            return 0;
        }
        int stackCount = stack.method_7947();
        class_1799 remainder = toSlot < 0 ? InventoryUtil.storeItems(stack, to) : InventoryUtil.storeItems(stack, to, toSlot, 1, toSlot);
        int count = stackCount - remainder.method_7947();
        if (!remainder.method_7960()) {
            InventoryUtil.storeItems(remainder, from, fromSlot, 1, fromSlot);
        }
        return count;
    }
}

