/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.client.sound.SpeakerManager;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.PacketContext;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPosition;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;

public class SpeakerAudioClientMessage
implements NetworkMessage {
    private final UUID source;
    private final SpeakerPosition.Message pos;
    private final ByteBuffer content;
    private final float volume;

    public SpeakerAudioClientMessage(UUID source, SpeakerPosition pos, float volume, ByteBuffer content) {
        this.source = source;
        this.pos = pos.asMessage();
        this.content = content;
        this.volume = volume;
    }

    public SpeakerAudioClientMessage(class_2540 buf) {
        this.source = buf.method_10790();
        this.pos = SpeakerPosition.Message.read(buf);
        this.volume = buf.readFloat();
        SpeakerManager.getSound(this.source).pushAudio((ByteBuf)buf);
        this.content = null;
    }

    @Override
    public void toBytes(@Nonnull class_2540 buf) {
        buf.method_10797(this.source);
        this.pos.write(buf);
        buf.writeFloat(this.volume);
        buf.writeBytes(this.content.duplicate());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void handle(PacketContext context) {
        SpeakerManager.getSound(this.source).playAudio(this.pos.reify(), this.volume);
    }
}

