/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import dan200.computercraft.shared.peripheral.monitor.MonitorRenderer;
import dan200.computercraft.shared.util.Config;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2585;

@Environment(value=EnvType.CLIENT)
public class ModMenuIntegration
implements ModMenuApi {
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> {
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)new class_2585("Computer Craft")).setSavingRunnable(() -> {
                Config.clientSpec.correct((com.electronwill.nightconfig.core.Config)Config.clientConfig);
                Config.sync();
                Config.save();
            });
            ConfigCategory client = builder.getOrCreateCategory((class_2561)new class_2585("Client"));
            ConfigEntryBuilder entryBuilder = builder.entryBuilder();
            client.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((class_2561)new class_2585("Monitor Renderer"), MonitorRenderer.class, (Enum)((MonitorRenderer)Config.clientConfig.getEnum("monitor_renderer", MonitorRenderer.class))).setDefaultValue((Enum)MonitorRenderer.BEST).setSaveConsumer(renderer -> Config.clientConfig.set("monitor_renderer", (Object)renderer)).setTooltip(new class_2561[]{class_2561.method_30163((String)ModMenuIntegration.rewrapComment(Config.clientConfig.getComment("monitor_renderer")))}).build());
            return builder.build();
        };
    }

    private static String rewrapComment(String comment) {
        String[] words = comment.strip().replaceAll("[\r\n]", "").split(" ");
        StringBuilder builder = new StringBuilder();
        int lineLength = 0;
        for (String word : words) {
            int wordLength = word.length();
            if (lineLength + wordLength + 1 > 50) {
                builder.append("\n");
                lineLength = 0;
                builder.append(word);
                lineLength += wordLength;
                continue;
            }
            if (builder.length() == 0) {
                builder.append(word);
                lineLength += wordLength;
                continue;
            }
            builder.append(" ");
            builder.append(word);
            lineLength += wordLength + 1;
        }
        return new String(builder);
    }
}

