/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralTile;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.BundledRedstone;
import dan200.computercraft.shared.Peripherals;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.computer.blocks.ComputerPeripheral;
import dan200.computercraft.shared.computer.blocks.ComputerProxy;
import dan200.computercraft.shared.computer.blocks.IComputerTile;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.RedstoneUtil;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1273;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3965;

public abstract class TileComputerBase
extends TileGeneric
implements IComputerTile,
IPeripheralTile,
class_1275,
ExtendedScreenHandlerFactory {
    private static final String NBT_ID = "ComputerId";
    private static final String NBT_LABEL = "Label";
    private static final String NBT_ON = "On";
    private int instanceID = -1;
    private int computerID = -1;
    protected String label = null;
    private boolean on = false;
    boolean startOn = false;
    private boolean fresh = false;
    private int invalidSides = 0;
    private class_1273 lockCode = class_1273.field_5817;
    private final ComputerFamily family;
    private ComputerProxy proxy;

    public TileComputerBase(class_2591<? extends TileGeneric> type, class_2338 pos, class_2680 state, ComputerFamily family) {
        super(type, pos, state);
        this.family = family;
    }

    protected void unload() {
        if (this.instanceID >= 0) {
            if (!this.method_10997().field_9236) {
                ComputerCraft.serverComputerRegistry.remove(this.instanceID);
            }
            this.instanceID = -1;
        }
    }

    @Override
    public void destroy() {
        this.unload();
        for (class_2350 dir : DirectionUtil.FACINGS) {
            RedstoneUtil.propagateRedstoneOutput(this.method_10997(), this.method_11016(), dir);
        }
    }

    @Override
    public void onChunkUnloaded() {
        this.unload();
    }

    public void method_11012() {
        this.unload();
        super.method_11012();
    }

    protected boolean canNameWithTag(class_1657 player) {
        return false;
    }

    @Override
    public boolean isUsable(class_1657 player) {
        return super.isUsable(player) && class_2624.method_17487((class_1657)player, (class_1273)this.lockCode, (class_2561)this.method_5476());
    }

    @Override
    @Nonnull
    public class_1269 onActivate(class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 currentItem = player.method_5998(hand);
        if (!currentItem.method_7960() && currentItem.method_7909() == class_1802.field_8448 && this.canNameWithTag(player) && currentItem.method_7938()) {
            if (!this.method_10997().field_9236) {
                this.setLabel(currentItem.method_7964().getString());
                currentItem.method_7934(1);
            }
            return class_1269.field_5812;
        }
        if (!player.method_18276()) {
            if (!this.method_10997().field_9236 && this.isUsable(player)) {
                this.createServerComputer().turnOn();
                this.createServerComputer().sendTerminalState(player);
                new ComputerContainerData(this.createServerComputer()).open(player, (class_3908)this);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Override
    public void onNeighbourChange(@Nonnull class_2338 neighbour) {
        this.updateInputAt(neighbour);
    }

    @Override
    public void onNeighbourTileEntityChange(@Nonnull class_2338 neighbour) {
        this.updateInputAt(neighbour);
    }

    protected void serverTick() {
        ServerComputer computer = this.createServerComputer();
        if (this.invalidSides != 0) {
            for (class_2350 direction : DirectionUtil.FACINGS) {
                if ((this.invalidSides & 1 << direction.ordinal()) == 0) continue;
                this.refreshPeripheral(computer, direction);
            }
        }
        if (this.startOn || this.fresh && this.on) {
            computer.turnOn();
            this.startOn = false;
        }
        computer.keepAlive();
        this.fresh = false;
        this.computerID = computer.getID();
        this.label = computer.getLabel();
        this.on = computer.isOn();
        this.updateBlockState(computer.getState());
        if (computer.hasOutputChanged()) {
            this.updateOutput();
        }
    }

    protected abstract void updateBlockState(ComputerState var1);

    public void method_11007(@Nonnull class_2487 nbt) {
        if (this.computerID >= 0) {
            nbt.method_10569(NBT_ID, this.computerID);
        }
        if (this.label != null) {
            nbt.method_10582(NBT_LABEL, this.label);
        }
        nbt.method_10556(NBT_ON, this.on);
        this.lockCode.method_5474(nbt);
        super.method_11007(nbt);
    }

    public void method_11014(@Nonnull class_2487 nbt) {
        super.method_11014(nbt);
        this.computerID = nbt.method_10545(NBT_ID) ? nbt.method_10550(NBT_ID) : -1;
        this.label = nbt.method_10545(NBT_LABEL) ? nbt.method_10558(NBT_LABEL) : null;
        this.on = this.startOn = nbt.method_10577(NBT_ON);
        this.lockCode = class_1273.method_5473((class_2487)nbt);
    }

    protected boolean isPeripheralBlockedOnSide(ComputerSide localSide) {
        return false;
    }

    protected abstract class_2350 getDirection();

    protected ComputerSide remapToLocalSide(class_2350 globalSide) {
        return this.remapLocalSide(DirectionUtil.toLocal(this.getDirection(), globalSide));
    }

    protected ComputerSide remapLocalSide(ComputerSide localSide) {
        return localSide;
    }

    private void updateRedstoneInput(@Nonnull ServerComputer computer, class_2350 dir, class_2338 targetPos) {
        class_2350 offsetSide = dir.method_10153();
        ComputerSide localDir = this.remapToLocalSide(dir);
        computer.setRedstoneInput(localDir, RedstoneUtil.getRedstoneInput(this.field_11863, targetPos, dir));
        computer.setBundledRedstoneInput(localDir, BundledRedstone.getOutput(this.method_10997(), targetPos, offsetSide));
    }

    private void refreshPeripheral(@Nonnull ServerComputer computer, class_2350 dir) {
        this.invalidSides &= ~(1 << dir.ordinal());
        ComputerSide localDir = this.remapToLocalSide(dir);
        if (this.isPeripheralBlockedOnSide(localDir)) {
            return;
        }
        class_2350 offsetSide = dir.method_10153();
        IPeripheral peripheral = Peripherals.getPeripheral(this.method_10997(), this.method_11016().method_10093(dir), offsetSide);
        computer.setPeripheral(localDir, peripheral);
    }

    public void updateInputsImmediately() {
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            this.updateInputsImmediately(computer);
        }
    }

    private void updateInputsImmediately(@Nonnull ServerComputer computer) {
        class_2338 pos = this.method_11016();
        for (class_2350 dir : DirectionUtil.FACINGS) {
            this.updateRedstoneInput(computer, dir, pos.method_10093(dir));
            this.refreshPeripheral(computer, dir);
        }
    }

    private void updateInputAt(@Nonnull class_2338 neighbour) {
        ServerComputer computer = this.getServerComputer();
        if (computer == null) {
            return;
        }
        for (class_2350 dir : DirectionUtil.FACINGS) {
            class_2338 offset = this.method_11016().method_10093(dir);
            if (!offset.equals((Object)neighbour)) continue;
            this.updateRedstoneInput(computer, dir, offset);
            this.invalidSides |= 1 << dir.ordinal();
            return;
        }
        class_2338 pos = this.method_11016();
        for (class_2350 dir : DirectionUtil.FACINGS) {
            this.updateRedstoneInput(computer, dir, pos.method_10093(dir));
        }
        this.invalidSides = 63;
    }

    public void updateOutput() {
        this.updateBlock();
        for (class_2350 dir : DirectionUtil.FACINGS) {
            RedstoneUtil.propagateRedstoneOutput(this.method_10997(), this.method_11016(), dir);
        }
    }

    protected abstract ServerComputer createComputer(int var1, int var2);

    @Override
    public final int getComputerID() {
        return this.computerID;
    }

    @Override
    public final String getLabel() {
        return this.label;
    }

    @Override
    public final void setComputerID(int id) {
        if (this.method_10997().field_9236 || this.computerID == id) {
            return;
        }
        this.computerID = id;
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            computer.setID(this.computerID);
        }
        this.method_5431();
    }

    @Override
    public final void setLabel(String label) {
        if (this.method_10997().field_9236 || Objects.equals(this.label, label)) {
            return;
        }
        this.label = label;
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            computer.setLabel(label);
        }
        this.method_5431();
    }

    @Override
    public ComputerFamily getFamily() {
        return this.family;
    }

    @Nonnull
    public ServerComputer createServerComputer() {
        ServerComputer computer;
        if (this.method_10997().field_9236) {
            throw new IllegalStateException("Cannot access server computer on the client.");
        }
        boolean changed = false;
        if (this.instanceID < 0) {
            this.instanceID = ComputerCraft.serverComputerRegistry.getUnusedInstanceID();
            changed = true;
        }
        if ((computer = (ServerComputer)ComputerCraft.serverComputerRegistry.get(this.instanceID)) == null) {
            computer = this.createComputer(this.instanceID, this.computerID);
            ComputerCraft.serverComputerRegistry.add(this.instanceID, computer);
            this.fresh = true;
            changed = true;
        }
        if (changed) {
            this.updateInputsImmediately(computer);
        }
        return computer;
    }

    @Nullable
    public ServerComputer getServerComputer() {
        return this.method_10997().field_9236 ? null : (ServerComputer)ComputerCraft.serverComputerRegistry.get(this.instanceID);
    }

    @Nonnull
    public final class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @Nonnull
    public class_2487 method_16887() {
        class_2487 nbt = super.method_16887();
        if (this.label != null) {
            nbt.method_10582(NBT_LABEL, this.label);
        }
        if (this.computerID >= 0) {
            nbt.method_10569(NBT_ID, this.computerID);
        }
        return nbt;
    }

    protected void transferStateFrom(TileComputerBase copy) {
        if (copy.computerID != this.computerID || copy.instanceID != this.instanceID) {
            this.unload();
            this.instanceID = copy.instanceID;
            this.computerID = copy.computerID;
            this.label = copy.label;
            this.on = copy.on;
            this.startOn = copy.startOn;
            this.updateBlock();
        }
        copy.instanceID = -1;
    }

    @Override
    @Nonnull
    public IPeripheral getPeripheral(class_2350 side) {
        if (this.proxy == null) {
            this.proxy = new ComputerProxy(() -> this);
        }
        return new ComputerPeripheral(this.getPeripheralName(), this.proxy);
    }

    @Nonnull
    protected String getPeripheralName() {
        return "computer";
    }

    @Nonnull
    public class_2561 method_5477() {
        return this.method_16914() ? new class_2585(this.label) : new class_2588(this.method_11010().method_26204().method_9539());
    }

    public boolean method_16914() {
        return !Strings.isNullOrEmpty((String)this.label);
    }

    @Nullable
    public class_2561 method_5797() {
        return this.method_16914() ? new class_2585(this.label) : null;
    }

    @Nonnull
    public class_2561 method_5476() {
        return super.method_5476();
    }

    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        packetByteBuf.writeInt(this.getServerComputer().getInstanceID());
        packetByteBuf.method_10817((Enum)this.getServerComputer().getFamily());
    }
}

