/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.FrameInfo;
import dan200.computercraft.client.render.MonitorTextureBufferShader;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.text.DirectFixedWidthFontRenderer;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.client.util.DirectBuffers;
import dan200.computercraft.client.util.DirectVertexBuffer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.integration.IrisCompat;
import dan200.computercraft.shared.peripheral.monitor.ClientMonitor;
import dan200.computercraft.shared.peripheral.monitor.MonitorRenderer;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import dan200.computercraft.shared.util.DirectionUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_311;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.lwjgl.opengl.GL11;

public class TileEntityMonitorRenderer
implements class_827<TileMonitor> {
    private static final float MARGIN = 0.034375f;
    private static ByteBuffer backingBuffer;
    private static final class_4581 IDENTITY;

    public TileEntityMonitorRenderer(class_5614.class_5615 context) {
    }

    public void render(@Nonnull TileMonitor monitor, float partialTicks, @Nonnull class_4587 transform, @Nonnull class_4597 bufferSource, int lightmapCoord, int overlayLight) {
        ClientMonitor originTerminal = monitor.getClientMonitor();
        if (originTerminal == null) {
            return;
        }
        TileMonitor origin = originTerminal.getOrigin();
        class_2338 monitorPos = monitor.method_11016();
        long renderFrame = FrameInfo.getRenderFrame();
        if (originTerminal.lastRenderFrame == renderFrame && !monitorPos.equals((Object)originTerminal.lastRenderPos)) {
            return;
        }
        originTerminal.lastRenderFrame = renderFrame;
        originTerminal.lastRenderPos = monitorPos;
        class_2338 originPos = origin.method_11016();
        class_2350 dir = origin.getDirection();
        class_2350 front = origin.getFront();
        float yaw = dir.method_10144();
        float pitch = DirectionUtil.toPitchAngle(front);
        transform.method_22903();
        transform.method_22904((double)(originPos.method_10263() - monitorPos.method_10263()) + 0.5, (double)(originPos.method_10264() - monitorPos.method_10264()) + 0.5, (double)(originPos.method_10260() - monitorPos.method_10260()) + 0.5);
        transform.method_22907(class_1160.field_20704.method_23214(yaw));
        transform.method_22907(class_1160.field_20703.method_23214(pitch));
        transform.method_22904(-0.34375, (double)origin.getHeight() - 0.5 - 0.15625 + 0.0, 0.5);
        double xSize = (double)origin.getWidth() - 0.3125;
        double ySize = (double)origin.getHeight() - 0.3125;
        Terminal terminal = originTerminal.getTerminal();
        if (terminal != null && !IrisCompat.INSTANCE.isRenderingShadowPass()) {
            int width = terminal.getWidth();
            int height = terminal.getHeight();
            int pixelWidth = width * 6;
            int pixelHeight = height * 9;
            double xScale = xSize / (double)pixelWidth;
            double yScale = ySize / (double)pixelHeight;
            transform.method_22903();
            transform.method_23760().method_23761().method_22672(class_1159.method_24019((float)((float)xScale), (float)((float)(-yScale)), (float)1.0f));
            TileEntityMonitorRenderer.renderTerminal(bufferSource, transform, originTerminal, (float)((double)0.034375f / xScale), (float)((double)0.034375f / yScale));
            transform.method_22909();
        } else {
            FixedWidthFontRenderer.drawEmptyTerminal(FixedWidthFontRenderer.toVertexConsumer(transform, bufferSource.getBuffer(RenderTypes.MONITOR)), -0.034375f, 0.034375f, (float)(xSize + (double)0.06875f), (float)(-(ySize + (double)0.06875f)));
        }
        transform.method_22909();
    }

    private static void renderTerminal(@Nonnull class_4597 bufferSource, class_4587 transform, ClientMonitor monitor, float xMargin, float yMargin) {
        Terminal terminal = monitor.getTerminal();
        int width = terminal.getWidth();
        int height = terminal.getHeight();
        int pixelWidth = width * 6;
        int pixelHeight = height * 9;
        MonitorRenderer renderType = MonitorRenderer.current();
        boolean redraw = monitor.pollTerminalChanged();
        if (monitor.createBuffer(renderType)) {
            redraw = true;
        }
        switch (renderType) {
            case TBO: {
                if (redraw) {
                    ByteBuffer terminalBuffer = TileEntityMonitorRenderer.getBuffer(width * height * 3);
                    MonitorTextureBufferShader.setTerminalData(terminalBuffer, terminal);
                    DirectBuffers.setBufferData(35882, monitor.tboBuffer, terminalBuffer, 35044);
                    ByteBuffer uniformBuffer = TileEntityMonitorRenderer.getBuffer(276);
                    MonitorTextureBufferShader.setUniformData(uniformBuffer, terminal, !monitor.isColour());
                    DirectBuffers.setBufferData(35345, monitor.tboUniform, uniformBuffer, 35044);
                }
                int active = GlStateManager._getActiveTexture();
                RenderSystem.activeTexture((int)33987);
                GL11.glBindTexture((int)35882, (int)monitor.tboTexture);
                RenderSystem.activeTexture((int)active);
                MonitorTextureBufferShader shader = RenderTypes.getMonitorTextureBufferShader();
                shader.setupUniform(monitor.tboUniform);
                class_1159 matrix = transform.method_23760().method_23761();
                class_4588 buffer = bufferSource.getBuffer(RenderTypes.MONITOR_TBO);
                TileEntityMonitorRenderer.tboVertex(buffer, matrix, -xMargin, -yMargin);
                TileEntityMonitorRenderer.tboVertex(buffer, matrix, -xMargin, (float)pixelHeight + yMargin);
                TileEntityMonitorRenderer.tboVertex(buffer, matrix, (float)pixelWidth + xMargin, -yMargin);
                TileEntityMonitorRenderer.tboVertex(buffer, matrix, (float)pixelWidth + xMargin, (float)pixelHeight + yMargin);
                bufferSource.getBuffer(class_1921.method_23577());
                break;
            }
            case VBO: {
                DirectVertexBuffer vbo = monitor.buffer;
                if (redraw) {
                    DirectFixedWidthFontRenderer.QuadSink sink = IrisCompat.INSTANCE.getVertexSink(DirectFixedWidthFontRenderer.getVertexCount(terminal), TileEntityMonitorRenderer::getBuffer);
                    int vertexSize = sink.getFormat().method_1362();
                    ByteBuffer buffer = sink.buffer();
                    DirectFixedWidthFontRenderer.drawTerminalBackground(sink, 0.0f, 0.0f, terminal, !monitor.isColour(), yMargin, yMargin, xMargin, xMargin);
                    monitor.backgroundVertexCount = buffer.position() / vertexSize;
                    DirectFixedWidthFontRenderer.drawTerminalForeground(sink, 0.0f, 0.0f, terminal, !monitor.isColour(), yMargin, yMargin, xMargin, xMargin);
                    monitor.foregroundVertexCount = buffer.position() / vertexSize - monitor.backgroundVertexCount;
                    DirectFixedWidthFontRenderer.drawCursor(sink, 0.0f, 0.0f, terminal, !monitor.isColour());
                    buffer.flip();
                    vbo.upload(buffer.limit() / vertexSize, RenderTypes.MONITOR.method_23033(), sink.getFormat(), buffer);
                }
                class_4581 popViewRotation = RenderSystem.getInverseViewRotationMatrix();
                RenderSystem.setInverseViewRotationMatrix((class_4581)IDENTITY);
                class_1159 matrix = transform.method_23760().method_23761();
                if (MonitorRenderer.canvasModPresent) {
                    class_1159 modelViewMatrix = RenderSystem.getModelViewMatrix().method_22673();
                    modelViewMatrix.method_22672(matrix);
                    matrix = modelViewMatrix;
                }
                RenderTypes.MONITOR.method_23516();
                vbo.begin(matrix, RenderSystem.getProjectionMatrix(), RenderTypes.getMonitorShader());
                vbo.draw(monitor.backgroundVertexCount, 0);
                GL11.glPolygonOffset((float)-1.0f, (float)-10.0f);
                GL11.glEnable((int)32823);
                vbo.draw(FixedWidthFontRenderer.isCursorVisible(terminal) && FrameInfo.getGlobalCursorBlink() ? monitor.foregroundVertexCount + 4 : monitor.foregroundVertexCount, monitor.backgroundVertexCount);
                GL11.glPolygonOffset((float)0.0f, (float)-0.0f);
                GL11.glDisable((int)32823);
                vbo.end();
                RenderTypes.MONITOR.method_23518();
                RenderSystem.setInverseViewRotationMatrix((class_4581)popViewRotation);
                break;
            }
        }
    }

    private static void tboVertex(class_4588 builder, class_1159 matrix, float x, float y) {
        builder.method_22918(matrix, x, y, 0.0f).method_22913(x, y).method_1344();
    }

    @Nonnull
    private static ByteBuffer getBuffer(int capacity) {
        ByteBuffer buffer = backingBuffer;
        if (buffer == null || buffer.capacity() < capacity) {
            backingBuffer = buffer == null ? class_311.method_1596((int)capacity) : class_311.method_37465((ByteBuffer)buffer, (int)capacity);
            buffer = backingBuffer;
        }
        buffer.clear();
        return buffer;
    }

    public int method_33893() {
        return ComputerCraft.monitorDistance;
    }

    static {
        class_4581 identity = new class_4581();
        identity.method_22856();
        IDENTITY = identity;
    }
}

