/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import javax.annotation.Nonnull;
import net.minecraft.class_1159;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;

public class ComputerBorderRenderer {
    public static final class_2960 BACKGROUND_NORMAL = new class_2960("computercraft", "textures/gui/corners_normal.png");
    public static final class_2960 BACKGROUND_ADVANCED = new class_2960("computercraft", "textures/gui/corners_advanced.png");
    public static final class_2960 BACKGROUND_COMMAND = new class_2960("computercraft", "textures/gui/corners_command.png");
    public static final class_2960 BACKGROUND_COLOUR = new class_2960("computercraft", "textures/gui/corners_colour.png");
    private static final class_1159 IDENTITY = new class_1159();
    public static final int MARGIN = 2;
    public static final int BORDER = 12;
    private static final int CORNER_TOP_Y = 28;
    private static final int CORNER_BOTTOM_Y = 40;
    private static final int CORNER_LEFT_X = 12;
    private static final int CORNER_RIGHT_X = 24;
    private static final int BORDER_RIGHT_X = 36;
    private static final int LIGHT_BORDER_Y = 56;
    private static final int LIGHT_CORNER_Y = 80;
    public static final int LIGHT_HEIGHT = 8;
    public static final int TEX_SIZE = 256;
    private static final float TEX_SCALE = 0.00390625f;
    private final class_4587 transform;
    private final class_4588 builder;
    private final int light;
    private final int z;
    private final float r;
    private final float g;
    private final float b;

    public ComputerBorderRenderer(class_4587 transform, class_4588 builder, int z, int light, float r, float g, float b) {
        this.transform = transform;
        this.builder = builder;
        this.z = z;
        this.light = light;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    @Nonnull
    public static class_2960 getTexture(@Nonnull ComputerFamily family) {
        switch (family) {
            default: {
                return BACKGROUND_NORMAL;
            }
            case ADVANCED: {
                return BACKGROUND_ADVANCED;
            }
            case COMMAND: 
        }
        return BACKGROUND_COMMAND;
    }

    public static void renderFromGui(class_2960 location, int x, int y, int z, int light, int width, int height) {
        class_4587 identityStack = new class_4587();
        class_4597.class_4598 renderer = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        ComputerBorderRenderer.render(identityStack, renderer.getBuffer(RenderTypes.guiComputerBorder(location)), x, y, z, light, width, height, false, 1.0f, 1.0f, 1.0f);
        renderer.method_22993();
    }

    public static void render(class_4587 transform, class_4588 buffer, int x, int y, int z, int light, int width, int height, boolean withLight, float r, float g, float b) {
        new ComputerBorderRenderer(transform, buffer, z, light, r, g, b).doRender(x, y, width, height, withLight);
    }

    public void doRender(int x, int y, int width, int height, boolean withLight) {
        int endX = x + width;
        int endY = y + height;
        this.renderLine(x - 12, y, 0, 28, 12, endY - y);
        this.renderLine(endX, y, 36, 28, 12, endY - y);
        this.renderLine(x, y - 12, 0, 0, endX - x, 12);
        this.renderCorner(x - 12, y - 12, 12, 28);
        this.renderCorner(endX, y - 12, 24, 28);
        if (withLight) {
            this.renderTexture(x, endY, 0, 56, endX - x, 20, 12, 20);
            this.renderTexture(x - 12, endY, 12, 80, 12, 20);
            this.renderTexture(endX, endY, 24, 80, 12, 20);
        } else {
            this.renderLine(x, endY, 0, 12, endX - x, 12);
            this.renderCorner(x - 12, endY, 12, 40);
            this.renderCorner(endX, endY, 24, 40);
        }
    }

    private void renderCorner(int x, int y, int u, int v) {
        this.renderTexture(x, y, u, v, 12, 12, 12, 12);
    }

    private void renderLine(int x, int y, int u, int v, int width, int height) {
        this.renderTexture(x, y, u, v, width, height, 12, 12);
    }

    private void renderTexture(int x, int y, int u, int v, int width, int height) {
        this.renderTexture(x, y, u, v, width, height, width, height);
    }

    private void renderTexture(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        class_1159 poseMatrix = this.transform.method_23760().method_23761();
        class_4581 normalMatrix = this.transform.method_23760().method_23762();
        this.builder.method_22918(poseMatrix, (float)x, (float)(y + height), (float)this.z).method_22915(this.r, this.g, this.b, 1.0f).method_22913((float)u * 0.00390625f, (float)(v + textureHeight) * 0.00390625f).method_22922(class_4608.field_21444).method_22916(this.light).method_23763(normalMatrix, 0.0f, 0.0f, 1.0f).method_1344();
        this.builder.method_22918(poseMatrix, (float)(x + width), (float)(y + height), (float)this.z).method_22915(this.r, this.g, this.b, 1.0f).method_22913((float)(u + textureWidth) * 0.00390625f, (float)(v + textureHeight) * 0.00390625f).method_22922(class_4608.field_21444).method_22916(this.light).method_23763(normalMatrix, 0.0f, 0.0f, 1.0f).method_1344();
        this.builder.method_22918(poseMatrix, (float)(x + width), (float)y, (float)this.z).method_22915(this.r, this.g, this.b, 1.0f).method_22913((float)(u + textureWidth) * 0.00390625f, (float)v * 0.00390625f).method_22922(class_4608.field_21444).method_22916(this.light).method_23763(normalMatrix, 0.0f, 0.0f, 1.0f).method_1344();
        this.builder.method_22918(poseMatrix, (float)x, (float)y, (float)this.z).method_22915(this.r, this.g, this.b, 1.0f).method_22913((float)u * 0.00390625f, (float)v * 0.00390625f).method_22922(class_4608.field_21444).method_22916(this.light).method_23763(normalMatrix, 0.0f, 0.0f, 1.0f).method_1344();
    }

    static {
        IDENTITY.method_22668();
    }
}

