/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.effects;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IMcdwEnchantedArrow;
import chronosacaria.mcdw.api.util.AOECloudHelper;
import chronosacaria.mcdw.api.util.AOEHelper;
import chronosacaria.mcdw.api.util.AbilityHelper;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.api.util.InventoryHelper;
import chronosacaria.mcdw.api.util.ProjectileEffectHelper;
import chronosacaria.mcdw.bases.McdwBow;
import chronosacaria.mcdw.damagesource.ElectricShockDamageSource;
import chronosacaria.mcdw.enchants.EnchantsRegistry;
import chronosacaria.mcdw.enchants.goals.WildRageAttackGoal;
import chronosacaria.mcdw.enums.BowsID;
import chronosacaria.mcdw.enums.EnchantStatsID;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.mixin.MobEntityAccessor;
import chronosacaria.mcdw.sounds.McdwSoundEvents;
import chronosacaria.mcdw.statuseffects.StatusEffectsRegistry;
import java.util.LinkedHashMap;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1538;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5134;

public class EnchantmentEffects {
    static final LinkedHashMap<EnchantmentsID, Integer> CONFIG_CHANCE = Mcdw.CONFIG.mcdwEnchantmentSettingsConfig.ENCHANTMENT_TRIGGER_BASE_CHANCE;

    public static int mcdw$getEnchantmentLevel(class_1887 enchantment, class_1309 enchantedEntity, boolean isOffHandStack) {
        if (FabricLoader.getInstance().isModLoaded("bettercombat")) {
            return class_1890.method_8203((class_1887)enchantment, (class_1309)enchantedEntity);
        }
        return class_1890.method_8225((class_1887)enchantment, (class_1799)(isOffHandStack ? enchantedEntity.method_6079() : enchantedEntity.method_6047()));
    }

    public static int soulDevourerExperience(class_1657 playerEntity, int amount) {
        int offHandLevel;
        int mainHandLevel = class_1890.method_8225((class_1887)EnchantsRegistry.SOUL_DEVOURER, (class_1799)playerEntity.method_6047());
        int soulDevourerLevel = mainHandLevel + (offHandLevel = class_1890.method_8225((class_1887)EnchantsRegistry.SOUL_DEVOURER, (class_1799)playerEntity.method_6079()));
        if (soulDevourerLevel > 0) {
            return Math.round((float)amount * (1.0f + (float)soulDevourerLevel / 3.0f));
        }
        return amount;
    }

    public static int animaConduitExperience(class_1657 playerEntity, int amount, boolean isOffHandStack) {
        float missingHealth;
        int animaLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.ANIMA_CONDUIT, (class_1309)playerEntity, isOffHandStack);
        if (animaLevel > 0 && (missingHealth = playerEntity.method_6063() - playerEntity.method_6032()) > 0.0f) {
            float i = Math.min(AbilityHelper.getAnimaRepairAmount(amount, animaLevel), missingHealth);
            playerEntity.method_6025(i);
            return Math.max(amount -= (int)(i * 5.0f), 0);
        }
        return amount;
    }

    public static float huntersPromiseDamage(class_1657 owner, class_3218 serverWorld) {
        UUID petOwnerUUID;
        if (Mcdw.CONFIG.mcdwEnableItemsConfig.BOWS_ENABLED.get(BowsID.BOW_HUNTERS_PROMISE).booleanValue() && owner.method_6047().method_31574((class_1792)BowsID.BOW_HUNTERS_PROMISE.getItem()) && (petOwnerUUID = owner.method_5667()) != null && serverWorld.method_14190(petOwnerUUID) instanceof class_1309) {
            return 0.5f;
        }
        return 0.0f;
    }

    public static void applyProspector(class_1309 prospectingEntity, class_1309 victim, boolean isOffHandStack) {
        int prospectorLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.PROSPECTOR, prospectingEntity, isOffHandStack);
        if (prospectorLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.PROSPECTOR) * prospectorLevel) && victim instanceof class_1569) {
            CleanlinessHelper.mcdw$dropItem(victim, class_1802.field_8687);
        }
    }

    public static void applyRushdown(class_1309 rushingEntity, boolean isOffHandStack) {
        int rushdownLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.RUSHDOWN, rushingEntity, isOffHandStack);
        if (rushdownLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.RUSHDOWN))) {
            class_1293 rushdown = new class_1293(class_1294.field_5904, 100 * rushdownLevel, 2, false, false);
            rushingEntity.method_6092(rushdown);
        }
    }

    public static void applySoulSiphon(class_1657 siphoningEntity, boolean isOffHandStack) {
        int soulLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.SOUL_SIPHON, (class_1309)siphoningEntity, isOffHandStack);
        if (soulLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.SOUL_SIPHON))) {
            siphoningEntity.method_7255(3 * soulLevel);
        }
    }

    public static void applyShadowShotShadowForm(class_1309 shadowShotEntity, class_1665 ppe, int duration) {
        int shadowShotLevel = ((IMcdwEnchantedArrow)ppe).getShadowShotLevel();
        if (shadowShotLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.SHADOW_SHOT))) {
            shadowShotEntity.method_6092(new class_1293(StatusEffectsRegistry.SHADOW_FORM, duration, 0, false, true, true));
        }
    }

    public static float ambushDamage(class_1309 ambushingEntity, class_1309 ambushee, boolean isOffHandStack) {
        int ambushLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.AMBUSH, ambushingEntity, isOffHandStack);
        if (ambushLevel > 0 && ambushingEntity.method_5767() && ambushingEntity.method_5715()) {
            CleanlinessHelper.playCenteredSound(ambushee, class_3417.field_28033, 0.5f, 1.0f);
            return 0.15f * (float)ambushLevel;
        }
        return 0.0f;
    }

    public static float criticalHitDamage(class_1309 crittingEntity, class_1309 target, boolean isOffHandStack) {
        int criticalHitLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.CRITICAL_HIT, crittingEntity, isOffHandStack);
        if (criticalHitLevel > 0 && CleanlinessHelper.percentToOccur(10 + CONFIG_CHANCE.get((Object)EnchantmentsID.CRITICAL_HIT) * criticalHitLevel) && !AbilityHelper.entityCanCrit(crittingEntity)) {
            CleanlinessHelper.playCenteredSound(target, class_3417.field_15016, 0.5f, 1.0f);
            return 0.5f;
        }
        return 0.0f;
    }

    public static float voidStrikeDamage(class_1309 voidEntity, class_1309 target, boolean isOffHandStack) {
        int voidlevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.VOID_STRIKE, voidEntity, isOffHandStack);
        if (voidlevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.VOID_STRIKE) + 5 * voidlevel)) {
            CleanlinessHelper.playCenteredSound(target, class_3417.field_14879, 0.5f, 1.0f);
            return 2.0f * (float)voidlevel - 1.0f;
        }
        return 0.0f;
    }

    public static float painCycleDamage(class_1309 painEntity, boolean isOffHandStack) {
        int painCycleLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.PAIN_CYCLE, painEntity, isOffHandStack);
        if (painCycleLevel > 0) {
            int i;
            class_1293 painCycleInstance = painEntity.method_6112(StatusEffectsRegistry.PAIN_CYCLE);
            int n = i = painCycleInstance != null ? painCycleInstance.method_5578() + 1 : 0;
            if (i < 5) {
                class_1293 painCycleUpdate = new class_1293(StatusEffectsRegistry.PAIN_CYCLE, 120000, i, false, false, true);
                painEntity.method_6016(StatusEffectsRegistry.PAIN_CYCLE);
                painEntity.method_6092(painCycleUpdate);
                painEntity.method_5643(class_1282.field_5846, 1.0f);
            } else {
                painEntity.method_6016(StatusEffectsRegistry.PAIN_CYCLE);
                return painCycleLevel + 1;
            }
        }
        return 0.0f;
    }

    public static float enigmaResonatorDamage(class_1657 resonatingEntity, class_1309 target, boolean isOffHandStack) {
        int numSouls;
        int resonatorLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.ENIGMA_RESONATOR, (class_1309)resonatingEntity, isOffHandStack);
        if (resonatorLevel > 0 && (numSouls = resonatingEntity.field_7520) > 0) {
            CleanlinessHelper.playCenteredSound(target, class_3417.field_23060, 0.5f, 1.0f);
            float extraDamageMultiplier = (float)Math.log(numSouls * resonatorLevel + 20) / Mcdw.CONFIG.mcdwEnchantmentSettingsConfig.ENIGMA_RESONATOR_DIVISOR.get((Object)EnchantStatsID.ENIGMA_RESONATOR_DIVISOR).floatValue();
            return Math.max(extraDamageMultiplier - 1.0f, 0.0f);
        }
        return 0.0f;
    }

    public static float enigmaShotDamage(class_1309 resonatingEntity, class_1309 target, class_1665 ppe) {
        int numSouls;
        if (!(resonatingEntity instanceof class_1657)) {
            return 0.0f;
        }
        class_1657 player = (class_1657)resonatingEntity;
        IMcdwEnchantedArrow enchantedArrow = (IMcdwEnchantedArrow)ppe;
        int resonatorLevel = enchantedArrow.getEnigmaResonatorLevel();
        if (resonatorLevel > 0 && (numSouls = player.field_7520) > 0) {
            CleanlinessHelper.playCenteredSound(target, class_3417.field_23060, 0.5f, 1.0f);
            float getExtraDamage = (float)Math.log(numSouls * resonatorLevel + 20) / Mcdw.CONFIG.mcdwEnchantmentSettingsConfig.ENIGMA_RESONATOR_DIVISOR.get((Object)EnchantStatsID.ENIGMA_RESONATOR_DIVISOR).floatValue();
            return Math.max(getExtraDamage - 1.0f, 0.0f);
        }
        return 0.0f;
    }

    public static float growingDamage(class_1309 growingEntity, class_1309 target, class_1665 ppe) {
        int growingLevel = ((IMcdwEnchantedArrow)ppe).getGrowingLevel();
        if (growingLevel > 0) {
            CleanlinessHelper.playCenteredSound(target, class_3417.field_14879, 0.5f, 1.0f);
            float damageModifier = 0.03f * growingEntity.method_5739((class_1297)target) * (float)growingLevel;
            return class_3532.method_15363((float)damageModifier, (float)0.0f, (float)growingLevel);
        }
        return 0.0f;
    }

    public static float voidShotDamage(class_1309 target, class_1665 ppe) {
        int voidlevel = ((IMcdwEnchantedArrow)ppe).getVoidShotLevel();
        if (voidlevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.VOID_SHOT) + 5 * voidlevel)) {
            CleanlinessHelper.playCenteredSound(target, class_3417.field_14879, 0.5f, 1.0f);
            return voidlevel;
        }
        return 0.0f;
    }

    public static float committedDamage(class_1309 committedEntity, class_1309 target, boolean isOffHandStack) {
        int committedLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.COMMITTED, committedEntity, isOffHandStack);
        if (committedLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.COMMITTED))) {
            CleanlinessHelper.playCenteredSound(target, class_3417.field_15152, 0.5f, 1.0f);
            float getTargetRemainingHealth = class_3532.method_15363((float)(target.method_6032() / target.method_6063()), (float)0.0f, (float)1.0f);
            float attributeDamage = (float)committedEntity.method_26825(class_5134.field_23721);
            float committedMultiplier = 0.2f * (float)committedLevel;
            float getExtraDamage = attributeDamage * (1.0f - getTargetRemainingHealth) * committedMultiplier;
            return Math.max(getExtraDamage, 0.0f);
        }
        return 0.0f;
    }

    public static float dynamoDamage(class_1309 dynamoEntity, boolean isOffHandStack) {
        class_1293 dynamoInstance;
        int dynamoLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.DYNAMO, dynamoEntity, isOffHandStack);
        if (dynamoLevel > 0 && dynamoEntity.method_6059(StatusEffectsRegistry.DYNAMO) && (dynamoInstance = dynamoEntity.method_6112(StatusEffectsRegistry.DYNAMO)) != null) {
            int dynamoAmplifier = dynamoInstance.method_5578() + 1;
            float dynamoLevelModifier = (float)(dynamoLevel - 1) * 0.25f + 1.0f;
            float getDynamoDamage = (float)((double)dynamoLevelModifier * ((double)dynamoAmplifier * 0.1));
            dynamoEntity.method_6016(StatusEffectsRegistry.DYNAMO);
            return Math.max(getDynamoDamage, 0.0f);
        }
        return 0.0f;
    }

    public static float dynamoShotDamage(class_1309 dynamoEntity, class_1665 ppe) {
        class_1293 dynamoInstance;
        int dynamoLevel = ((IMcdwEnchantedArrow)ppe).getDynamoLevel();
        if (dynamoLevel > 0 && dynamoEntity.method_6059(StatusEffectsRegistry.DYNAMO) && (dynamoInstance = dynamoEntity.method_6112(StatusEffectsRegistry.DYNAMO)) != null) {
            int dynamoAmplifier = dynamoInstance.method_5578() + 1;
            float dynamoLevelModifier = (float)(dynamoLevel - 1) * 0.25f + 1.0f;
            float getDynamoDamage = (float)((double)dynamoLevelModifier * ((double)dynamoAmplifier * 0.1));
            dynamoEntity.method_6016(StatusEffectsRegistry.DYNAMO);
            return Math.max(getDynamoDamage, 0.0f);
        }
        return 0.0f;
    }

    public static float shadowFormDamage(class_1309 shadowShotEntity) {
        if (shadowShotEntity.method_6059(StatusEffectsRegistry.SHADOW_FORM)) {
            shadowShotEntity.method_6016(StatusEffectsRegistry.SHADOW_FORM);
            return 7.0f;
        }
        return 0.0f;
    }

    public static float shadowFormShotDamage(class_1309 shadowShotEntity, class_1665 ppe) {
        boolean shadowBarbBoolean = ((IMcdwEnchantedArrow)ppe).getShadowBarbBoolean();
        if (shadowShotEntity.method_6059(StatusEffectsRegistry.SHADOW_FORM)) {
            if (!shadowBarbBoolean) {
                shadowShotEntity.method_6016(StatusEffectsRegistry.SHADOW_FORM);
            }
            return 7.0f;
        }
        return 0.0f;
    }

    public static float overchargeDamage(class_1665 ppe) {
        int overchargeAmount = ((IMcdwEnchantedArrow)ppe).getOvercharge();
        return Math.max(overchargeAmount, 0);
    }

    public static void applyFreezing(class_1309 freezerEntity, class_1309 target, boolean isOffHandStack) {
        int freezingLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.FREEZING, freezerEntity, isOffHandStack);
        if (freezingLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.FREEZING) + 10 * freezingLevel)) {
            AbilityHelper.causeFreezing(target, 100);
        }
    }

    public static void applyPoisoning(class_1309 poisoningEntity, class_1309 target, boolean isOffHandStack) {
        int poisoningLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.JUNGLE_POISON, poisoningEntity, isOffHandStack);
        if (poisoningLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.POISONING))) {
            class_1293 poison = new class_1293(class_1294.field_5899, 60, poisoningLevel - 1);
            target.method_6092(poison);
        }
    }

    public static void applyPoisonCloud(class_1309 poisoningEntity, class_1309 target, boolean isOffHandStack) {
        int poisoningLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.POISON_CLOUD, poisoningEntity, isOffHandStack);
        if (poisoningLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.POISON_CLOUD))) {
            AOECloudHelper.spawnPickyStatusCloud(poisoningEntity, target, class_1294.field_5899, 60, poisoningLevel - 1, true, true, false);
        }
    }

    public static void applyRadianceCloud(class_1309 radiantEntity, boolean isOffHandStack) {
        int radianceLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.RADIANCE, radiantEntity, isOffHandStack);
        if (radianceLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.RADIANCE))) {
            AOECloudHelper.spawnPickyStatusCloud(radiantEntity, radiantEntity, class_1294.field_5924, 100, radianceLevel - 1, false, false, true);
        }
    }

    public static void applyShockwave(class_1309 shockwaveEntity, class_1309 target, float amount, boolean isOffHandStack) {
        int shockwaveLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.SHOCKWAVE, shockwaveEntity, isOffHandStack);
        if (shockwaveLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.SHOCKWAVE) + 15 * shockwaveLevel)) {
            EnchantmentEffects.causeShockwaveAttack(shockwaveEntity, target, 3.0f, amount);
            CleanlinessHelper.playCenteredSound(target, class_3417.field_14956, class_3419.field_15252, 0.5f, 1.0f);
        }
    }

    public static void causeShockwaveAttack(class_1309 user, class_1309 target, float distance, float amount) {
        AOEHelper.getAoeTargets(target, user, distance).stream().filter(nearbyEntity -> nearbyEntity != target).forEach(nearbyEntity -> nearbyEntity.method_5643(class_1282.field_5869, amount * 0.25f));
    }

    public static void causeSmitingAttack(class_1309 user, class_1309 target, float distance, float amount) {
        AOEHelper.getAoeTargets(target, user, distance).stream().filter(nearbyEntity -> nearbyEntity != target && nearbyEntity.method_5999()).forEach(nearbyEntity -> nearbyEntity.method_5643(class_1282.field_5846, amount * 1.25f));
    }

    public static void applyStunning(class_1309 stunningEntity, class_1309 target, boolean isOffHandStack) {
        int stunningLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.STUNNING, stunningEntity, isOffHandStack);
        if (stunningLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.STUNNING) + 15 * stunningLevel)) {
            target.method_6092(new class_1293(class_1294.field_5909, 60, 10));
            target.method_6092(new class_1293(class_1294.field_5916, 60, 1));
        }
    }

    public static void applyThundering(class_1309 thunderingEntity, float amount, boolean isOffHandStack) {
        int thunderingLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.THUNDERING, thunderingEntity, isOffHandStack);
        if (thunderingLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.THUNDERING))) {
            EnchantmentEffects.electrocuteNearbyEnemies(thunderingEntity, 5 * thunderingLevel, amount, Integer.MAX_VALUE);
        }
    }

    public static void createVisualLightningBoltOnEntity(class_1297 target) {
        class_1937 world = target.method_5770();
        class_1538 lightningEntity = (class_1538)class_1299.field_6112.method_5883(world);
        if (lightningEntity != null) {
            lightningEntity.method_24203(target.method_23317(), target.method_23318(), target.method_23321());
            lightningEntity.method_29498(true);
            world.method_8649((class_1297)lightningEntity);
        }
    }

    public static void electrocute(class_1309 attacker, class_1309 victim, float damageAmount) {
        EnchantmentEffects.createVisualLightningBoltOnEntity((class_1297)victim);
        class_1282 electricShockDamageSource = new ElectricShockDamageSource((class_1297)attacker).method_5515();
        victim.method_5643(electricShockDamageSource, damageAmount);
    }

    public static void electrocuteNearbyEnemies(class_1309 user, float distance, float damageAmount, int limit) {
        CleanlinessHelper.playCenteredSound(user, class_3417.field_14865, class_3419.field_15252, 1.0f, 1.0f);
        CleanlinessHelper.playCenteredSound(user, class_3417.field_14956, class_3419.field_15252, 1.0f, 1.0f);
        for (class_1309 nearbyEntity : AOEHelper.getAoeTargets(user, user, distance)) {
            EnchantmentEffects.electrocute(user, nearbyEntity, damageAmount);
            if (--limit > 0) continue;
            break;
        }
    }

    public static void applyWeakeningCloud(class_1309 weakeningEntity, class_1309 target, boolean isOffHandStack) {
        int weakeningLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.WEAKENING, weakeningEntity, isOffHandStack);
        if (weakeningLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.WEAKENING))) {
            AOECloudHelper.spawnPickyStatusCloud(weakeningEntity, target, class_1294.field_5911, 60, weakeningLevel - 1, true, true, false);
        }
    }

    public static void applySwirling(class_1309 swirlingEntity, class_1309 target, float amount, boolean isOffHandStack) {
        int swirlingLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.SWIRLING, swirlingEntity, isOffHandStack);
        if (swirlingLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.SWIRLING) + 15 * swirlingLevel)) {
            EnchantmentEffects.causeSwirlingAttack(swirlingEntity, swirlingEntity, 1.5f, amount);
            CleanlinessHelper.playCenteredSound(target, class_3417.field_14706, 0.5f, 1.0f);
        }
    }

    public static void causeSwirlingAttack(class_1309 user, class_1309 target, float distance, float amount) {
        AOEHelper.getAoeTargets(target, user, distance).forEach(nearbyEntity -> nearbyEntity.method_5643(class_1282.field_5869, amount * 0.5f));
    }

    public static void applyChains(class_1309 chainingEntity, class_1309 target, boolean isOffHandStack) {
        int chainsLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.CHAINS, chainingEntity, isOffHandStack);
        if (chainsLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.CHAINS))) {
            EnchantmentEffects.chainNearbyEntities(chainingEntity, target, 1.5f * (float)chainsLevel, chainsLevel);
        }
    }

    public static void chainNearbyEntities(class_1309 user, class_1309 target, float distance, int timeMultiplier) {
        class_1293 chained = new class_1293(class_1294.field_5909, 100 * timeMultiplier, 100);
        target.method_6092(chained);
        AOEHelper.getAoeTargets(target, user, distance).stream().filter(nearbyEntity -> nearbyEntity != target).forEach(nearbyEntity -> {
            EnchantmentEffects.pullTowards((class_1297)nearbyEntity, (class_1297)target);
            nearbyEntity.method_6092(chained);
        });
    }

    public static void applyGravity(class_1309 gravityEntity, class_1309 target, boolean isOffHandStack) {
        int gravityLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.GRAVITY, gravityEntity, isOffHandStack);
        if (gravityLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.GRAVITY))) {
            EnchantmentEffects.pullInNearbyEntities(gravityEntity, target, (gravityLevel + 1) * 3);
        }
    }

    public static void pullTowards(class_1297 self, class_1297 target) {
        if (self instanceof class_1657 && ((class_1657)self).method_31549().field_7477) {
            return;
        }
        double motionX = class_3532.method_15350((double)((target.method_23317() - self.method_23317()) * (double)0.15f), (double)-5.0, (double)5.0);
        double motionZ = class_3532.method_15350((double)((target.method_23321() - self.method_23321()) * (double)0.15f), (double)-5.0, (double)5.0);
        class_243 vec3d = new class_243(motionX, 0.0, motionZ);
        self.method_18799(vec3d);
    }

    public static void pullInNearbyEntities(class_1309 user, class_1309 target, float distance) {
        AOEHelper.getAoeTargets(target, user, distance).stream().filter(nearbyEntity -> nearbyEntity != target).forEach(nearbyEntity -> EnchantmentEffects.pullTowards((class_1297)nearbyEntity, (class_1297)target));
    }

    public static void echoDamage(class_1309 echoEntity, class_1309 target, float amount, boolean isOffHandStack) {
        int echoLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.ECHO, echoEntity, isOffHandStack);
        if (echoLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.ECHO) + 15 * echoLevel)) {
            EnchantmentEffects.causeEchoAttack(echoEntity, target, 3.0f, echoLevel, amount);
            CleanlinessHelper.playCenteredSound(echoEntity, McdwSoundEvents.ECHO_SOUND_EVENT, 0.5f, 1.0f);
        }
    }

    public static void causeEchoAttack(class_1309 user, class_1309 target, float distance, int echoLevel, float amount) {
        for (class_1309 nearbyEntity : AOEHelper.getAoeTargets(target, user, distance)) {
            if (nearbyEntity == target) continue;
            nearbyEntity.method_5643(class_1282.field_5869, amount);
            if (--echoLevel > 0) continue;
            break;
        }
    }

    public static void explodingDamage(class_1309 exploderEntity, class_1309 target, boolean isOffHandStack) {
        int explodingLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.EXPLODING, exploderEntity, isOffHandStack);
        if (explodingLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.EXPLODING))) {
            CleanlinessHelper.playCenteredSound(target, class_3417.field_15152, 0.5f, 1.0f);
            AOECloudHelper.spawnExplosionCloud(exploderEntity, target, 3.0f);
            float explodingDamage = target.method_6063() * 0.2f * (float)explodingLevel;
            EnchantmentEffects.causeExplosionAttack(exploderEntity, target, explodingDamage, 3.0f);
        }
    }

    public static void causeExplosionAttack(class_1309 user, class_1309 target, float damageAmount, float distance) {
        AOEHelper.getAoeTargets(target, user, distance).forEach(nearbyEntity -> nearbyEntity.method_5643(class_1282.method_5512((class_1309)user), damageAmount));
    }

    public static void applyRampaging(class_1309 rampagingEntity, boolean isOffHandStack) {
        int rampagingLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.RAMPAGING, rampagingEntity, isOffHandStack);
        if (rampagingLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.RAMPAGING))) {
            class_1293 rampage = new class_1293(class_1294.field_5917, rampagingLevel * 100, 2, false, false);
            rampagingEntity.method_6092(rampage);
        }
    }

    public static void applyGuardingStrike(class_1309 guardingEntity, boolean isOffHandStack) {
        int guardingLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.GUARDING_STRIKE, guardingEntity, isOffHandStack);
        if (guardingLevel > 0) {
            class_1293 shield = new class_1293(class_1294.field_5907, 20 + 20 * guardingLevel, 2);
            guardingEntity.method_6092(shield);
        }
    }

    public static void applyLeeching(class_1309 leechingEntity, class_1309 target, boolean isOffHandStack) {
        int leechingLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.LEECHING, leechingEntity, isOffHandStack);
        if (leechingLevel > 0 && leechingEntity.method_6032() < leechingEntity.method_6063()) {
            float healthRegained = (0.2f + 0.2f * (float)leechingLevel) * target.method_6063();
            leechingEntity.method_6025(healthRegained);
        }
    }

    public static void applyRefreshment(class_1657 refreshingEntity, boolean isOffHandStack) {
        int refreshmentLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.REFRESHMENT, (class_1309)refreshingEntity, isOffHandStack);
        if (refreshmentLevel > 0) {
            class_1799 healthPotion = class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)class_1847.field_8963);
            InventoryHelper.mcdw$systematicReplacePotions(refreshingEntity, class_1802.field_8469, healthPotion, refreshmentLevel);
        }
    }

    public static void applyChainReaction(class_1309 shooter, class_1309 target, class_1665 ppe) {
        int chainReactionLevel = ((IMcdwEnchantedArrow)ppe).getChainReactionLevel();
        if (chainReactionLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.CHAIN_REACTION) * chainReactionLevel)) {
            ProjectileEffectHelper.fireChainReactionProjectileFromTarget(target.method_5770(), target, shooter, 3.15f, 1.0f);
        }
    }

    public static void applyCharge(class_1309 chargingEntity, class_1665 ppe) {
        int chargeLevel = ((IMcdwEnchantedArrow)ppe).getChargeLevel();
        if (chargeLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.CHARGE))) {
            chargingEntity.method_6092(new class_1293(class_1294.field_5904, chargeLevel * 20, 4));
        }
    }

    public static void applyCobwebShotEntity(class_1309 target, class_1665 ppe) {
        class_2338 targetPos;
        class_1937 targetWorld;
        if (((IMcdwEnchantedArrow)ppe).getCobwebShotLevel() > 0 && (targetWorld = target.method_5770()).method_8320(targetPos = target.method_24515()) == class_2246.field_10124.method_9564()) {
            targetWorld.method_8501(targetPos, class_2246.field_10343.method_9564());
        }
    }

    public static void applyFuseShot(class_1309 shooter, class_1309 target, class_1665 ppe) {
        int fuseShotLevel = ((IMcdwEnchantedArrow)ppe).getFuseShotLevel();
        if (fuseShotLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.FUSE_SHOT) + 15 * fuseShotLevel)) {
            CleanlinessHelper.playCenteredSound(target, class_3417.field_15152, 0.5f, 1.0f);
            AOECloudHelper.spawnExplosionCloud(shooter, target, 3.0f);
            float f = (float)ppe.method_18798().method_1033();
            int fuseShotDamage = class_3532.method_15384((double)class_3532.method_15350((double)((double)f * ppe.method_7448()), (double)0.0, (double)2.147483647E9));
            EnchantmentEffects.causeExplosionAttack(shooter, target, fuseShotDamage, 3.0f);
        }
    }

    public static void applyGravityShot(class_1309 shooter, class_1309 target, class_1665 ppe) {
        int gravityLevel = ((IMcdwEnchantedArrow)ppe).getGravityLevel();
        if (gravityLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.GRAVITY))) {
            EnchantmentEffects.pullInNearbyEntities(shooter, target, (gravityLevel + 1) * 3);
        }
    }

    public static void applyLevitationShot(class_1309 target, class_1665 ppe) {
        int levitationShotLevel = ((IMcdwEnchantedArrow)ppe).getLevitationShotLevel();
        if (levitationShotLevel > 0) {
            target.method_6092(new class_1293(class_1294.field_5902, 200 * levitationShotLevel));
        }
    }

    public static void applyPhantomsMark(class_1309 target, class_1665 ppe) {
        int phantomsMarkLevel = ((IMcdwEnchantedArrow)ppe).getPhantomsMarkLevel();
        if (phantomsMarkLevel > 0) {
            target.method_6092(new class_1293(class_1294.field_5912, 100 * phantomsMarkLevel));
        }
    }

    public static void applyPoisonCloudShot(class_1309 shooter, class_1309 target, class_1665 ppe) {
        int poisonCloudLevel = ((IMcdwEnchantedArrow)ppe).getPoisonCloudLevel();
        if (poisonCloudLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.POISON_CLOUD))) {
            AOECloudHelper.spawnStatusCloud(shooter, target, class_1294.field_5899, poisonCloudLevel - 1);
        }
    }

    public static void applyRadianceShot(class_1309 shooter, class_1309 target, class_1665 ppe) {
        int radianceLevel = ((IMcdwEnchantedArrow)ppe).getRadianceLevel();
        if (radianceLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.RADIANCE))) {
            AOECloudHelper.spawnRegenCloudAtPos(shooter, true, target.method_24515(), radianceLevel - 1);
        }
    }

    public static void applyRicochet(class_1309 shooter, class_1309 target, class_1665 ppe) {
        int ricochetLevel = ((IMcdwEnchantedArrow)ppe).getRicochetLevel();
        if (ricochetLevel > 0) {
            float damageMultiplier = 0.03f + (float)ricochetLevel * 0.07f;
            float arrowVelocity = McdwBow.maxBowRange;
            if (arrowVelocity > 0.1f) {
                ProjectileEffectHelper.spawnExtraArrows(shooter, target, 1, 10, damageMultiplier);
            }
        }
    }

    public static void applyReplenish(class_1657 shooter, class_1665 ppe) {
        int replenishLevel = ((IMcdwEnchantedArrow)ppe).getReplenishLevel();
        if (replenishLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.REPLENISH) + 7 * replenishLevel)) {
            CleanlinessHelper.mcdw$dropItem((class_1309)shooter, class_1802.field_8107);
        }
    }

    public static void applyTempoTheft(class_1309 tempoEntity, class_1309 target, class_1665 ppe) {
        int tempoTheftLevel = ((IMcdwEnchantedArrow)ppe).getTempoTheftLevel();
        if (tempoTheftLevel > 0) {
            AbilityHelper.stealSpeedFromTarget(tempoEntity, target, tempoTheftLevel);
        }
    }

    public static void applyWildRage(class_1308 ragingEntity, class_1665 ppe) {
        int wildRageLevel = ((IMcdwEnchantedArrow)ppe).getWildRageLevel();
        if (wildRageLevel > 0 && CleanlinessHelper.percentToOccur(CONFIG_CHANCE.get((Object)EnchantmentsID.WILD_RAGE) + 10 * wildRageLevel)) {
            EnchantmentEffects.sendIntoWildRage(ragingEntity);
        }
    }

    public static void applyCobwebShotBlock(class_3965 blockHitResult, class_1665 ppe) {
        if (((IMcdwEnchantedArrow)ppe).getCobwebShotLevel() > 0) {
            class_1937 ppeWorld = ppe.method_5770();
            class_2350 side = blockHitResult.method_17780();
            if (ppeWorld.method_8320(blockHitResult.method_17777().method_10093(side)) == class_2246.field_10124.method_9564()) {
                ppeWorld.method_8501(blockHitResult.method_17777().method_10093(side), class_2246.field_10343.method_9564());
            }
        }
    }

    public static void applyRadianceShotBlock(class_3965 blockHitResult, class_1309 shooter, class_1665 ppe) {
        int radianceLevel = ((IMcdwEnchantedArrow)ppe).getRadianceLevel();
        if (radianceLevel > 0) {
            AOECloudHelper.spawnRegenCloudAtPos(shooter, true, blockHitResult.method_17777(), radianceLevel - 1);
        }
    }

    public static void activateBurstBowstringOnJump(class_1309 jumpingEntity) {
        int burstBowstringLevel = Math.max(class_1890.method_8225((class_1887)EnchantsRegistry.BURST_BOWSTRING, (class_1799)jumpingEntity.method_6047()), class_1890.method_8225((class_1887)EnchantsRegistry.BURST_BOWSTRING, (class_1799)jumpingEntity.method_6079()));
        if (burstBowstringLevel > 0 && jumpingEntity instanceof class_1657) {
            class_1657 attackingPlayer = (class_1657)jumpingEntity;
            int availableArrows = Math.min(InventoryHelper.mcdw$countItem(attackingPlayer, class_1802.field_8107), burstBowstringLevel);
            if (availableArrows < 1) {
                return;
            }
            ProjectileEffectHelper.spawnExtraArrows(jumpingEntity, jumpingEntity, availableArrows, 16, 0.4f);
        }
    }

    public static void handleAddDynamoEffect(class_1657 playerEntity) {
        class_1799 mainHandStack = playerEntity.method_6047();
        class_1799 offHandStack = playerEntity.method_6079();
        if (Math.max(class_1890.method_8225((class_1887)EnchantsRegistry.DYNAMO, (class_1799)mainHandStack), class_1890.method_8225((class_1887)EnchantsRegistry.DYNAMO, (class_1799)offHandStack)) > 0) {
            class_1293 dynamoInstance = playerEntity.method_6112(StatusEffectsRegistry.DYNAMO);
            int i = 1;
            i = dynamoInstance != null ? (i += dynamoInstance.method_5578()) : --i;
            i = class_3532.method_15340((int)i, (int)0, (int)Mcdw.CONFIG.mcdwEnchantmentSettingsConfig.DYNAMO_STACK_CAP.get((Object)EnchantStatsID.DYNAMO_STACK_CAP));
            class_1293 dynamoUpdateInstance = new class_1293(StatusEffectsRegistry.DYNAMO, 120000, i, false, false, true);
            playerEntity.method_6092(dynamoUpdateInstance);
        }
    }

    public static void sendIntoWildRage(class_1308 mobEntity) {
        ((MobEntityAccessor)mobEntity).targetSelector().method_6277(0, (class_1352)new WildRageAttackGoal(mobEntity));
    }
}

