/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import java.nio.FloatBuffer;
import java.util.function.Supplier;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shadows.ShadowMatrices;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.vendored.joml.Matrix4f;
import net.minecraft.class_1159;

public final class MatrixUniforms {
    private MatrixUniforms() {
    }

    public static void addMatrixUniforms(UniformHolder uniformHolder, PackDirectives packDirectives) {
        MatrixUniforms.addMatrix(uniformHolder, "ModelView", CapturedRenderingState.INSTANCE::getGbufferModelView);
        MatrixUniforms.addMatrix(uniformHolder, "Projection", CapturedRenderingState.INSTANCE::getGbufferProjection);
        MatrixUniforms.addShadowMatrix(uniformHolder, "ModelView", () -> ShadowRenderer.createShadowModelView(packDirectives.getSunPathRotation(), packDirectives.getShadowDirectives().getIntervalSize()).method_23760().method_23761().method_22673());
        MatrixUniforms.addShadowArrayMatrix(uniformHolder, "Projection", () -> ShadowMatrices.createOrthoMatrix(packDirectives.getShadowDirectives().getDistance()));
    }

    private static void addMatrix(UniformHolder uniformHolder, String string, Supplier<class_1159> supplier) {
        uniformHolder.uniformMatrix(UniformUpdateFrequency.PER_FRAME, "gbuffer" + string, supplier).uniformJomlMatrix(UniformUpdateFrequency.PER_FRAME, "gbuffer" + string + "Inverse", new Inverted(supplier)).uniformMatrix(UniformUpdateFrequency.PER_FRAME, "gbufferPrevious" + string, new Previous(supplier));
    }

    private static void addShadowMatrix(UniformHolder uniformHolder, String string, Supplier<class_1159> supplier) {
        uniformHolder.uniformMatrix(UniformUpdateFrequency.PER_FRAME, "shadow" + string, supplier).uniformJomlMatrix(UniformUpdateFrequency.PER_FRAME, "shadow" + string + "Inverse", new Inverted(supplier));
    }

    private static void addShadowArrayMatrix(UniformHolder uniformHolder, String string, Supplier<float[]> supplier) {
        uniformHolder.uniformMatrixFromArray(UniformUpdateFrequency.PER_FRAME, "shadow" + string, supplier).uniformJomlMatrix(UniformUpdateFrequency.PER_FRAME, "shadow" + string + "Inverse", new InvertedArrayMatrix(supplier));
    }

    private static class Inverted
    implements Supplier<Matrix4f> {
        private final Supplier<class_1159> parent;

        Inverted(Supplier<class_1159> supplier) {
            this.parent = supplier;
        }

        @Override
        public Matrix4f get() {
            class_1159 class_11592 = this.parent.get().method_22673();
            FloatBuffer floatBuffer = FloatBuffer.allocate(16);
            class_11592.method_4932(floatBuffer);
            floatBuffer.rewind();
            Matrix4f matrix4f = new Matrix4f(floatBuffer);
            matrix4f.invert();
            return matrix4f;
        }
    }

    private static class Previous
    implements Supplier<class_1159> {
        private final Supplier<class_1159> parent;
        private class_1159 previous;

        Previous(Supplier<class_1159> supplier) {
            this.parent = supplier;
            this.previous = new class_1159();
        }

        @Override
        public class_1159 get() {
            class_1159 class_11592 = this.parent.get().method_22673();
            class_1159 class_11593 = this.previous.method_22673();
            this.previous = class_11592;
            return class_11593;
        }
    }

    private static class InvertedArrayMatrix
    implements Supplier<Matrix4f> {
        private final Supplier<float[]> parent;

        InvertedArrayMatrix(Supplier<float[]> supplier) {
            this.parent = supplier;
        }

        @Override
        public Matrix4f get() {
            FloatBuffer floatBuffer = FloatBuffer.allocate(16);
            floatBuffer.put(this.parent.get());
            floatBuffer.rewind();
            Matrix4f matrix4f = new Matrix4f(floatBuffer);
            matrix4f.invert();
            return matrix4f;
        }
    }
}

