/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import net.coderbot.iris.Iris;
import net.coderbot.iris.shaderpack.LegacyIdMap;
import net.coderbot.iris.shaderpack.OrderBackedProperties;
import net.coderbot.iris.shaderpack.StringPair;
import net.coderbot.iris.shaderpack.materialmap.BlockEntry;
import net.coderbot.iris.shaderpack.materialmap.BlockRenderType;
import net.coderbot.iris.shaderpack.materialmap.NamespacedId;
import net.coderbot.iris.shaderpack.option.ShaderPackOptions;
import net.coderbot.iris.shaderpack.preprocessor.PropertiesPreprocessor;

public class IdMap {
    private final Object2IntMap<NamespacedId> itemIdMap;
    private final Object2IntMap<NamespacedId> entityIdMap;
    private Int2ObjectMap<List<BlockEntry>> blockPropertiesMap;
    private Map<NamespacedId, BlockRenderType> blockRenderTypeMap;

    IdMap(Path path, ShaderPackOptions shaderPackOptions, Iterable<StringPair> iterable) {
        this.itemIdMap = IdMap.loadProperties(path, "item.properties", shaderPackOptions, iterable).map(IdMap::parseItemIdMap).orElse(Object2IntMaps.emptyMap());
        this.entityIdMap = IdMap.loadProperties(path, "entity.properties", shaderPackOptions, iterable).map(IdMap::parseEntityIdMap).orElse(Object2IntMaps.emptyMap());
        IdMap.loadProperties(path, "block.properties", shaderPackOptions, iterable).ifPresent(properties -> {
            this.blockPropertiesMap = IdMap.parseBlockMap(properties, "block.", "block.properties");
            this.blockRenderTypeMap = IdMap.parseRenderTypeMap(properties, "layer.", "block.properties");
        });
        if (this.blockPropertiesMap == null) {
            this.blockPropertiesMap = new Int2ObjectOpenHashMap();
            LegacyIdMap.addLegacyValues(this.blockPropertiesMap);
        }
        if (this.blockRenderTypeMap == null) {
            this.blockRenderTypeMap = Collections.emptyMap();
        }
    }

    private static Optional<Properties> loadProperties(Path path, String string, ShaderPackOptions shaderPackOptions, Iterable<StringPair> iterable) {
        String string2 = IdMap.readProperties(path, string);
        if (string2 == null) {
            return Optional.empty();
        }
        String string3 = PropertiesPreprocessor.preprocessSource(string2, shaderPackOptions, iterable);
        StringReader stringReader = new StringReader(string3);
        OrderBackedProperties orderBackedProperties = new OrderBackedProperties();
        try {
            orderBackedProperties.load(stringReader);
        }
        catch (IOException iOException) {
            Iris.logger.error("Error loading " + string + " at " + path, iOException);
            return Optional.empty();
        }
        return Optional.of(orderBackedProperties);
    }

    private static String readProperties(Path path, String string) {
        try {
            return new String(Files.readAllBytes(path.resolve(string)), StandardCharsets.ISO_8859_1);
        }
        catch (NoSuchFileException noSuchFileException) {
            Iris.logger.debug("An " + string + " file was not found in the current shaderpack");
            return null;
        }
        catch (IOException iOException) {
            Iris.logger.error("An IOException occurred reading " + string + " from the current shaderpack", iOException);
            return null;
        }
    }

    private static Object2IntMap<NamespacedId> parseItemIdMap(Properties properties) {
        return IdMap.parseIdMap(properties, "item.", "item.properties");
    }

    private static Object2IntMap<NamespacedId> parseEntityIdMap(Properties properties) {
        return IdMap.parseIdMap(properties, "entity.", "entity.properties");
    }

    private static Object2IntMap<NamespacedId> parseIdMap(Properties properties, String string, String string2) {
        Object2IntOpenHashMap object2IntOpenHashMap = new Object2IntOpenHashMap();
        object2IntOpenHashMap.defaultReturnValue(-1);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> IdMap.lambda$parseIdMap$1(string, string2, (Object2IntMap)object2IntOpenHashMap, arg_0, arg_1)));
        return Object2IntMaps.unmodifiable((Object2IntMap)object2IntOpenHashMap);
    }

    private static Int2ObjectMap<List<BlockEntry>> parseBlockMap(Properties properties, String string, String string2) {
        Int2ObjectOpenHashMap int2ObjectOpenHashMap = new Int2ObjectOpenHashMap();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> IdMap.lambda$parseBlockMap$2(string, string2, (Int2ObjectMap)int2ObjectOpenHashMap, arg_0, arg_1)));
        return Int2ObjectMaps.unmodifiable((Int2ObjectMap)int2ObjectOpenHashMap);
    }

    private static Map<NamespacedId, BlockRenderType> parseRenderTypeMap(Properties properties, String string, String string2) {
        HashMap<NamespacedId, BlockRenderType> hashMap = new HashMap<NamespacedId, BlockRenderType>();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(object, object2) -> {
            String string3 = (String)object;
            String string4 = (String)object2;
            if (!string3.startsWith(string)) {
                return;
            }
            String string5 = string3.substring(string.length());
            BlockRenderType blockRenderType = BlockRenderType.fromString(string5).orElse(null);
            if (blockRenderType == null) {
                Iris.logger.warn("Failed to parse line in " + string2 + ": invalid block render type: " + string3);
                return;
            }
            for (String string6 : string4.split("\\s+")) {
                hashMap.put(new NamespacedId(string6), blockRenderType);
            }
        }));
        return hashMap;
    }

    private static Map<NamespacedId, String> parseDimensionMap(Properties properties, String string, String string2) {
        Object2ObjectArrayMap object2ObjectArrayMap = new Object2ObjectArrayMap();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> IdMap.lambda$parseDimensionMap$4(string, (Map)object2ObjectArrayMap, arg_0, arg_1)));
        return object2ObjectArrayMap;
    }

    public Int2ObjectMap<List<BlockEntry>> getBlockProperties() {
        return this.blockPropertiesMap;
    }

    public Object2IntFunction<NamespacedId> getItemIdMap() {
        return this.itemIdMap;
    }

    public Object2IntFunction<NamespacedId> getEntityIdMap() {
        return this.entityIdMap;
    }

    public Map<NamespacedId, BlockRenderType> getBlockRenderTypeMap() {
        return this.blockRenderTypeMap;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        IdMap idMap = (IdMap)object;
        return Objects.equals(this.itemIdMap, idMap.itemIdMap) && Objects.equals(this.entityIdMap, idMap.entityIdMap) && Objects.equals(this.blockPropertiesMap, idMap.blockPropertiesMap) && Objects.equals(this.blockRenderTypeMap, idMap.blockRenderTypeMap);
    }

    public int hashCode() {
        return Objects.hash(this.itemIdMap, this.entityIdMap, this.blockPropertiesMap, this.blockRenderTypeMap);
    }

    private static /* synthetic */ void lambda$parseDimensionMap$4(String string, Map map, Object object, Object object2) {
        String string2 = (String)object;
        String string3 = (String)object2;
        if (!string2.startsWith(string)) {
            return;
        }
        string2 = string2.substring(string.length());
        for (String string4 : string3.split("\\s+")) {
            map.put(new NamespacedId(string4), string2);
        }
    }

    private static /* synthetic */ void lambda$parseBlockMap$2(String string, String string2, Int2ObjectMap int2ObjectMap, Object object, Object object2) {
        int n;
        String string3 = (String)object;
        String string4 = (String)object2;
        if (!string3.startsWith(string)) {
            return;
        }
        try {
            n = Integer.parseInt(string3.substring(string.length()));
        }
        catch (NumberFormatException numberFormatException) {
            Iris.logger.warn("Failed to parse line in " + string2 + ": invalid key " + string3);
            return;
        }
        ArrayList<BlockEntry> arrayList = new ArrayList<BlockEntry>();
        for (String string5 : string4.split("\\s+")) {
            if (string5.isEmpty()) continue;
            try {
                arrayList.add(BlockEntry.parse(string5));
            }
            catch (Exception exception) {
                Iris.logger.warn("Unexpected error while parsing an entry from " + string2 + " for the key " + string3 + ":", exception);
            }
        }
        int2ObjectMap.put(n, Collections.unmodifiableList(arrayList));
    }

    private static /* synthetic */ void lambda$parseIdMap$1(String string, String string2, Object2IntMap object2IntMap, Object object, Object object2) {
        int n;
        String string3 = (String)object;
        String string4 = (String)object2;
        if (!string3.startsWith(string)) {
            return;
        }
        try {
            n = Integer.parseInt(string3.substring(string.length()));
        }
        catch (NumberFormatException numberFormatException) {
            Iris.logger.warn("Failed to parse line in " + string2 + ": invalid key " + string3);
            return;
        }
        for (String string5 : string4.split("\\s+")) {
            if (string5.contains("=")) {
                Iris.logger.warn("Failed to parse an ResourceLocation in " + string2 + " for the key " + string3 + ": state properties are currently not supported: " + string5);
                continue;
            }
            object2IntMap.put((Object)new NamespacedId(string5), n);
        }
    }
}

