/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.rendertarget;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.texture.DepthBufferFormat;
import net.coderbot.iris.gl.texture.DepthCopyStrategy;
import net.coderbot.iris.rendertarget.DepthTexture;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.vendored.joml.Vector2i;

public class RenderTargets {
    private final RenderTarget[] targets;
    private int currentDepthTexture;
    private DepthBufferFormat currentDepthFormat;
    private final DepthTexture noTranslucents;
    private final DepthTexture noHand;
    private final GlFramebuffer depthSourceFb;
    private final GlFramebuffer noTranslucentsDestFb;
    private final GlFramebuffer noHandDestFb;
    private DepthCopyStrategy copyStrategy;
    private final List<GlFramebuffer> ownedFramebuffers;
    private final Map<Integer, PackRenderTargetDirectives.RenderTargetSettings> targetSettingsMap;
    private final PackDirectives packDirectives;
    private int cachedWidth;
    private int cachedHeight;
    private boolean fullClearRequired;
    private boolean translucentDepthDirty;
    private boolean handDepthDirty;
    private int cachedDepthBufferVersion;
    private boolean destroyed;

    public RenderTargets(int n, int n2, int n3, int n4, DepthBufferFormat depthBufferFormat, Map<Integer, PackRenderTargetDirectives.RenderTargetSettings> map, PackDirectives packDirectives) {
        this.targets = new RenderTarget[map.size()];
        this.targetSettingsMap = map;
        this.packDirectives = packDirectives;
        this.currentDepthTexture = n3;
        this.currentDepthFormat = depthBufferFormat;
        this.copyStrategy = DepthCopyStrategy.fastest(this.currentDepthFormat.isCombinedStencil());
        this.cachedWidth = n;
        this.cachedHeight = n2;
        this.cachedDepthBufferVersion = n4;
        this.ownedFramebuffers = new ArrayList<GlFramebuffer>();
        this.fullClearRequired = true;
        this.depthSourceFb = this.createFramebufferWritingToMain(new int[]{0});
        this.noTranslucents = new DepthTexture(n, n2, this.currentDepthFormat);
        this.noHand = new DepthTexture(n, n2, this.currentDepthFormat);
        this.noTranslucentsDestFb = this.createFramebufferWritingToMain(new int[]{0});
        this.noTranslucentsDestFb.addDepthAttachment(this.noTranslucents.getTextureId());
        this.noHandDestFb = this.createFramebufferWritingToMain(new int[]{0});
        this.noHandDestFb.addDepthAttachment(this.noHand.getTextureId());
        this.translucentDepthDirty = true;
        this.handDepthDirty = true;
    }

    public void destroy() {
        this.destroyed = true;
        for (GlFramebuffer glFramebuffer : this.ownedFramebuffers) {
            glFramebuffer.destroy();
        }
        for (RenderTarget renderTarget : this.targets) {
            if (renderTarget == null) continue;
            renderTarget.destroy();
        }
        this.noTranslucents.destroy();
        this.noHand.destroy();
    }

    public int getRenderTargetCount() {
        return this.targets.length;
    }

    public RenderTarget get(int n) {
        if (this.destroyed) {
            throw new IllegalStateException("Tried to use destroyed RenderTargets");
        }
        if (this.targets[n] == null) {
            return null;
        }
        return this.targets[n];
    }

    public RenderTarget getOrCreate(int n) {
        if (this.destroyed) {
            throw new IllegalStateException("Tried to use destroyed RenderTargets");
        }
        if (this.targets[n] != null) {
            return this.targets[n];
        }
        this.create(n);
        return this.targets[n];
    }

    private void create(int n) {
        PackRenderTargetDirectives.RenderTargetSettings renderTargetSettings = this.targetSettingsMap.get(n);
        Vector2i vector2i = this.packDirectives.getTextureScaleOverride(n, this.cachedWidth, this.cachedHeight);
        this.targets[n] = RenderTarget.builder().setDimensions(vector2i.x, vector2i.y).setInternalFormat(renderTargetSettings.getInternalFormat()).setPixelFormat(renderTargetSettings.getInternalFormat().getPixelFormat()).build();
    }

    public int getDepthTexture() {
        return this.currentDepthTexture;
    }

    public DepthTexture getDepthTextureNoTranslucents() {
        if (this.destroyed) {
            throw new IllegalStateException("Tried to use destroyed RenderTargets");
        }
        return this.noTranslucents;
    }

    public DepthTexture getDepthTextureNoHand() {
        return this.noHand;
    }

    public boolean resizeIfNeeded(int n, int n2, int n3, int n4, DepthBufferFormat depthBufferFormat, PackDirectives packDirectives) {
        boolean bl;
        boolean bl2 = false;
        if (this.cachedDepthBufferVersion != n) {
            bl2 = true;
            this.currentDepthTexture = n2;
            this.cachedDepthBufferVersion = n;
        }
        boolean bl3 = n3 != this.cachedWidth || n4 != this.cachedHeight;
        boolean bl4 = bl = depthBufferFormat != this.currentDepthFormat;
        if (bl) {
            this.currentDepthFormat = depthBufferFormat;
            this.copyStrategy = DepthCopyStrategy.fastest(this.currentDepthFormat.isCombinedStencil());
        }
        if (bl2) {
            for (GlFramebuffer glFramebuffer : this.ownedFramebuffers) {
                if (glFramebuffer == this.noHandDestFb || glFramebuffer == this.noTranslucentsDestFb || !glFramebuffer.hasDepthAttachment()) continue;
                glFramebuffer.addDepthAttachment(n2);
            }
        }
        if (bl || bl3) {
            this.noTranslucents.resize(n3, n4, depthBufferFormat);
            this.noHand.resize(n3, n4, depthBufferFormat);
            this.translucentDepthDirty = true;
            this.handDepthDirty = true;
        }
        if (bl3) {
            this.cachedWidth = n3;
            this.cachedHeight = n4;
            for (int i = 0; i < this.targets.length; ++i) {
                if (this.targets[i] == null) continue;
                this.targets[i].resize(packDirectives.getTextureScaleOverride(i, n3, n4));
            }
            this.fullClearRequired = true;
        }
        return bl3;
    }

    public void copyPreTranslucentDepth() {
        if (this.translucentDepthDirty) {
            this.translucentDepthDirty = false;
            RenderSystem.bindTexture((int)this.noTranslucents.getTextureId());
            this.depthSourceFb.bindAsReadBuffer();
            IrisRenderSystem.copyTexImage2D(3553, 0, this.currentDepthFormat.getGlInternalFormat(), 0, 0, this.cachedWidth, this.cachedHeight, 0);
        } else {
            this.copyStrategy.copy(this.depthSourceFb, this.getDepthTexture(), this.noTranslucentsDestFb, this.noTranslucents.getTextureId(), this.getCurrentWidth(), this.getCurrentHeight());
        }
    }

    public void copyPreHandDepth() {
        if (this.handDepthDirty) {
            this.handDepthDirty = false;
            RenderSystem.bindTexture((int)this.noHand.getTextureId());
            this.depthSourceFb.bindAsReadBuffer();
            IrisRenderSystem.copyTexImage2D(3553, 0, this.currentDepthFormat.getGlInternalFormat(), 0, 0, this.cachedWidth, this.cachedHeight, 0);
        } else {
            this.copyStrategy.copy(this.depthSourceFb, this.getDepthTexture(), this.noHandDestFb, this.noHand.getTextureId(), this.getCurrentWidth(), this.getCurrentHeight());
        }
    }

    public boolean isFullClearRequired() {
        return this.fullClearRequired;
    }

    public void onFullClear() {
        this.fullClearRequired = false;
    }

    public GlFramebuffer createFramebufferWritingToMain(int[] nArray) {
        return this.createFullFramebuffer(false, nArray);
    }

    public GlFramebuffer createFramebufferWritingToAlt(int[] nArray) {
        return this.createFullFramebuffer(true, nArray);
    }

    public GlFramebuffer createClearFramebuffer(boolean bl, int[] nArray) {
        ImmutableSet<Integer> immutableSet = ImmutableSet.of();
        if (!bl) {
            immutableSet = this.invert((ImmutableSet<Integer>)ImmutableSet.of(), nArray);
        }
        return this.createColorFramebuffer(immutableSet, nArray);
    }

    private ImmutableSet<Integer> invert(ImmutableSet<Integer> immutableSet, int[] nArray) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int n : nArray) {
            if (immutableSet.contains((Object)n)) continue;
            builder.add((Object)n);
        }
        return builder.build();
    }

    private GlFramebuffer createEmptyFramebuffer() {
        GlFramebuffer glFramebuffer = new GlFramebuffer();
        this.ownedFramebuffers.add(glFramebuffer);
        glFramebuffer.addDepthAttachment(this.currentDepthTexture);
        glFramebuffer.addColorAttachment(0, this.getOrCreate(0).getMainTexture());
        glFramebuffer.noDrawBuffers();
        return glFramebuffer;
    }

    public GlFramebuffer createGbufferFramebuffer(ImmutableSet<Integer> immutableSet, int[] nArray) {
        if (nArray.length == 0) {
            return this.createEmptyFramebuffer();
        }
        ImmutableSet<Integer> immutableSet2 = this.invert(immutableSet, nArray);
        GlFramebuffer glFramebuffer = this.createColorFramebuffer(immutableSet2, nArray);
        glFramebuffer.addDepthAttachment(this.currentDepthTexture);
        return glFramebuffer;
    }

    private GlFramebuffer createFullFramebuffer(boolean bl, int[] nArray) {
        if (nArray.length == 0) {
            return this.createEmptyFramebuffer();
        }
        ImmutableSet<Integer> immutableSet = ImmutableSet.of();
        if (!bl) {
            immutableSet = this.invert((ImmutableSet<Integer>)ImmutableSet.of(), nArray);
        }
        return this.createColorFramebufferWithDepth(immutableSet, nArray);
    }

    public GlFramebuffer createColorFramebufferWithDepth(ImmutableSet<Integer> immutableSet, int[] nArray) {
        GlFramebuffer glFramebuffer = this.createColorFramebuffer(immutableSet, nArray);
        glFramebuffer.addDepthAttachment(this.currentDepthTexture);
        return glFramebuffer;
    }

    public GlFramebuffer createColorFramebuffer(ImmutableSet<Integer> immutableSet, int[] nArray) {
        int n;
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Framebuffer must have at least one color buffer");
        }
        GlFramebuffer glFramebuffer = new GlFramebuffer();
        this.ownedFramebuffers.add(glFramebuffer);
        int[] nArray2 = new int[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray2[n] = n;
            if (nArray[n] >= this.getRenderTargetCount()) {
                glFramebuffer.destroy();
                this.ownedFramebuffers.remove(glFramebuffer);
                throw new IllegalStateException("Render target with index " + nArray[n] + " is not supported, only " + this.getRenderTargetCount() + " render targets are supported.");
            }
            RenderTarget renderTarget = this.getOrCreate(nArray[n]);
            int n2 = immutableSet.contains((Object)nArray[n]) ? renderTarget.getMainTexture() : renderTarget.getAltTexture();
            glFramebuffer.addColorAttachment(n, n2);
        }
        glFramebuffer.drawBuffers(nArray2);
        glFramebuffer.readBuffer(0);
        n = glFramebuffer.getStatus();
        if (n != 36053) {
            throw new IllegalStateException("Unexpected error while creating framebuffer: Draw buffers " + Arrays.toString(nArray2) + " Status: " + n);
        }
        return glFramebuffer;
    }

    public void destroyFramebuffer(GlFramebuffer glFramebuffer) {
        glFramebuffer.destroy();
        this.ownedFramebuffers.remove(glFramebuffer);
    }

    public int getCurrentWidth() {
        return this.cachedWidth;
    }

    public int getCurrentHeight() {
        return this.cachedHeight;
    }
}

