/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.mixin.GlStateManagerAccessor;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43C;

public interface DepthCopyStrategy {
    public static DepthCopyStrategy fastest(boolean bl) {
        if (GL.getCapabilities().glCopyImageSubData != 0L) {
            return new Gl43CopyImage();
        }
        if (bl) {
            return new Gl30BlitFbCombinedDepthStencil();
        }
        return new Gl20CopyTexture();
    }

    public boolean needsDestFramebuffer();

    public void copy(GlFramebuffer var1, int var2, GlFramebuffer var3, int var4, int var5, int var6);

    public static class Gl43CopyImage
    implements DepthCopyStrategy {
        private Gl43CopyImage() {
        }

        @Override
        public boolean needsDestFramebuffer() {
            return false;
        }

        @Override
        public void copy(GlFramebuffer glFramebuffer, int n, GlFramebuffer glFramebuffer2, int n2, int n3, int n4) {
            GL43C.glCopyImageSubData((int)n, (int)3553, (int)0, (int)0, (int)0, (int)0, (int)n2, (int)3553, (int)0, (int)0, (int)0, (int)0, (int)n3, (int)n4, (int)1);
        }
    }

    public static class Gl30BlitFbCombinedDepthStencil
    implements DepthCopyStrategy {
        private Gl30BlitFbCombinedDepthStencil() {
        }

        @Override
        public boolean needsDestFramebuffer() {
            return true;
        }

        @Override
        public void copy(GlFramebuffer glFramebuffer, int n, GlFramebuffer glFramebuffer2, int n2, int n3, int n4) {
            IrisRenderSystem.blitFramebuffer(glFramebuffer.getId(), glFramebuffer2.getId(), 0, 0, n3, n4, 0, 0, n3, n4, 1280, 9728);
        }
    }

    public static class Gl20CopyTexture
    implements DepthCopyStrategy {
        private Gl20CopyTexture() {
        }

        @Override
        public boolean needsDestFramebuffer() {
            return false;
        }

        @Override
        public void copy(GlFramebuffer glFramebuffer, int n, GlFramebuffer glFramebuffer2, int n2, int n3, int n4) {
            glFramebuffer.bindAsReadBuffer();
            int n5 = RenderSystem.getTextureId((int)GlStateManagerAccessor.getActiveTexture());
            IrisRenderSystem.copyTexSubImage2D(n2, 3553, 0, 0, 0, 0, 0, n3, n4);
            RenderSystem.bindTexture((int)n5);
        }
    }
}

