/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.ponder;

import com.mrh0.createaddition.blocks.connector.ConnectorBlock;
import com.mrh0.createaddition.blocks.connector.ConnectorMode;
import com.mrh0.createaddition.blocks.liquid_blaze_burner.LiquidBlazeBurnerBlock;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceTileEntity;
import com.mrh0.createaddition.blocks.tesla_coil.TeslaCoilBlock;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.index.CAFluids;
import com.mrh0.createaddition.index.CAItems;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.utility.Pointing;
import com.tterrag.registrate.fabric.SimpleFlowableFluid;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2401;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;

public class PonderScenes {
    public static void electricMotor(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("electric_motor", "Generating Rotational Force using Electric Motors");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        class_2338 motor = util.grid.at(3, 1, 2);
        for (int i = 0; i < 3; ++i) {
            scene.idle(5);
            scene.world.showSection(util.select.position(1 + i, 1, 2), class_2350.field_11033);
        }
        scene.idle(10);
        scene.effects.rotationSpeedIndicator(motor);
        scene.overlay.showText(50).text("Electric Motors are a compact and configurable source of Rotational Force").placeNearTarget().pointAt(util.vector.topOf(motor));
        scene.idle(50);
        scene.rotateCameraY(90.0f);
        scene.idle(20);
        class_243 blockSurface = util.vector.blockSurface(motor, class_2350.field_11034);
        class_238 point = new class_238(blockSurface, blockSurface);
        class_238 expanded = point.method_1009(0.0625, (double)0.2f, (double)0.2f);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.WHITE, (Object)blockSurface, point, 1);
        scene.idle(1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.WHITE, (Object)blockSurface, expanded, 60);
        scene.overlay.showControls(new InputWindowElement(blockSurface, Pointing.DOWN).scroll(), 60);
        scene.idle(20);
        scene.addKeyframe();
        scene.overlay.showText(70).text("Scrolling on the back panel changes the RPM of the motors' rotational output").placeNearTarget().pointAt(blockSurface);
        scene.idle(10);
        scene.world.modifyKineticSpeed(util.select.fromTo(1, 1, 2, 3, 1, 2), f -> Float.valueOf(4.0f * f.floatValue()));
        scene.effects.rotationSpeedIndicator(motor);
        scene.idle(70);
        scene.addKeyframe();
        scene.overlay.showText(70).text("The Electric Motor requires a source of energy (fe)").placeNearTarget().pointAt(blockSurface);
        scene.idle(80);
        scene.overlay.showText(70).text("The motors' energy consumption is determined by the set RPM").placeNearTarget().pointAt(blockSurface);
        scene.idle(80);
        scene.markAsFinished();
        scene.rotateCameraY(-90.0f);
    }

    public static void alternator(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("alternator", "Generating Electric energy using a Alternator");
        scene.configureBasePlate(1, 0, 4);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        class_2338 generator = util.grid.at(3, 1, 2);
        for (int i = 0; i < 6; ++i) {
            scene.idle(5);
            scene.world.showSection(util.select.position(i, 1, 2), class_2350.field_11033);
        }
        scene.idle(10);
        scene.overlay.showText(50).text("The Alternator generates electric energy (fe) from rotational force").placeNearTarget().pointAt(util.vector.topOf(generator));
        scene.idle(60);
        scene.overlay.showText(50).text("It requires atleast 32 RPM to operate").placeNearTarget().pointAt(util.vector.topOf(generator));
        scene.idle(60);
        scene.overlay.showText(50).text("The Alternators energy production is determined by the input RPM").placeNearTarget().pointAt(util.vector.topOf(generator));
        scene.idle(60);
        scene.markAsFinished();
    }

    public static void rollingMill(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("rolling_mill", "Rolling metals into Rods and Wires");
        scene.configureBasePlate(1, 0, 4);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        class_2338 mill = util.grid.at(3, 1, 2);
        for (int i = 0; i < 6; ++i) {
            scene.idle(5);
            scene.world.showSection(util.select.position(i, 1, 2), class_2350.field_11033);
        }
        scene.idle(10);
        scene.overlay.showText(50).text("The Rolling Mill uses rotational force to roll metals into Rods and Wires").placeNearTarget().pointAt(util.vector.topOf(mill));
        scene.idle(60);
        scene.overlay.showText(50).text("To manualy input items, drop Ingots or Plates on the top of the Mill").placeNearTarget().pointAt(util.vector.topOf(mill));
        scene.idle(60);
        scene.addKeyframe();
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(mill), Pointing.DOWN).rightClick(), 50);
        scene.overlay.showText(50).text("Manualy retrieve the rolled output by R-clicking the Mill").placeNearTarget().pointAt(util.vector.topOf(mill));
        scene.idle(60);
        scene.markAsFinished();
    }

    public static void automateRollingMill(SceneBuilder scene, SceneBuildingUtil util) {
        int i;
        scene.title("automated_rolling_mill", "Automating the Rolling Mill");
        scene.configureBasePlate(1, 0, 4);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        class_2338 mill = util.grid.at(3, 2, 2);
        class_2338 in = util.grid.at(3, 2, 3);
        class_2338 out = util.grid.at(3, 2, 1);
        for (i = 0; i < 3; ++i) {
            scene.idle(5);
            scene.world.showSection(util.select.position(i, 1, 4), class_2350.field_11033);
        }
        for (i = 5; i >= 0; --i) {
            scene.idle(5);
            scene.world.showSection(util.select.position(3, 1, i), class_2350.field_11033);
            scene.world.showSection(util.select.position(4, 1, i), class_2350.field_11033);
            scene.world.showSection(util.select.position(4, 2, i), class_2350.field_11033);
        }
        scene.world.showSection(util.select.position(mill), class_2350.field_11033);
        scene.addKeyframe();
        scene.overlay.showText(50).text("The Rolling Mill can be automated using a Belt and two Funnels").placeNearTarget().pointAt(util.vector.topOf(mill));
        scene.idle(60);
        scene.idle(5);
        scene.world.showSection(util.select.position(in), class_2350.field_11043);
        scene.idle(5);
        scene.world.showSection(util.select.position(out), class_2350.field_11035);
        scene.idle(20);
        scene.markAsFinished();
    }

    public static void ccMotor(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("cc_electric_motor", "Using Computercraft to control an Electric Motor");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        class_2338 motor = util.grid.at(2, 1, 2);
        class_2338 computer = util.grid.at(1, 1, 2);
        scene.idle(5);
        scene.world.showSection(util.select.position(motor), class_2350.field_11033);
        scene.idle(5);
        scene.world.showSection(util.select.position(computer), class_2350.field_11033);
        scene.idle(10);
        scene.overlay.showText(50).text("The Electric Motor can be controlled using Computercraft").placeNearTarget().pointAt(util.vector.topOf(computer));
        scene.idle(60);
        scene.idle(10);
        scene.overlay.showText(50).text("Connect to the motor using 'peripheral.wrap(side)'").placeNearTarget().pointAt(util.vector.topOf(computer));
        scene.idle(60);
        scene.addKeyframe();
        scene.idle(10);
        scene.overlay.showText(150).text("Get to the API documentation by issuing the command '/cca_api' in the chat").placeNearTarget().pointAt(util.vector.topOf(computer));
        scene.idle(160);
        scene.markAsFinished();
    }

    public static void teslaCoil(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("tesla_coil", "Using Tesla Coil");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.setBlock(util.grid.at(3, 2, 2), class_2246.field_10382.method_9564(), false);
        class_2338 depotPos = util.grid.at(2, 1, 2);
        scene.world.showSection(util.select.position(2, 1, 2), class_2350.field_11033);
        scene.idle(5);
        scene.world.showSection(util.select.position(2, 3, 2), class_2350.field_11033);
        scene.idle(5);
        class_243 topOf = util.vector.topOf(depotPos);
        scene.overlay.showText(50).attachKeyFrame().text("Tesla Coil will charge Items below it").placeNearTarget().pointAt(topOf);
        scene.idle(60);
        scene.world.createItemOnBeltLike(depotPos, class_2350.field_11043, AllItems.CHROMATIC_COMPOUND.asStack());
        scene.idle(10);
        scene.world.setBlock(util.grid.at(2, 3, 2), (class_2680)((class_2680)CABlocks.TESLA_COIL.getDefaultState().method_11657((class_2769)TeslaCoilBlock.FACING, (Comparable)class_2350.field_11036)).method_11657((class_2769)TeslaCoilBlock.POWERED, (Comparable)Boolean.valueOf(true)), false);
        scene.overlay.showText(70).attachKeyFrame().text("It will charge any Forge Energy Items and more!").placeNearTarget().pointAt(topOf);
        scene.idle(80);
        scene.markAsFinished();
    }

    public static void teslaCoilHurt(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("tesla_coil_hurt", "Dangerous Tesla Coils");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        class_2338 teslacoil = util.grid.at(2, 1, 2);
        class_2338 lever = util.grid.at(2, 1, 1);
        scene.world.showSection(util.select.position(teslacoil), class_2350.field_11033);
        scene.idle(5);
        scene.overlay.showText(70).attachKeyFrame().text("The Tesla Coil is also able to Shock nearby Players and Mobs").placeNearTarget().pointAt(util.vector.topOf(teslacoil));
        scene.idle(80);
        scene.world.showSection(util.select.position(lever), class_2350.field_11035);
        scene.idle(5);
        scene.overlay.showText(50).attachKeyFrame().text("This can be activated with a Redstone signal").placeNearTarget().pointAt(util.vector.centerOf(lever));
        scene.idle(60);
        scene.world.setBlock(lever, (class_2680)((class_2680)((class_2680)class_2246.field_10363.method_9564().method_11657((class_2769)class_2401.field_11265, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2401.field_11177, (Comparable)class_2350.field_11035)).method_11657((class_2769)class_2401.field_11007, (Comparable)class_2738.field_12475), false);
        scene.idle(5);
        scene.world.setBlock(teslacoil, (class_2680)((class_2680)CABlocks.TESLA_COIL.getDefaultState().method_11657((class_2769)TeslaCoilBlock.FACING, (Comparable)class_2350.field_11033)).method_11657((class_2769)TeslaCoilBlock.POWERED, (Comparable)Boolean.valueOf(true)), false);
        scene.idle(5);
        scene.overlay.showText(70).attachKeyFrame().text("Prepare to be Shocked!").placeNearTarget().pointAt(util.vector.topOf(teslacoil));
        scene.idle(80);
        scene.markAsFinished();
    }

    public static void liquidBlazeBurner(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("liquid_blaze_burner", "Liquid Fuel Burning");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        class_2338 burner = util.grid.at(2, 1, 2);
        class_2338[] blocks = new class_2338[]{util.grid.at(1, 1, 2), util.grid.at(0, 1, 2), util.grid.at(0, 2, 2), util.grid.at(0, 3, 2)};
        scene.world.showSection(util.select.position(burner), class_2350.field_11033);
        scene.idle(5);
        scene.overlay.showText(50).attachKeyFrame().text("Giving the Blaze Burner a Straw").placeNearTarget().pointAt(util.vector.topOf(burner));
        scene.idle(10);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(burner), Pointing.DOWN).rightClick().withItem(new class_1799((class_1935)CAItems.STRAW.get())), 40);
        scene.world.setBlock(burner, (class_2680)CABlocks.LIQUID_BLAZE_BURNER.getDefaultState().method_11657(LiquidBlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.SMOULDERING), false);
        scene.idle(60);
        scene.overlay.showText(50).attachKeyFrame().text("will allow it to accept liquid fuels by Buckets,").placeNearTarget().pointAt(util.vector.topOf(burner));
        scene.idle(10);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(burner), Pointing.DOWN).rightClick().withItem(new class_1799((class_1935)((SimpleFlowableFluid.Flowing)CAFluids.BIOETHANOL.get()).method_15774())), 40);
        scene.idle(60);
        scene.overlay.showText(50).text("- or by pipes.").placeNearTarget().pointAt(util.vector.topOf(burner));
        scene.idle(10);
        for (int i = 0; i < blocks.length; ++i) {
            scene.idle(5);
            scene.world.showSection(util.select.position(blocks[i]), class_2350.field_11034);
        }
        scene.idle(20);
        scene.markAsFinished();
    }

    public static void modularAccumulator(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("modular_accumulator", "Accumulator");
        scene.configureBasePlate(0, 0, 4);
        scene.showBasePlate();
        scene.idle(15);
        class_2338 cIn = new class_2338(1, 3, 1);
        class_2338 cOut = new class_2338(2, 3, 2);
        Selection accumulator = util.select.fromTo(1, 1, 1, 2, 2, 2);
        ElementLink accumulatorLink = scene.world.showIndependentSection(accumulator, class_2350.field_11034);
        scene.idle(15);
        scene.overlay.showOutline(PonderPalette.GREEN, (Object)accumulatorLink, accumulator, 50);
        scene.overlay.showText(50).text("The Accumulator is a multiblock").placeNearTarget().pointAt(util.vector.centerOf(cIn));
        scene.idle(60);
        scene.overlay.showText(50).text("It can store large amounts of energy").placeNearTarget().pointAt(util.vector.centerOf(cIn));
        scene.idle(60);
        scene.world.showSection(util.select.position(cIn), class_2350.field_11033);
        scene.idle(5);
        scene.world.showSection(util.select.position(cOut), class_2350.field_11033);
        scene.idle(15);
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(cIn), Pointing.DOWN).rightClick().withItem(new class_1799((class_1935)AllItems.WRENCH.get())), 40);
        scene.world.setBlock(cIn, (class_2680)((class_2680)CABlocks.CONNECTOR_COPPER.getDefaultState().method_11657((class_2769)ConnectorBlock.FACING, (Comparable)class_2350.field_11033)).method_11657(ConnectorBlock.MODE, (Comparable)((Object)ConnectorMode.Push)), false);
        scene.overlay.showText(50).attachKeyFrame().text("Configure an input connector,").placeNearTarget().pointAt(util.vector.centerOf(cIn));
        scene.idle(60);
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(cOut), Pointing.DOWN).rightClick().withItem(new class_1799((class_1935)AllItems.WRENCH.get())), 40);
        scene.world.setBlock(cOut, (class_2680)((class_2680)CABlocks.CONNECTOR_COPPER.getDefaultState().method_11657((class_2769)ConnectorBlock.FACING, (Comparable)class_2350.field_11033)).method_11657(ConnectorBlock.MODE, (Comparable)((Object)ConnectorMode.Pull)), false);
        scene.overlay.showText(50).text("and an output connector.").placeNearTarget().pointAt(util.vector.centerOf(cOut));
        scene.idle(60);
        scene.overlay.showText(110).text("Compat").placeNearTarget().pointAt(util.vector.centerOf(cOut));
        scene.idle(120);
        scene.markAsFinished();
    }

    public static void peiTransfer(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("pei_transfer", "Contraption Storage Exchange");
        scene.configureBasePlate(0, 0, 6);
        scene.scaleSceneView(0.95f);
        scene.setSceneOffsetY(-1.0f);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        scene.idle(5);
        class_2338 bearing = util.grid.at(5, 1, 2);
        scene.world.showSection(util.select.position(bearing), class_2350.field_11033);
        scene.idle(5);
        ElementLink contraption = scene.world.showIndependentSection(util.select.fromTo(5, 2, 2, 6, 4, 2), class_2350.field_11033);
        scene.world.configureCenterOfRotation(contraption, util.vector.centerOf(bearing));
        scene.idle(10);
        scene.world.rotateBearing(bearing, 360.0f, 70);
        scene.world.rotateSection(contraption, 0.0, 360.0, 0.0, 70);
        scene.overlay.showText(60).pointAt(util.vector.topOf(bearing.method_10086(2))).colored(PonderPalette.RED).placeNearTarget().attachKeyFrame().text("Inventories on moving contraptions cannot be accessed by players.");
        scene.idle(70);
        class_2338 pei = util.grid.at(4, 2, 2);
        scene.world.showSectionAndMerge(util.select.position(pei), class_2350.field_11034, contraption);
        scene.idle(13);
        scene.effects.superGlue(pei, class_2350.field_11034, true);
        scene.overlay.showText(80).pointAt(util.vector.topOf(pei)).colored(PonderPalette.GREEN).placeNearTarget().attachKeyFrame().text("This component can interact with storage without the need to stop the contraption.");
        scene.idle(90);
        class_2338 pei2 = pei.method_10088(2);
        scene.world.showSection(util.select.position(pei2), class_2350.field_11033);
        scene.overlay.showSelectionWithText(util.select.position(pei.method_10067()), 50).colored(PonderPalette.RED).placeNearTarget().attachKeyFrame().text("Place a second one with a gap of 1 or 2 blocks inbetween");
        scene.idle(55);
        scene.world.rotateBearing(bearing, 360.0f, 60);
        scene.world.rotateSection(contraption, 0.0, 360.0, 0.0, 60);
        scene.idle(20);
        scene.overlay.showText(40).placeNearTarget().pointAt(util.vector.of(3.0, 3.0, 2.5)).text("Whenever they pass by each other, they will engage in a connection");
        scene.idle(35);
        Selection both = util.select.fromTo(2, 2, 2, 4, 2, 2);
        Class<PortableEnergyInterfaceTileEntity> peiClass = PortableEnergyInterfaceTileEntity.class;
        scene.world.modifyBlockEntityNBT(both, peiClass, nbt -> {
            nbt.method_10548("Distance", 1.0f);
            nbt.method_10548("Timer", 40.0f);
        });
        scene.idle(20);
        scene.overlay.showOutline(PonderPalette.GREEN, (Object)pei, util.select.fromTo(5, 3, 2, 6, 4, 2), 80);
        scene.idle(10);
        scene.overlay.showSelectionWithText(util.select.position(pei2), 70).placeNearTarget().colored(PonderPalette.GREEN).attachKeyFrame().text("While engaged, the stationary interface will represent ALL inventories on the contraption");
        scene.idle(80);
        class_2338 connector = util.grid.at(2, 3, 2);
        scene.world.showSection(util.select.position(connector), class_2350.field_11033);
        scene.overlay.showText(70).placeNearTarget().pointAt(util.vector.centerOf(connector)).attachKeyFrame().text("Items can now be inserted...");
        scene.idle(80);
        scene.overlay.showText(120).placeNearTarget().pointAt(util.vector.centerOf(pei2)).text("After no items have been exchanged for a while, the contraption will continue on its way");
        scene.world.modifyBlockEntityNBT(both, peiClass, nbt -> nbt.method_10548("Timer", 9.0f));
        scene.idle(15);
        scene.world.rotateBearing(bearing, 270.0f, 120);
        scene.world.rotateSection(contraption, 0.0, 270.0, 0.0, 120);
        scene.markAsFinished();
    }

    public static void peiRedstone(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("pei_redstone", "Redstone Control");
        scene.configureBasePlate(0, 0, 5);
        scene.setSceneOffsetY(-1.0f);
        Class<PortableEnergyInterfaceTileEntity> peiClass = PortableEnergyInterfaceTileEntity.class;
        Selection peis = util.select.fromTo(1, 1, 3, 1, 3, 3);
        scene.world.modifyBlockEntityNBT(peis, peiClass, nbt -> {
            nbt.method_10548("Distance", 1.0f);
            nbt.method_10548("Timer", 40.0f);
        });
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world.showSection(util.select.layer(1), class_2350.field_11033);
        scene.idle(5);
        ElementLink contraption = scene.world.showIndependentSection(util.select.layersFrom(2), class_2350.field_11033);
        class_2338 bearing = util.grid.at(3, 1, 3);
        scene.world.configureCenterOfRotation(contraption, util.vector.topOf(bearing));
        scene.idle(20);
        scene.world.modifyBlockEntityNBT(peis, peiClass, nbt -> nbt.method_10548("Timer", 9.0f));
        scene.idle(20);
        scene.world.rotateBearing(bearing, 1350.0f, 300);
        scene.world.rotateSection(contraption, 0.0, 1350.0, 0.0, 300);
        scene.idle(20);
        scene.world.toggleRedstonePower(util.select.fromTo(1, 1, 1, 1, 1, 2));
        scene.effects.indicateRedstone(util.grid.at(1, 1, 1));
        scene.idle(10);
        scene.overlay.showSelectionWithText(util.select.position(1, 1, 3), 120).colored(PonderPalette.RED).text("Redstone power will prevent the stationary interface from engaging");
        scene.idle(20);
        scene.markAsFinished();
    }
}

