/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.redstone_relay;

import com.mrh0.createaddition.blocks.redstone_relay.RedstoneRelayBlock;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.LocalNode;
import com.mrh0.createaddition.energy.NodeRotation;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.network.EnergyNetworkPacket;
import com.mrh0.createaddition.network.IObserveTileEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class RedstoneRelayTileEntity
extends SmartBlockEntity
implements IWireNode,
IHaveGoggleInformation,
IObserveTileEntity {
    private final Set<LocalNode> wireCache = new HashSet<LocalNode>();
    private final LocalNode[] localNodes = new LocalNode[this.getNodeCount()];
    private final IWireNode[] nodeCache = new IWireNode[this.getNodeCount()];
    private EnergyNetwork networkIn;
    private EnergyNetwork networkOut;
    private long demand = 0L;
    private long throughput = 0L;
    private boolean wasContraption = false;
    private boolean firstTick = true;
    public static class_243 OFFSET_NORTH = new class_243(0.0, -0.0625, -0.3125);
    public static class_243 OFFSET_WEST = new class_243(-0.3125, -0.0625, 0.0);
    public static class_243 OFFSET_SOUTH = new class_243(0.0, -0.0625, 0.3125);
    public static class_243 OFFSET_EAST = new class_243(0.3125, -0.0625, 0.0);
    public static class_243 IN_VERTICAL_OFFSET_NORTH = new class_243(0.3125, 0.0, -0.0625);
    public static class_243 IN_VERTICAL_OFFSET_WEST = new class_243(-0.0625, 0.0, -0.3125);
    public static class_243 IN_VERTICAL_OFFSET_SOUTH = new class_243(-0.3125, 0.0, 0.0625);
    public static class_243 IN_VERTICAL_OFFSET_EAST = new class_243(0.0625, 0.0, 0.3125);
    public static class_243 OUT_VERTICAL_OFFSET_NORTH = new class_243(-0.3125, 0.0, -0.0625);
    public static class_243 OUT_VERTICAL_OFFSET_WEST = new class_243(-0.0625, 0.0, 0.3125);
    public static class_243 OUT_VERTICAL_OFFSET_SOUTH = new class_243(0.3125, 0.0, 0.0625);
    public static class_243 OUT_VERTICAL_OFFSET_EAST = new class_243(0.0625, 0.0, -0.3125);
    public static final int NODE_COUNT = 8;

    public RedstoneRelayTileEntity(class_2591<?> tileEntityTypeIn, class_2338 pos, class_2680 state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> list) {
    }

    @Override
    @Nullable
    public IWireNode getWireNode(int index) {
        return IWireNode.getWireNodeFrom(index, this, this.localNodes, this.nodeCache, this.field_11863);
    }

    @Override
    @Nullable
    public LocalNode getLocalNode(int index) {
        return this.localNodes[index];
    }

    @Override
    public void setNode(int index, int other, class_2338 pos, WireType type) {
        this.localNodes[index] = new LocalNode((class_2586)this, index, other, type, pos);
        this.notifyUpdate();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
    }

    @Override
    public void removeNode(int index, boolean dropWire) {
        LocalNode old = this.localNodes[index];
        this.localNodes[index] = null;
        this.invalidateNodeCache();
        this.notifyUpdate();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
        if (dropWire && old != null) {
            this.wireCache.add(old);
        }
    }

    @Override
    public int getNodeCount() {
        return 8;
    }

    @Override
    public class_243 getNodeOffset(int node) {
        boolean vertical = (Boolean)this.method_11010().method_11654((class_2769)RedstoneRelayBlock.VERTICAL);
        class_2350 direction = (class_2350)this.method_11010().method_11654((class_2769)RedstoneRelayBlock.HORIZONTAL_FACING);
        if (node > 3) {
            return switch (direction) {
                case class_2350.field_11043 -> {
                    if (vertical) {
                        yield OUT_VERTICAL_OFFSET_NORTH;
                    }
                    yield OFFSET_NORTH;
                }
                case class_2350.field_11039 -> {
                    if (vertical) {
                        yield OUT_VERTICAL_OFFSET_WEST;
                    }
                    yield OFFSET_WEST;
                }
                case class_2350.field_11035 -> {
                    if (vertical) {
                        yield OUT_VERTICAL_OFFSET_SOUTH;
                    }
                    yield OFFSET_SOUTH;
                }
                case class_2350.field_11034 -> {
                    if (vertical) {
                        yield OUT_VERTICAL_OFFSET_EAST;
                    }
                    yield OFFSET_EAST;
                }
                default -> OFFSET_NORTH;
            };
        }
        return switch (direction) {
            case class_2350.field_11043 -> {
                if (vertical) {
                    yield IN_VERTICAL_OFFSET_NORTH;
                }
                yield OFFSET_SOUTH;
            }
            case class_2350.field_11039 -> {
                if (vertical) {
                    yield IN_VERTICAL_OFFSET_WEST;
                }
                yield OFFSET_EAST;
            }
            case class_2350.field_11035 -> {
                if (vertical) {
                    yield IN_VERTICAL_OFFSET_SOUTH;
                }
                yield OFFSET_NORTH;
            }
            case class_2350.field_11034 -> {
                if (vertical) {
                    yield IN_VERTICAL_OFFSET_EAST;
                }
                yield OFFSET_WEST;
            }
            default -> OFFSET_NORTH;
        };
    }

    @Override
    public int getAvailableNode(class_243 pos) {
        class_2350 dir = (class_2350)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)RedstoneRelayBlock.HORIZONTAL_FACING);
        boolean vertical = (Boolean)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)RedstoneRelayBlock.VERTICAL);
        boolean upper = true;
        pos = pos.method_1023((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260());
        if (vertical) {
            switch (dir) {
                case field_11043: {
                    upper = pos.method_10216() < 0.5;
                    break;
                }
                case field_11039: {
                    upper = pos.method_10215() > 0.5;
                    break;
                }
                case field_11035: {
                    upper = pos.method_10216() > 0.5;
                    break;
                }
                case field_11034: {
                    upper = pos.method_10215() < 0.5;
                    break;
                }
            }
        } else {
            switch (dir) {
                case field_11043: {
                    upper = pos.method_10215() < 0.5;
                    break;
                }
                case field_11039: {
                    upper = pos.method_10216() < 0.5;
                    break;
                }
                case field_11035: {
                    upper = pos.method_10215() > 0.5;
                    break;
                }
                case field_11034: {
                    upper = pos.method_10216() > 0.5;
                    break;
                }
            }
        }
        for (int i = upper ? 4 : 0; i < (upper ? 8 : 4); ++i) {
            if (this.hasConnection(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isNodeInput(int node) {
        return node < 4;
    }

    @Override
    public boolean isNodeOutput(int node) {
        return !this.isNodeInput(node);
    }

    @Override
    public class_2338 getPos() {
        return this.method_11016();
    }

    @Override
    public EnergyNetwork getNetwork(int node) {
        return this.isNodeInput(node) ? this.networkIn : this.networkOut;
    }

    @Override
    public void setNetwork(int node, EnergyNetwork network) {
        if (this.isNodeInput(node)) {
            this.networkIn = network;
        }
        if (this.isNodeOutput(node)) {
            this.networkOut = network;
        }
    }

    public void read(class_2487 nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (!clientPacket && nbt.method_10545("node0")) {
            this.convertOldNbt(nbt);
            this.method_5431();
        }
        this.invalidateLocalNodes();
        this.invalidateNodeCache();
        class_2499 nodes = nbt.method_10554("nodes", 10);
        nodes.forEach(tag -> {
            LocalNode localNode;
            this.localNodes[localNode.getIndex()] = localNode = new LocalNode((class_2586)this, (class_2487)tag);
        });
        if (nbt.method_10545("contraption") && !clientPacket) {
            this.wasContraption = nbt.method_10577("contraption");
            NodeRotation rotation = (NodeRotation)((Object)this.method_11010().method_11654(NodeRotation.ROTATION));
            if (rotation != NodeRotation.NONE) {
                this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657(NodeRotation.ROTATION, (Comparable)((Object)NodeRotation.NONE)), 0);
            }
            for (LocalNode localNode : this.localNodes) {
                if (localNode == null) continue;
                localNode.updateRelative(rotation);
            }
        }
        if (!nodes.isEmpty() && this.networkIn != null && this.networkOut != null) {
            this.networkIn.invalidate();
            this.networkOut.invalidate();
        }
    }

    public void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        class_2499 nodes = new class_2499();
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode localNode = this.localNodes[i];
            if (localNode == null) continue;
            class_2487 tag = new class_2487();
            localNode.write(tag);
            nodes.add((Object)tag);
        }
        nbt.method_10566("nodes", (class_2520)nodes);
    }

    private void validateNodes() {
        boolean changed = this.validateLocalNodes(this.localNodes);
        this.notifyUpdate();
        if (changed) {
            this.invalidateNodeCache();
            if (this.networkIn != null) {
                this.networkIn.invalidate();
            }
            if (this.networkOut != null) {
                this.networkOut.invalidate();
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.firstTick) {
            this.firstTick = false;
            if (this.wasContraption && !this.field_11863.method_8608()) {
                this.wasContraption = false;
                this.validateNodes();
            }
        }
        if (!this.wireCache.isEmpty() && !this.method_11015()) {
            this.handleWireCache(this.field_11863, this.wireCache);
        }
        if (this.field_11863.method_8608()) {
            return;
        }
        this.networkTick();
    }

    private void networkTick() {
        if (this.awakeNetwork(this.field_11863)) {
            this.notifyUpdate();
        }
        class_2680 bs = this.method_11010();
        this.throughput = 0L;
        if (!bs.method_27852((class_2248)CABlocks.REDSTONE_RELAY.get())) {
            return;
        }
        if (((Boolean)bs.method_11654((class_2769)RedstoneRelayBlock.POWERED)).booleanValue()) {
            this.throughput = this.networkOut.push(this.networkIn.pull(this.demand));
            this.demand = this.networkIn.demand(this.networkOut.getDemand());
        }
    }

    public long getThroughput() {
        return this.throughput;
    }

    public void remove() {
        if (this.field_11863.method_8608()) {
            return;
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            IWireNode otherNode;
            LocalNode localNode = this.getLocalNode(i);
            if (localNode == null || (otherNode = this.getWireNode(i)) == null) continue;
            int ourNode = localNode.getOtherIndex();
            if (localNode.isInvalid()) {
                otherNode.removeNode(ourNode);
                continue;
            }
            otherNode.removeNode(ourNode, true);
        }
        this.invalidateNodeCache();
        this.invalidateCaps();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
    }

    public void invalidateLocalNodes() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.localNodes[i] = null;
        }
    }

    @Override
    public void invalidateNodeCache() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.nodeCache[i] = null;
        }
    }

    @Override
    public boolean isNodeIndicesConnected(int in, int other) {
        return this.isNodeInput(in) == this.isNodeInput(other);
    }

    public long getDemand() {
        return this.demand;
    }

    @Override
    public void onObserved(class_3222 player, ObservePacket pack) {
        if (this.isNetworkValid(pack.node())) {
            EnergyNetworkPacket.send(this.field_11867, this.getNetwork(pack.node()).getPulled(), this.getNetwork(pack.node()).getPushed(), player);
        }
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        class_239 ray = class_310.method_1551().field_1765;
        if (ray == null) {
            return false;
        }
        int node = this.getAvailableNode(ray.method_17784());
        ObservePacket.send(this.field_11867, node);
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2588("createaddition.tooltip.relay.info").method_27692(class_124.field_1068)));
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2588("createaddition.tooltip.energy.selected").method_27692(class_124.field_1080)));
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2585(" ")).method_10852((class_2561)new class_2588(this.isNodeInput(node) ? "createaddition.tooltip.energy.input" : "createaddition.tooltip.energy.output").method_27692(class_124.field_1075)));
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2588("createaddition.tooltip.energy.usage").method_27692(class_124.field_1080)));
        tooltip.add((class_2561)new class_2585("    ").method_27693(" ").method_27693(Util.format(EnergyNetworkPacket.clientBuff)).method_27693("fe/t").method_27692(class_124.field_1075));
        return true;
    }
}

